/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.api.logging;

import org.hawkular.apm.api.utils.PropertyUtil;

public class Logger {
    private static Level level = Level.valueOf(PropertyUtil.getProperty("HAWKULAR_APM_LOG_LEVEL", Level.INFO.name()));
    private static boolean logToJUL = Boolean.getBoolean("HAWKULAR_APM_LOG_JUL");
    private static java.util.logging.Logger logger = null;
    private String className;
    private String simpleClassName = null;

    protected Logger(String className) {
        this.className = className;
        int index = className.lastIndexOf(46);
        if (index != -1) {
            this.simpleClassName = className.substring(index + 1);
        }
    }

    public static Logger getLogger(String className) {
        return new Logger(className);
    }

    public boolean isLoggable(Level l) {
        return l.ordinal() >= level.ordinal();
    }

    public void finest(String mesg) {
        this.log(Level.FINEST, mesg, null);
    }

    public void finer(String mesg) {
        this.log(Level.FINER, mesg, null);
    }

    public void fine(String mesg) {
        this.log(Level.FINE, mesg, null);
    }

    public void info(String mesg) {
        this.log(Level.INFO, mesg, null);
    }

    public void warning(String mesg) {
        this.log(Level.WARNING, mesg, null);
    }

    public void severe(String mesg) {
        this.log(Level.SEVERE, mesg, null);
    }

    public void log(Level mesgLevel, String mesg, Throwable t) {
        if (mesgLevel.ordinal() >= level.ordinal()) {
            StringBuilder builder = new StringBuilder();
            builder.append(mesgLevel.name());
            builder.append(": [");
            builder.append(this.simpleClassName != null ? this.simpleClassName : this.className);
            builder.append("] [");
            builder.append(Thread.currentThread());
            builder.append("] ");
            builder.append(mesg);
            if (mesgLevel == Level.SEVERE) {
                if (logger != null) {
                    logger.log(java.util.logging.Level.SEVERE, builder.toString(), t);
                } else {
                    System.err.println(builder.toString());
                }
            } else if (logger != null) {
                logger.info(builder.toString());
            } else {
                System.out.println(builder.toString());
            }
            if (t != null) {
                t.printStackTrace();
            }
        }
    }

    static {
        if (logToJUL) {
            logger = java.util.logging.Logger.getLogger(Logger.class.getName());
        }
    }

    public static enum Level {
        FINEST,
        FINER,
        FINE,
        INFO,
        WARNING,
        SEVERE;

    }
}

