/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.client.collector.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.hawkular.apm.api.model.config.btxn.BusinessTxnConfig;

public class FilterProcessor {
    private String businessTransaction;
    private BusinessTxnConfig config;
    private List<Predicate<String>> inclusions = new ArrayList<Predicate<String>>();
    private List<Predicate<String>> exclusions = new ArrayList<Predicate<String>>();

    protected FilterProcessor() {
    }

    public FilterProcessor(String btxn, BusinessTxnConfig config) {
        this.businessTransaction = btxn;
        this.config = config;
        this.init();
    }

    protected void init() {
        int i;
        for (i = 0; i < this.config.getFilter().getInclusions().size(); ++i) {
            this.inclusions.add(Pattern.compile(this.config.getFilter().getInclusions().get(i)).asPredicate());
        }
        for (i = 0; i < this.config.getFilter().getExclusions().size(); ++i) {
            this.exclusions.add(Pattern.compile(this.config.getFilter().getExclusions().get(i)).asPredicate());
        }
    }

    public String getBusinessTransaction() {
        return this.businessTransaction;
    }

    public void setBusinessTransaction(String businessTransaction) {
        this.businessTransaction = businessTransaction;
    }

    public BusinessTxnConfig getConfig() {
        return this.config;
    }

    public void setConfig(BusinessTxnConfig config) {
        this.config = config;
    }

    public boolean isIncludeAll() {
        return this.inclusions.isEmpty();
    }

    public boolean isIncluded(String endpoint) {
        for (int i = 0; i < this.inclusions.size(); ++i) {
            if (!this.inclusions.get(i).test(endpoint)) continue;
            return true;
        }
        return false;
    }

    public boolean isExcluded(String endpoint) {
        for (int i = 0; i < this.exclusions.size(); ++i) {
            if (!this.exclusions.get(i).test(endpoint)) continue;
            return true;
        }
        return false;
    }
}

