/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.client.collector.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.hawkular.apm.api.logging.Logger;
import org.hawkular.apm.api.model.config.CollectorConfiguration;
import org.hawkular.apm.api.model.trace.Trace;
import org.hawkular.apm.api.services.ServiceResolver;
import org.hawkular.apm.api.services.TracePublisher;
import org.hawkular.apm.api.utils.PropertyUtil;

public class TraceReporter {
    private static final int DEFAULT_BATCH_THREAD_POOL_SIZE = 5;
    private static final String HAWKULAR_APM_TENANT_ID = "HAWKULAR_APM_TENANTID";
    private static final Logger log = Logger.getLogger(TraceReporter.class.getName());
    private static final int DEFAULT_BATCH_TIME = 500;
    private static final int DEFAULT_BATCH_SIZE = 1000;
    private TracePublisher tracePublisher;
    private int batchSize = 1000;
    private int batchTime = 500;
    private String tenantId = PropertyUtil.getProperty("HAWKULAR_APM_TENANTID");
    private ExecutorService executor;
    private final ReentrantLock lock = new ReentrantLock();
    private List<Trace> traces = new ArrayList<Trace>();

    public TraceReporter() {
        this.executor = Executors.newFixedThreadPool(5, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setDaemon(true);
                return t;
            }
        });
        this.setTracePublisher(ServiceResolver.getSingletonService(TracePublisher.class));
    }

    public void setTracePublisher(TracePublisher tp) {
        this.tracePublisher = tp;
    }

    public TracePublisher getTracePublisher() {
        return this.tracePublisher;
    }

    public void init(CollectorConfiguration config) {
        if (config != null) {
            String time;
            String size;
            if (log.isLoggable(Logger.Level.FINE)) {
                log.fine("Initializing TraceReporter with collector configuration");
            }
            if ((size = config.getProperty("HAWKULAR_APM_COLLECTOR_BATCHSIZE", null)) != null) {
                this.batchSize = Integer.parseInt(size);
            }
            if ((time = config.getProperty("HAWKULAR_APM_COLLECTOR_BATCHTIME", null)) != null) {
                this.batchTime = Integer.parseInt(time);
            }
            this.tenantId = config.getProperty(HAWKULAR_APM_TENANT_ID, null);
            String pool = config.getProperty("HAWKULAR_APM_COLLECTOR_BATCHTHREADS", null);
            if (pool != null) {
                this.executor = Executors.newFixedThreadPool(Integer.parseInt(pool));
            }
        }
        Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setDaemon(true);
                return t;
            }
        }).scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (!TraceReporter.this.traces.isEmpty()) {
                    try {
                        TraceReporter.this.lock.lock();
                        TraceReporter.this.submitTraces();
                    }
                    finally {
                        TraceReporter.this.lock.unlock();
                    }
                }
            }
        }, this.batchTime, this.batchTime, TimeUnit.MILLISECONDS);
    }

    public boolean isEnabled() {
        return this.tracePublisher != null;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void report(Trace trace) {
        if (this.tracePublisher != null) {
            try {
                this.lock.lock();
                this.traces.add(trace);
                if (this.traces.size() < this.batchSize) return;
                this.submitTraces();
                return;
            }
            finally {
                this.lock.unlock();
            }
        } else {
            log.warning("Trace service is not available!");
        }
    }

    protected void submitTraces() {
        if (!this.traces.isEmpty()) {
            final List<Trace> toSend = this.traces;
            this.traces = new ArrayList<Trace>();
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        TraceReporter.this.tracePublisher.publish(TraceReporter.this.tenantId, toSend);
                    }
                    catch (Exception e) {
                        log.log(Logger.Level.SEVERE, "Failed to publish traces", e);
                    }
                }
            });
        }
    }
}

