/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.performance.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.hawkular.apm.api.model.trace.Trace;
import org.hawkular.apm.api.services.PublisherMetricHandler;
import org.hawkular.apm.api.services.ServiceResolver;
import org.hawkular.apm.api.services.TracePublisher;
import org.hawkular.apm.performance.server.DefaultServiceRegistry;
import org.hawkular.apm.performance.server.Message;
import org.hawkular.apm.performance.server.Metrics;
import org.hawkular.apm.performance.server.PathConfiguration;
import org.hawkular.apm.performance.server.Service;
import org.hawkular.apm.performance.server.SystemConfiguration;

public class ClientSimulator {
    private static final Logger log = Logger.getLogger(ClientSimulator.class.getName());
    private SystemConfiguration systemConfig;
    private int invocations;
    private int requesters;
    private String name;

    public static void main(String[] args) {
        if (args.length != 4) {
            System.err.println("Usage: APMClientSimulator configFile invocations requesters name");
            System.err.println("    configFile - json format description of services");
            System.err.println("    invocations - number of invocations per requester");
            System.err.println("    requesters - number of concurrent requesters");
            System.err.println("    name - the simulator name, used to name the report file");
            System.exit(1);
        }
        ClientSimulator cs = null;
        try {
            cs = new ClientSimulator(args[0], Integer.parseInt(args[1]), Integer.parseInt(args[2]), args[3]);
            cs.run();
        }
        catch (Exception e1) {
            System.err.println("Error: " + e1);
        }
    }

    public ClientSimulator(String configFile, int invocations, int requesters, String name) throws Exception {
        this.init(configFile);
        this.invocations = invocations;
        this.requesters = requesters;
        this.name = name;
    }

    protected void init(String configFile) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        this.systemConfig = mapper.readValue(new File(configFile), SystemConfiguration.class);
    }

    public void run() {
        final Metrics metrics = new Metrics(this.name);
        final DefaultServiceRegistry reg = new DefaultServiceRegistry(this.systemConfig, metrics);
        final ArrayList<PathConfiguration> paths = new ArrayList<PathConfiguration>();
        for (PathConfiguration pc : this.systemConfig.getPaths()) {
            for (int i = 0; i < pc.getWeight(); ++i) {
                paths.add(pc);
            }
        }
        TracePublisher publisher = ServiceResolver.getSingletonService(TracePublisher.class);
        if (publisher == null) {
            log.severe("Trace publisher has not been configured correctly");
            return;
        }
        publisher.setMetricHandler(new PublisherMetricHandler<Trace>(){

            @Override
            public void published(String tenantId, List<Trace> items, long metric) {
                metrics.publishTraces(metric);
            }
        });
        Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setDaemon(true);
                return t;
            }
        }).scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                metrics.report();
            }
        }, 1L, 1L, TimeUnit.SECONDS);
        for (int i = 0; i < this.requesters; ++i) {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    System.out.println("THREAD: " + Thread.currentThread() + ": STARTED");
                    for (int j = 0; j < ClientSimulator.this.invocations; ++j) {
                        int index = (int)(Math.random() * (double)(paths.size() - 1));
                        Service s = reg.getServiceInstance(((PathConfiguration)paths.get(index)).getService());
                        Message m = new Message(((PathConfiguration)paths.get(index)).getName());
                        s.call(m, null, null);
                    }
                    System.out.println("THREAD: " + Thread.currentThread() + ": FINISHED: " + new Date());
                    4 var1_2 = this;
                    synchronized (var1_2) {
                        try {
                            this.wait(2000L);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }).start();
        }
    }
}

