/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.performance.server;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.UUID;
import org.hawkular.apm.api.utils.PropertyUtil;
import org.hawkular.apm.performance.server.Metrics;
import org.hawkular.apm.performance.server.Service;
import org.hawkular.apm.performance.server.ServiceConfiguration;
import org.hawkular.apm.performance.server.ServiceRegistry;
import org.hawkular.apm.performance.server.SystemConfiguration;

public class DefaultServiceRegistry
implements ServiceRegistry {
    private static final int DEFAULT_SERVICE_EXPIRY_INTERVAL = 10000;
    private Map<String, ServiceConfiguration> serviceConfigs = new HashMap<String, ServiceConfiguration>();
    private Map<String, Stack<Service>> services = new HashMap<String, Stack<Service>>();
    private Metrics metrics;
    private long expiryInterval = 10000L;

    public DefaultServiceRegistry(SystemConfiguration sysConfig, Metrics metrics) {
        this.metrics = metrics;
        for (ServiceConfiguration serviceConfig : sysConfig.getServices()) {
            this.serviceConfigs.put(serviceConfig.getName(), serviceConfig);
        }
        this.expiryInterval = PropertyUtil.getPropertyAsInteger("SERVICE_EXPIRY_INTERVAL", 10000).intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Service getServiceInstance(String name) {
        Stack<Service> stack = null;
        Object object = this.services;
        synchronized (object) {
            stack = this.services.get(name);
            if (stack == null) {
                stack = new Stack();
                this.services.put(name, stack);
            }
        }
        object = stack;
        synchronized (object) {
            if (stack.isEmpty()) {
                return this.newServiceInstance(name);
            }
            Service service = stack.pop();
            if (System.currentTimeMillis() - service.getLastUsed() > this.expiryInterval) {
                for (int i = 0; i < stack.size(); ++i) {
                    this.metrics.closeService(name);
                }
                stack.clear();
                return this.newServiceInstance(name);
            }
            return service;
        }
    }

    protected Service newServiceInstance(String name) {
        this.metrics.createService(name);
        ServiceConfiguration serviceConfig = this.serviceConfigs.get(name);
        return new Service(name, serviceConfig.getUri(), UUID.randomUUID().toString(), this, serviceConfig.getCalledServices());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnServiceInstance(Service service) {
        Stack<Service> stack = null;
        Object object = this.services;
        synchronized (object) {
            stack = this.services.get(service.getName());
            if (stack == null) {
                stack = new Stack();
                this.services.put(service.getName(), stack);
            }
        }
        object = stack;
        synchronized (object) {
            stack.push(service);
        }
    }
}

