/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.performance.server;

public class Metrics {
    private String name;
    private int serviceCount = 0;
    private int maxServiceCount = 0;
    private int minServiceCount = 0;
    private long publishTracesDuration = 0L;
    private int publishTracesCount = 0;

    public Metrics(String name) {
        this.setName(name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public synchronized void createService(String name) {
        ++this.serviceCount;
        if (this.serviceCount > this.maxServiceCount) {
            this.maxServiceCount = this.serviceCount;
        }
    }

    public synchronized void closeService(String name) {
        --this.serviceCount;
        if (this.serviceCount < this.minServiceCount) {
            this.minServiceCount = this.serviceCount;
        }
    }

    public synchronized void publishTraces(long duration) {
        this.publishTracesDuration += duration;
        ++this.publishTracesCount;
    }

    public synchronized void report() {
        long avg = 0L;
        if (this.publishTracesCount > 0) {
            avg = this.publishTracesDuration / (long)this.publishTracesCount;
        }
        System.out.println("[" + this.name + "] service max=" + this.maxServiceCount + " min=" + this.minServiceCount + " publish avg=" + avg + " count=" + this.publishTracesCount);
        this.minServiceCount = this.maxServiceCount = this.serviceCount;
        this.publishTracesCount = 0;
        this.publishTracesDuration = 0L;
    }
}

