/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.performance.server;

import java.util.Map;
import java.util.UUID;
import org.hawkular.apm.client.collector.DefaultTraceCollector;
import org.hawkular.apm.performance.server.Message;
import org.hawkular.apm.performance.server.ServiceRegistry;

public class Service {
    private DefaultTraceCollector collector = new DefaultTraceCollector();
    private String uri;
    private String id;
    private String name;
    private Map<String, String> calledServices;
    private long lastUsed = System.currentTimeMillis();
    private ServiceRegistry registry;

    public Service(String name, String uri, String id, ServiceRegistry reg, Map<String, String> calledServices) {
        this.uri = uri;
        this.name = name;
        this.id = id;
        this.setRegistry(reg);
        this.calledServices = calledServices;
    }

    public DefaultTraceCollector getCollector() {
        return this.collector;
    }

    public void setCollector(DefaultTraceCollector collector) {
        this.collector = collector;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Map<String, String> getCalledServices() {
        return this.calledServices;
    }

    public void setCalledServices(Map<String, String> calledServices) {
        this.calledServices = calledServices;
    }

    public ServiceRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(ServiceRegistry registry) {
        this.registry = registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void call(Message mesg, String interactionId, String btxnName) {
        boolean activated = this.collector.activate(this.uri, null, interactionId);
        if (activated) {
            this.collector.consumerStart(null, this.uri, "Test", null, interactionId);
            this.collector.setBusinessTransaction(null, btxnName);
        }
        if (this.calledServices != null) {
            String calledServiceName = this.calledServices.get(mesg.getType());
            Service service = this;
            synchronized (service) {
                try {
                    this.wait((int)Math.random() % 300 + 50);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (calledServiceName != null) {
                Service calledService = this.registry.getServiceInstance(calledServiceName);
                String nextInteractionId = UUID.randomUUID().toString();
                if (activated) {
                    this.collector.producerStart(null, calledService.getUri(), "Test", null, nextInteractionId);
                }
                Service service2 = this;
                synchronized (service2) {
                    try {
                        this.wait((int)Math.random() % 100 + 10);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                calledService.call(mesg, nextInteractionId, this.collector.getBusinessTransaction());
                if (activated) {
                    this.collector.producerEnd(null, calledService.getUri(), "Test", null);
                }
            }
        }
        if (activated) {
            this.collector.consumerEnd(null, this.uri, "Test", null);
        }
        this.setLastUsed(System.currentTimeMillis());
        this.registry.returnServiceInstance(this);
    }

    public long getLastUsed() {
        return this.lastUsed;
    }

    public void setLastUsed(long lastUsed) {
        this.lastUsed = lastUsed;
    }
}

