/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.server.api.task;

import java.util.List;
import org.hawkular.apm.api.utils.PropertyUtil;
import org.hawkular.apm.server.api.task.Processor;
import org.hawkular.apm.server.api.task.RetryAttemptException;

public abstract class AbstractProcessor<T, R>
implements Processor<T, R> {
    private static final int DEFAULT_RETRY_DELAY = 2000;
    private static final int DEFAULT_LAST_RETRY_DELAY = 10000;
    private long retryDelay = PropertyUtil.getPropertyAsInteger("HAWKULAR_APM_PROCESSOR_RETRY_DELAY", 2000).intValue();
    private long lastRetryDelay = PropertyUtil.getPropertyAsInteger("HAWKULAR_APM_PROCESSOR_LAST_RETRY_DELAY", 10000).intValue();
    private Processor.ProcessorType type;

    public AbstractProcessor(Processor.ProcessorType type) {
        this.type = type;
    }

    @Override
    public Processor.ProcessorType getType() {
        return this.type;
    }

    @Override
    public void initialise(String tenantId, List<T> items) throws RetryAttemptException {
    }

    @Override
    public long getDeliveryDelay(List<R> results) {
        return 0L;
    }

    @Override
    public long getRetryDelay(List<T> items, int retryCount) {
        if (retryCount == 0) {
            return this.lastRetryDelay;
        }
        return this.retryDelay;
    }

    @Override
    public boolean isReportRetryExpirationAsWarning() {
        return true;
    }

    @Override
    public R processOneToOne(String tenantId, T item) throws RetryAttemptException {
        return null;
    }

    @Override
    public List<R> processOneToMany(String tenantId, T item) throws RetryAttemptException {
        return null;
    }

    @Override
    public List<R> processManyToMany(String tenantId, List<T> items) throws RetryAttemptException {
        return null;
    }

    @Override
    public void cleanup(String tenantId, List<T> items) {
    }
}

