/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.server.api.utils.zipkin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.http.impl.EnglishReasonPhraseCatalog;
import org.hawkular.apm.server.api.model.zipkin.BinaryAnnotation;
import org.hawkular.apm.server.api.model.zipkin.Span;

public class SpanHttpDeriverUtil {
    private static final Logger log = Logger.getLogger(SpanHttpDeriverUtil.class.getName());
    private static final Set<String> HTTP_METHODS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("GET", "PUT", "POST", "DELETE", "HEAD", "TRACE", "OPTIONS")));
    protected static final String ZIPKIN_HTTP_URL_KEY = "http.url";
    protected static final String ZIPKIN_HTTP_CODE_KEY = "http.status_code";

    private SpanHttpDeriverUtil() {
    }

    public static List<HttpCode> getHttpStatusCodes(List<BinaryAnnotation> binaryAnnotations) {
        if (binaryAnnotations == null) {
            return Collections.emptyList();
        }
        ArrayList<HttpCode> httpCodes = new ArrayList<HttpCode>();
        for (BinaryAnnotation binaryAnnotation : binaryAnnotations) {
            String strHttpCode;
            Integer httpCode;
            if (!ZIPKIN_HTTP_CODE_KEY.equals(binaryAnnotation.getKey()) || binaryAnnotation.getValue() == null || (httpCode = SpanHttpDeriverUtil.toInt((strHttpCode = binaryAnnotation.getValue()).trim())) == null) continue;
            String description = EnglishReasonPhraseCatalog.INSTANCE.getReason(httpCode, Locale.ENGLISH);
            httpCodes.add(new HttpCode(httpCode, description));
        }
        return httpCodes;
    }

    public static List<HttpCode> getClientOrServerErrors(List<HttpCode> httpCodes) {
        return httpCodes.stream().filter(x -> x.isClientOrServerError()).collect(Collectors.toList());
    }

    public static String getHttpMethod(Span span) {
        if (SpanHttpDeriverUtil.isHttp(span)) {
            BinaryAnnotation ba = span.getBinaryAnnotation("http.method");
            String httpMethod = null;
            if (ba != null) {
                httpMethod = ba.getValue().toUpperCase();
            } else if (span.getName() != null) {
                httpMethod = span.getName().toUpperCase();
            }
            if (HTTP_METHODS.contains(httpMethod)) {
                return httpMethod;
            }
        }
        return null;
    }

    public static boolean isHttp(Span span) {
        return span.getBinaryAnnotation(ZIPKIN_HTTP_URL_KEY) != null;
    }

    private static Integer toInt(String str) {
        Integer num = null;
        try {
            num = Integer.parseInt(str);
        }
        catch (NumberFormatException ex) {
            log.severe(String.format("failed to convert str: %s to integer", str));
        }
        return num;
    }

    public static class HttpCode {
        private int code;
        private String description;

        public HttpCode(int code, String description) {
            this.code = code;
            this.description = description;
        }

        public boolean isClientOrServerError() {
            return this.code >= 400;
        }

        public int getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof HttpCode)) {
                return false;
            }
            HttpCode httpCode = (HttpCode)o;
            return this.code == httpCode.code;
        }

        public int hashCode() {
            return this.code;
        }
    }
}

