/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.server.api.utils.zipkin;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hawkular.apm.api.model.Property;

public class MappingResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String componentType;
    private final String endpointType;
    private final List<Property> properties;

    public MappingResult(String componentType, String endpointType, List<Property> properties) {
        this.componentType = componentType;
        this.endpointType = endpointType;
        this.properties = Collections.unmodifiableList(properties);
    }

    public MappingResult() {
        this.componentType = null;
        this.endpointType = null;
        this.properties = Collections.emptyList();
    }

    public String getComponentType() {
        return this.componentType;
    }

    public String getEndpointType() {
        return this.endpointType;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MappingResult)) {
            return false;
        }
        MappingResult that = (MappingResult)o;
        if (this.componentType != null ? !this.componentType.equals(that.componentType) : that.componentType != null) {
            return false;
        }
        if (this.endpointType != null ? !this.endpointType.equals(that.endpointType) : that.endpointType != null) {
            return false;
        }
        return this.properties != null ? this.properties.equals(that.properties) : that.properties == null;
    }

    public int hashCode() {
        int result = this.componentType != null ? this.componentType.hashCode() : 0;
        result = 31 * result + (this.endpointType != null ? this.endpointType.hashCode() : 0);
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private String componentType;
        private String endpointType;
        private List<Property> properties = new ArrayList<Property>();

        private Builder() {
        }

        public Builder withComponentType(String componentType) {
            this.componentType = componentType;
            return this;
        }

        public Builder withEndpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        public Builder withProperties(List<Property> properties) {
            this.properties = properties;
            return this;
        }

        public Builder addProperty(Property property) {
            this.properties.add(property);
            return this;
        }

        public MappingResult build() {
            return new MappingResult(this.componentType, this.endpointType, this.properties);
        }
    }
}

