/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.server.api.model.zipkin;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.hawkular.apm.server.api.model.zipkin.Annotation;
import org.hawkular.apm.server.api.model.zipkin.BinaryAnnotation;
import org.hawkular.apm.server.api.model.zipkin.Endpoint;
import org.hawkular.apm.server.api.utils.zipkin.BinaryAnnotationMappingDeriver;
import org.hawkular.apm.server.api.utils.zipkin.MappingResult;

public class Span
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(Span.class.getName());
    private String traceId;
    private String name;
    private String id;
    private String parentId;
    private List<Annotation> annotations = Collections.emptyList();
    private final List<BinaryAnnotation> binaryAnnotations;
    private Boolean debug;
    private Long timestamp;
    private Long duration;
    private final MappingResult mappingResult;
    private String service;
    private String ipv4;
    private URL url;

    public Span() {
        this(null, null);
    }

    @JsonCreator
    public Span(@JsonProperty(value="binaryAnnotations") List<BinaryAnnotation> binaryAnnotations, @JsonProperty(value="annotations") List<Annotation> annotations) {
        this.binaryAnnotations = Collections.unmodifiableList(binaryAnnotations == null ? Collections.emptyList() : binaryAnnotations);
        this.annotations = Collections.unmodifiableList(annotations == null ? Collections.emptyList() : annotations);
        this.mappingResult = BinaryAnnotationMappingDeriver.getInstance().mappingResult(binaryAnnotations);
        this.initUrl();
        this.initIpv4AndService();
    }

    public Span(Span span, List<BinaryAnnotation> binaryAnnotations, List<Annotation> annotations) {
        this(binaryAnnotations, annotations);
        this.id = span.getId();
        this.traceId = span.getTraceId();
        this.parentId = span.getParentId();
        this.timestamp = span.getTimestamp();
        this.duration = span.getDuration();
        this.debug = span.getDebug();
        this.name = span.getName();
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public List<BinaryAnnotation> getBinaryAnnotations() {
        return this.binaryAnnotations;
    }

    public Boolean getDebug() {
        return this.debug;
    }

    public void setDebug(Boolean debug) {
        this.debug = debug;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public Long getDuration() {
        return this.duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public boolean topLevelSpan() {
        return this.getParentId() == null || this.getParentId().equals(this.getId());
    }

    public boolean clientSpan() {
        boolean csPresent = false;
        boolean crPresent = false;
        for (int i = 0; i < this.annotations.size(); ++i) {
            if (this.annotations.get(i).getValue().equals("cs")) {
                csPresent = true;
            } else if (this.annotations.get(i).getValue().equals("cr")) {
                crPresent = true;
            }
            if (csPresent && crPresent) break;
        }
        return csPresent && crPresent;
    }

    public boolean serverSpan() {
        boolean srPresent = false;
        boolean ssPresent = false;
        for (int i = 0; i < this.annotations.size(); ++i) {
            if (this.annotations.get(i).getValue().equals("sr")) {
                srPresent = true;
            } else if (this.annotations.get(i).getValue().equals("ss")) {
                ssPresent = true;
            }
            if (srPresent && ssPresent) break;
        }
        return srPresent && ssPresent;
    }

    public BinaryAnnotation getBinaryAnnotation(String key) {
        for (int i = 0; i < this.binaryAnnotations.size(); ++i) {
            BinaryAnnotation ba = this.binaryAnnotations.get(i);
            if (!ba.getKey().equals(key)) continue;
            return ba;
        }
        return null;
    }

    public MappingResult binaryAnnotationMapping() {
        return this.mappingResult;
    }

    public String ipv4() {
        return this.ipv4;
    }

    public String service() {
        return this.service;
    }

    public URL url() {
        return this.url;
    }

    private void initUrl() {
        BinaryAnnotation httpUrl = this.getBinaryAnnotation("http.url");
        if (httpUrl == null) {
            httpUrl = this.getBinaryAnnotation("http.uri");
        }
        if (httpUrl == null) {
            httpUrl = this.getBinaryAnnotation("http.path");
        }
        if (httpUrl != null) {
            try {
                this.url = new URL(httpUrl.getValue());
            }
            catch (MalformedURLException e) {
                try {
                    this.url = new URL("http", null, httpUrl.getValue());
                }
                catch (MalformedURLException e1) {
                    log.log(Level.SEVERE, "Failed to decode URL", e);
                }
            }
        }
    }

    private void initIpv4AndService() {
        Endpoint endpoint;
        if (this.annotations == null) {
            return;
        }
        Set endpoints = this.annotations.stream().filter(annotation -> annotation.getEndpoint() != null).map(Annotation::getEndpoint).collect(Collectors.toSet());
        if (endpoints.size() > 1) {
            log.finest("Multiple different Endpoints within one Span: " + endpoints);
        }
        Endpoint endpoint2 = endpoint = endpoints.size() > 0 ? (Endpoint)endpoints.iterator().next() : null;
        if (endpoint != null) {
            this.ipv4 = endpoint.getIpv4();
            this.service = endpoint.getServiceName();
        }
    }

    public String toString() {
        return "Span [traceId=" + this.traceId + ", name=" + this.name + ", id=" + this.id + ", parentId=" + this.parentId + ", annotations=" + this.annotations + ", binaryAnnotations=" + this.binaryAnnotations + ", debug=" + this.debug + ", timestamp=" + this.timestamp + ", duration=" + this.duration + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Span)) {
            return false;
        }
        Span span = (Span)o;
        if (this.traceId != null ? !this.traceId.equals(span.traceId) : span.traceId != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(span.name) : span.name != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(span.id) : span.id != null) {
            return false;
        }
        if (this.parentId != null ? !this.parentId.equals(span.parentId) : span.parentId != null) {
            return false;
        }
        if (this.annotations != null ? !this.annotations.equals(span.annotations) : span.annotations != null) {
            return false;
        }
        if (this.binaryAnnotations != null ? !this.binaryAnnotations.equals(span.binaryAnnotations) : span.binaryAnnotations != null) {
            return false;
        }
        if (this.debug != null ? !this.debug.equals(span.debug) : span.debug != null) {
            return false;
        }
        if (this.timestamp != null ? !this.timestamp.equals(span.timestamp) : span.timestamp != null) {
            return false;
        }
        if (this.duration != null ? !this.duration.equals(span.duration) : span.duration != null) {
            return false;
        }
        if (this.mappingResult != null ? !this.mappingResult.equals(span.mappingResult) : span.mappingResult != null) {
            return false;
        }
        if (this.service != null ? !this.service.equals(span.service) : span.service != null) {
            return false;
        }
        if (this.ipv4 != null ? !this.ipv4.equals(span.ipv4) : span.ipv4 != null) {
            return false;
        }
        return this.url != null ? this.url.equals(span.url) : span.url == null;
    }

    public int hashCode() {
        int result = this.traceId != null ? this.traceId.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.parentId != null ? this.parentId.hashCode() : 0);
        result = 31 * result + (this.annotations != null ? this.annotations.hashCode() : 0);
        result = 31 * result + (this.binaryAnnotations != null ? this.binaryAnnotations.hashCode() : 0);
        result = 31 * result + (this.debug != null ? this.debug.hashCode() : 0);
        result = 31 * result + (this.timestamp != null ? this.timestamp.hashCode() : 0);
        result = 31 * result + (this.duration != null ? this.duration.hashCode() : 0);
        result = 31 * result + (this.mappingResult != null ? this.mappingResult.hashCode() : 0);
        result = 31 * result + (this.service != null ? this.service.hashCode() : 0);
        result = 31 * result + (this.ipv4 != null ? this.ipv4.hashCode() : 0);
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        return result;
    }
}

