/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.server.api.utils.zipkin;

import java.util.ArrayList;
import java.util.List;
import org.hawkular.apm.api.model.Property;
import org.hawkular.apm.server.api.model.zipkin.BinaryAnnotation;
import org.hawkular.apm.server.api.utils.zipkin.AnnotationTypeUtil;
import org.hawkular.apm.server.api.utils.zipkin.BinaryAnnotationMapping;
import org.hawkular.apm.server.api.utils.zipkin.BinaryAnnotationMappingStorage;
import org.hawkular.apm.server.api.utils.zipkin.MappingResult;

public class BinaryAnnotationMappingDeriver {
    private static Object LOCK = new Object();
    private static BinaryAnnotationMappingDeriver instance;
    private final BinaryAnnotationMappingStorage mappingStorage;

    private BinaryAnnotationMappingDeriver() {
        this.mappingStorage = new BinaryAnnotationMappingStorage();
    }

    private BinaryAnnotationMappingDeriver(String path) {
        this.mappingStorage = new BinaryAnnotationMappingStorage(path);
    }

    public static BinaryAnnotationMappingDeriver getInstance() {
        return BinaryAnnotationMappingDeriver.getInstance(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BinaryAnnotationMappingDeriver getInstance(String path) {
        if (instance == null) {
            Object object = LOCK;
            synchronized (object) {
                if (instance == null) {
                    instance = path == null ? new BinaryAnnotationMappingDeriver() : new BinaryAnnotationMappingDeriver(path);
                }
            }
        }
        return instance;
    }

    public MappingResult mappingResult(List<BinaryAnnotation> binaryAnnotations) {
        if (binaryAnnotations == null) {
            return new MappingResult();
        }
        ArrayList<String> componentTypes = new ArrayList<String>();
        ArrayList<String> endpointTypes = new ArrayList<String>();
        MappingResult.Builder mappingBuilder = MappingResult.builder();
        for (BinaryAnnotation binaryAnnotation : binaryAnnotations) {
            BinaryAnnotationMapping mapping;
            if (binaryAnnotation.getKey() == null || (mapping = this.mappingStorage.getKeyBasedMappings().get(binaryAnnotation.getKey())) != null && mapping.isIgnore()) continue;
            if (mapping == null || mapping.getProperty() == null) {
                mappingBuilder.addProperty(new Property(binaryAnnotation.getKey(), binaryAnnotation.getValue(), AnnotationTypeUtil.toPropertyType(binaryAnnotation.getType())));
            }
            if (mapping == null) continue;
            if (mapping.getComponentType() != null) {
                componentTypes.add(mapping.getComponentType());
            }
            if (mapping.getEndpointType() != null) {
                endpointTypes.add(mapping.getEndpointType());
            }
            if (mapping.getProperty() == null || mapping.getProperty().isExclude()) continue;
            String key = mapping.getProperty().getKey() != null ? mapping.getProperty().getKey() : binaryAnnotation.getKey();
            mappingBuilder.addProperty(new Property(key, binaryAnnotation.getValue(), AnnotationTypeUtil.toPropertyType(binaryAnnotation.getType())));
        }
        if (!componentTypes.isEmpty()) {
            mappingBuilder.withComponentType((String)componentTypes.get(0));
        }
        if (!endpointTypes.isEmpty()) {
            mappingBuilder.withEndpointType((String)endpointTypes.get(0));
        }
        return mappingBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearStorage() {
        Object object = LOCK;
        synchronized (object) {
            instance = null;
        }
    }
}

