/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.server.elasticsearch;

import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.hawkular.apm.api.model.events.CompletionTime;
import org.hawkular.apm.api.model.events.NodeDetails;
import org.hawkular.apm.api.model.trace.CorrelationIdentifier;
import org.hawkular.apm.api.services.Criteria;

public class ElasticsearchUtil {
    public static BoolQueryBuilder buildQuery(Criteria criteria, String timeProperty, String businessTxnProperty, Class<?> targetClass) {
        long startTime = criteria.calculateStartTime();
        long endTime = criteria.calculateEndTime();
        BoolQueryBuilder query = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.rangeQuery((String)timeProperty).from(startTime).to(endTime));
        if (criteria.getBusinessTransaction() != null && !criteria.getBusinessTransaction().trim().isEmpty()) {
            query = query.must((QueryBuilder)QueryBuilders.termQuery((String)businessTxnProperty, (String)criteria.getBusinessTransaction()));
        }
        if (!criteria.getProperties().isEmpty()) {
            for (Criteria.PropertyCriteria pc : criteria.getProperties()) {
                if (pc.getOperator() == Criteria.Operator.HAS || pc.getOperator() == Criteria.Operator.HASNOT || pc.getOperator() == Criteria.Operator.EQ || pc.getOperator() == Criteria.Operator.NE) {
                    BoolQueryBuilder nestedQuery = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"properties.name", (Object)pc.getName())).must((QueryBuilder)QueryBuilders.matchQuery((String)"properties.value", (Object)pc.getValue()));
                    if (pc.getOperator() == Criteria.Operator.HASNOT || pc.getOperator() == Criteria.Operator.NE) {
                        query = query.mustNot((QueryBuilder)QueryBuilders.nestedQuery((String)"properties", (QueryBuilder)nestedQuery));
                        continue;
                    }
                    query = query.must((QueryBuilder)QueryBuilders.nestedQuery((String)"properties", (QueryBuilder)nestedQuery));
                    continue;
                }
                RangeQueryBuilder rangeQuery = null;
                if (pc.getOperator() == Criteria.Operator.GTE) {
                    rangeQuery = QueryBuilders.rangeQuery((String)"properties.number").gte(pc.getValue());
                } else if (pc.getOperator() == Criteria.Operator.GT) {
                    rangeQuery = QueryBuilders.rangeQuery((String)"properties.number").gt(pc.getValue());
                } else if (pc.getOperator() == Criteria.Operator.LTE) {
                    rangeQuery = QueryBuilders.rangeQuery((String)"properties.number").lte(pc.getValue());
                } else if (pc.getOperator() == Criteria.Operator.LT) {
                    rangeQuery = QueryBuilders.rangeQuery((String)"properties.number").lt(pc.getValue());
                } else {
                    throw new IllegalArgumentException("Unknown property criteria operator: " + pc);
                }
                BoolQueryBuilder nestedQuery = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"properties.name", (Object)pc.getName())).must((QueryBuilder)rangeQuery);
                query = query.must((QueryBuilder)QueryBuilders.nestedQuery((String)"properties", (QueryBuilder)nestedQuery));
            }
        }
        if (criteria.getHostName() != null && !criteria.getHostName().trim().isEmpty()) {
            query = query.must((QueryBuilder)QueryBuilders.matchQuery((String)"hostName", (Object)criteria.getHostName()));
        }
        if (criteria.getPrincipal() != null && !criteria.getPrincipal().trim().isEmpty()) {
            query = query.must((QueryBuilder)QueryBuilders.matchQuery((String)"principal", (Object)criteria.getPrincipal()));
        }
        if (!criteria.getCorrelationIds().isEmpty()) {
            for (CorrelationIdentifier id : criteria.getCorrelationIds()) {
                query.must((QueryBuilder)QueryBuilders.termQuery((String)"value", (String)id.getValue()));
            }
        }
        if (!criteria.getFaults().isEmpty()) {
            for (Criteria.FaultCriteria fc : criteria.getFaults()) {
                if (fc.getOperator() == Criteria.Operator.HASNOT) {
                    query = query.mustNot((QueryBuilder)QueryBuilders.matchQuery((String)"fault", (Object)fc.getValue()));
                    continue;
                }
                query = query.must((QueryBuilder)QueryBuilders.matchQuery((String)"fault", (Object)fc.getValue()));
            }
        }
        if (criteria.getLowerBound() > 0L || criteria.getUpperBound() > 0L) {
            RangeQueryBuilder rangeQuery = QueryBuilders.rangeQuery((String)"duration");
            if (criteria.getLowerBound() > 0L) {
                rangeQuery.gte(criteria.getLowerBound());
            }
            if (criteria.getUpperBound() > 0L) {
                rangeQuery.lte(criteria.getUpperBound());
            }
            query = query.must((QueryBuilder)rangeQuery);
        }
        if (targetClass == NodeDetails.class || targetClass == CompletionTime.class) {
            if (criteria.getUri() != null && !criteria.getUri().trim().isEmpty()) {
                query = query.must((QueryBuilder)QueryBuilders.matchQuery((String)"uri", (Object)criteria.getUri()));
            }
            if (criteria.getOperation() != null && !criteria.getOperation().trim().isEmpty()) {
                query = query.must((QueryBuilder)QueryBuilders.matchQuery((String)"operation", (Object)criteria.getOperation()));
            }
        }
        return query;
    }

    public static FilterBuilder buildFilter(Criteria criteria) {
        if (criteria.getBusinessTransaction() != null && criteria.getBusinessTransaction().trim().isEmpty()) {
            return FilterBuilders.missingFilter((String)"businessTransaction");
        }
        return null;
    }
}

