/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.server.elasticsearch;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequestBuilder;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.sort.SortOrder;
import org.hawkular.apm.api.model.Property;
import org.hawkular.apm.api.model.trace.Node;
import org.hawkular.apm.api.model.trace.Producer;
import org.hawkular.apm.api.model.trace.Trace;
import org.hawkular.apm.api.services.Criteria;
import org.hawkular.apm.api.services.StoreException;
import org.hawkular.apm.api.services.TraceService;
import org.hawkular.apm.api.utils.NodeUtil;
import org.hawkular.apm.server.api.services.SpanService;
import org.hawkular.apm.server.elasticsearch.ElasticsearchClient;
import org.hawkular.apm.server.elasticsearch.ElasticsearchUtil;
import org.hawkular.apm.server.elasticsearch.log.MsgLogger;

public class TraceServiceElasticsearch
implements TraceService {
    private static final MsgLogger msgLog = MsgLogger.LOGGER;
    private static final String START_TIME_FIELD = "startTime";
    private static final String NODES_FIELD = "nodes";
    private static final String PRINCIPAL_FIELD = "principal";
    private static final String ID_FIELD = "id";
    private static final String HOST_NAME_FIELD = "hostName";
    private static final String HOST_ADDRESS_FIELD = "hostAddress";
    private static final String BUSINESS_TRANSACTION_FIELD = "businessTransaction";
    private static final String PROPERTIES_FIELD = "properties";
    public static final String TRACE_TYPE = "trace";
    private static final ObjectMapper mapper = new ObjectMapper();
    private SpanService spanService;
    private ElasticsearchClient client = ElasticsearchClient.getSingleton();

    public TraceServiceElasticsearch() {
    }

    @Inject
    public TraceServiceElasticsearch(SpanService spanService) {
        this.spanService = spanService;
    }

    public ElasticsearchClient getElasticsearchClient() {
        return this.client;
    }

    public void setElasticsearchClient(ElasticsearchClient client) {
        this.client = client;
    }

    public Trace getFragment(String tenantId, String id) {
        Trace ret = null;
        GetResponse response = (GetResponse)this.client.getClient().prepareGet(this.client.getIndex(tenantId), TRACE_TYPE, id).setRouting(id).execute().actionGet();
        if (!response.isSourceEmpty()) {
            try {
                ret = (Trace)mapper.readValue(response.getSourceAsString(), Trace.class);
            }
            catch (Exception e) {
                msgLog.errorFailedToParse(e);
            }
        }
        if (msgLog.isTraceEnabled()) {
            msgLog.tracef("Get fragment with id[%s] is: %s", id, ret);
        }
        return ret;
    }

    public Trace getTrace(String tenantId, String id) {
        Trace ret = this.getFragment(tenantId, id);
        if (ret != null) {
            this.processConnectedFragment(tenantId, ret, ret, null);
        }
        if (msgLog.isTraceEnabled()) {
            msgLog.tracef("Get trace with id[%s] is: %s", id, ret);
        }
        if (ret == null && this.spanService != null) {
            ret = this.spanService.getTrace(tenantId, id);
        }
        return ret;
    }

    protected void processConnectedFragment(String tenantId, Trace root, Trace fragment, Producer producer) {
        if (producer != null) {
            producer.getNodes().addAll(fragment.getNodes());
        }
        ArrayList producers = new ArrayList();
        NodeUtil.findNodes((List)fragment.getNodes(), Producer.class, producers);
        for (Producer p : producers) {
            if (p.getCorrelationIds().isEmpty()) continue;
            Criteria criteria = new Criteria().setStartTime(100L);
            criteria.getCorrelationIds().addAll(p.getCorrelationIds());
            List<Trace> fragments = this.searchFragments(tenantId, criteria);
            for (Trace tf : fragments) {
                this.processConnectedFragment(tenantId, root, tf, p);
            }
        }
    }

    public List<Trace> searchFragments(String tenantId, Criteria criteria) {
        return TraceServiceElasticsearch.internalQuery(this.client, tenantId, criteria);
    }

    protected static List<Trace> internalQuery(ElasticsearchClient client, String tenantId, Criteria criteria) {
        ArrayList<Trace> ret;
        block10: {
            ret = new ArrayList<Trace>();
            String index = client.getIndex(tenantId);
            try {
                SearchResponse response;
                RefreshRequestBuilder refreshRequestBuilder = client.getClient().admin().indices().prepareRefresh(new String[]{index});
                client.getClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
                BoolQueryBuilder query = ElasticsearchUtil.buildQuery(criteria, START_TIME_FIELD, BUSINESS_TRANSACTION_FIELD, Trace.class);
                SearchRequestBuilder request = client.getClient().prepareSearch(new String[]{index}).setTypes(new String[]{TRACE_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setTimeout(TimeValue.timeValueMillis((long)criteria.getTimeout())).setSize(criteria.getMaxResponseSize()).setQuery((QueryBuilder)query).addSort(START_TIME_FIELD, SortOrder.ASC);
                FilterBuilder filter = ElasticsearchUtil.buildFilter(criteria);
                if (filter != null) {
                    request.setPostFilter(filter);
                }
                if ((response = (SearchResponse)request.execute().actionGet()).isTimedOut()) {
                    msgLog.warnQueryTimedOut();
                }
                for (SearchHit searchHitFields : response.getHits()) {
                    try {
                        ret.add((Trace)mapper.readValue(searchHitFields.getSourceAsString(), Trace.class));
                    }
                    catch (Exception e) {
                        msgLog.errorFailedToParse(e);
                    }
                }
                if (msgLog.isTraceEnabled()) {
                    msgLog.tracef("Query traces with criteria[%s] is: %s", criteria, ret);
                }
            }
            catch (IndexMissingException ime) {
                if (msgLog.isTraceEnabled()) {
                    msgLog.tracef("No index found, so unable to retrieve traces", new Object[0]);
                }
            }
            catch (SearchPhaseExecutionException spee) {
                if (!msgLog.isTraceEnabled()) break block10;
                msgLog.tracef("Failed to get fragments", (Object)spee);
            }
        }
        return ret;
    }

    public void storeFragments(String tenantId, List<Trace> traces) throws StoreException {
        this.client.initTenant(tenantId);
        BulkRequestBuilder bulkRequestBuilder = this.client.getClient().prepareBulk();
        try {
            for (int i = 0; i < traces.size(); ++i) {
                Trace trace = traces.get(i);
                String json = mapper.writeValueAsString((Object)trace);
                if (msgLog.isTraceEnabled()) {
                    msgLog.tracef("Storing trace: %s", json);
                }
                bulkRequestBuilder.add(this.client.getClient().prepareIndex(this.client.getIndex(tenantId), TRACE_TYPE, trace.getId()).setSource(json));
            }
        }
        catch (JsonProcessingException e) {
            throw new StoreException((Throwable)e);
        }
        BulkResponse bulkItemResponses = (BulkResponse)bulkRequestBuilder.execute().actionGet();
        if (bulkItemResponses.hasFailures()) {
            if (msgLog.isTraceEnabled()) {
                msgLog.trace("Failed to store traces to elasticsearch: " + bulkItemResponses.buildFailureMessage());
            }
            throw new StoreException(bulkItemResponses.buildFailureMessage());
        }
        if (msgLog.isTraceEnabled()) {
            msgLog.trace("Success storing traces to elasticsearch");
        }
    }

    public void clear(String tenantId) {
        String index = this.client.getIndex(tenantId);
        try {
            this.client.getClient().admin().indices().prepareDelete(new String[]{index}).execute().actionGet();
            this.client.clear(tenantId);
        }
        catch (IndexMissingException indexMissingException) {
            // empty catch block
        }
    }

    static {
        SimpleModule module = new SimpleModule();
        module.addSerializer(Trace.class, (JsonSerializer)new TraceSerializer());
        module.addDeserializer(Trace.class, (JsonDeserializer)new TraceDeserializer());
        mapper.registerModule((Module)module);
    }

    public static class TraceDeserializer
    extends JsonDeserializer<Trace> {
        public Trace deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
            Trace trace = new Trace();
            String field = parser.nextFieldName();
            while (field != null) {
                if (field.equals(TraceServiceElasticsearch.PROPERTIES_FIELD)) {
                    parser.nextValue();
                    while (parser.nextValue() == JsonToken.START_OBJECT) {
                        context.readValue(parser, Property.class);
                    }
                    parser.nextValue();
                } else if (field.equals(TraceServiceElasticsearch.BUSINESS_TRANSACTION_FIELD)) {
                    trace.setBusinessTransaction(parser.nextTextValue());
                } else if (field.equals(TraceServiceElasticsearch.HOST_ADDRESS_FIELD)) {
                    trace.setHostAddress(parser.nextTextValue());
                } else if (field.equals(TraceServiceElasticsearch.HOST_NAME_FIELD)) {
                    trace.setHostName(parser.nextTextValue());
                } else if (field.equals(TraceServiceElasticsearch.ID_FIELD)) {
                    trace.setId(parser.nextTextValue());
                } else if (field.equals(TraceServiceElasticsearch.PRINCIPAL_FIELD)) {
                    trace.setPrincipal(parser.nextTextValue());
                } else if (field.equals(TraceServiceElasticsearch.NODES_FIELD)) {
                    parser.nextValue();
                    while (parser.nextValue() == JsonToken.START_OBJECT) {
                        trace.getNodes().add(context.readValue(parser, Node.class));
                    }
                    parser.nextValue();
                } else if (field.equals(TraceServiceElasticsearch.START_TIME_FIELD)) {
                    trace.setStartTime(parser.nextLongValue(0L));
                }
                field = parser.nextFieldName();
            }
            return trace;
        }
    }

    public static class TraceSerializer
    extends JsonSerializer<Trace> {
        public void serialize(Trace trace, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            jgen.writeStringField(TraceServiceElasticsearch.BUSINESS_TRANSACTION_FIELD, trace.getBusinessTransaction());
            jgen.writeStringField(TraceServiceElasticsearch.HOST_ADDRESS_FIELD, trace.getHostAddress());
            jgen.writeStringField(TraceServiceElasticsearch.HOST_NAME_FIELD, trace.getHostName());
            jgen.writeStringField(TraceServiceElasticsearch.ID_FIELD, trace.getId());
            jgen.writeStringField(TraceServiceElasticsearch.PRINCIPAL_FIELD, trace.getPrincipal());
            jgen.writeNumberField(TraceServiceElasticsearch.START_TIME_FIELD, trace.getStartTime());
            jgen.writeArrayFieldStart(TraceServiceElasticsearch.NODES_FIELD);
            for (Node n : trace.getNodes()) {
                jgen.writeObject((Object)n);
            }
            jgen.writeEndArray();
            Set properties = trace.allProperties();
            jgen.writeArrayFieldStart(TraceServiceElasticsearch.PROPERTIES_FIELD);
            for (Property p : properties) {
                jgen.writeObject((Object)p);
            }
            jgen.writeEndArray();
            jgen.writeEndObject();
        }
    }
}

