/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.server.elasticsearch;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequestBuilder;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.search.SearchHit;
import org.hawkular.apm.api.model.Property;
import org.hawkular.apm.api.model.trace.Component;
import org.hawkular.apm.api.model.trace.Consumer;
import org.hawkular.apm.api.model.trace.InteractionNode;
import org.hawkular.apm.api.model.trace.Node;
import org.hawkular.apm.api.model.trace.Producer;
import org.hawkular.apm.api.model.trace.Trace;
import org.hawkular.apm.api.services.StoreException;
import org.hawkular.apm.api.utils.NodeUtil;
import org.hawkular.apm.server.api.model.zipkin.BinaryAnnotation;
import org.hawkular.apm.server.api.model.zipkin.Span;
import org.hawkular.apm.server.api.services.SpanService;
import org.hawkular.apm.server.api.utils.zipkin.SpanUniqueIdGenerator;
import org.hawkular.apm.server.elasticsearch.ElasticsearchClient;
import org.hawkular.apm.server.elasticsearch.log.MsgLogger;

public class SpanServiceElasticsearch
implements SpanService {
    private static final MsgLogger log = MsgLogger.LOGGER;
    public static final String SPAN_TYPE = "span";
    private static final ObjectMapper mapper = new ObjectMapper();
    private ElasticsearchClient client = ElasticsearchClient.getSingleton();

    public Span getSpan(String tenantId, String id) {
        GetResponse response = null;
        try {
            response = (GetResponse)this.client.getClient().prepareGet(this.client.getIndex(tenantId), SPAN_TYPE, id).setRouting(id).execute().actionGet();
        }
        catch (IndexMissingException ex) {
            log.errorf("Missing span index %s", tenantId);
            return null;
        }
        Span span = null;
        if (!response.isSourceEmpty()) {
            try {
                Span clientSpan;
                span = this.deserialize(response.getSourceAsString(), Span.class);
                if (span.serverSpan() && span.url() == null && (clientSpan = this.getSpan(tenantId, SpanUniqueIdGenerator.getClientId((String)span.getId()))) != null && clientSpan.url() != null) {
                    BinaryAnnotation httpURLAnnotation = new BinaryAnnotation();
                    httpURLAnnotation.setKey("http.url");
                    httpURLAnnotation.setValue(clientSpan.url().toString());
                    ArrayList<BinaryAnnotation> binaryAnnotationsWithURL = new ArrayList<BinaryAnnotation>(span.getBinaryAnnotations());
                    binaryAnnotationsWithURL.add(httpURLAnnotation);
                    span = new Span(span, binaryAnnotationsWithURL, span.getAnnotations());
                }
            }
            catch (IOException ex) {
                log.errorFailedToParse(ex);
            }
        }
        log.tracef("Get span with id[%s] is: %s", id, span);
        return span;
    }

    public List<Span> getChildren(String tenantId, String id) {
        ArrayList<Span> spans = new ArrayList<Span>();
        String index = this.client.getIndex(tenantId);
        try {
            RefreshRequestBuilder refreshRequestBuilder = this.client.getClient().admin().indices().prepareRefresh(new String[]{index});
            this.client.getClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
            TermQueryBuilder query = QueryBuilders.termQuery((String)"parentId", (String)id);
            SearchRequestBuilder request = this.client.getClient().prepareSearch(new String[]{index}).setTypes(new String[]{SPAN_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setQuery((QueryBuilder)query);
            SearchResponse response = (SearchResponse)request.execute().actionGet();
            for (SearchHit searchHitFields : response.getHits()) {
                try {
                    Span span = this.deserialize(searchHitFields.getSourceAsString(), Span.class);
                    if (span.serverSpan()) continue;
                    spans.add(span);
                }
                catch (IOException ex) {
                    log.errorFailedToParse(ex);
                }
            }
        }
        catch (IndexMissingException ex) {
            log.errorf("No index[%s] found, so unable to retrieve spans", index);
        }
        log.tracef("Get children with parentId[%s] is: %s", id, spans);
        return spans;
    }

    public void storeSpan(String tenantId, List<Span> spans) throws StoreException {
        this.storeSpan(tenantId, spans, span -> span.getId());
    }

    public void storeSpan(String tenantId, List<Span> spans, Function<Span, String> spanIdSupplier) throws StoreException {
        this.client.initTenant(tenantId);
        BulkRequestBuilder bulkRequestBuilder = this.client.getClient().prepareBulk();
        for (Span span : spans) {
            String json;
            try {
                json = this.serialize(span);
            }
            catch (IOException ex) {
                log.errorf("Failed to serialize span %s", span);
                throw new StoreException((Throwable)ex);
            }
            log.tracef("Storing span: %s", json);
            String modifiedId = spanIdSupplier.apply(span);
            bulkRequestBuilder.add(this.client.getClient().prepareIndex(this.client.getIndex(tenantId), SPAN_TYPE, modifiedId).setSource(json));
        }
        BulkResponse bulkItemResponses = (BulkResponse)bulkRequestBuilder.execute().actionGet();
        if (bulkItemResponses.hasFailures()) {
            log.tracef("Failed to store spans to elasticsearch: %s", bulkItemResponses.buildFailureMessage());
            throw new StoreException(bulkItemResponses.buildFailureMessage());
        }
        log.trace("Success storing spans to elasticsearch");
    }

    public void clear(String tenantId) {
        this.client.clearTenant(tenantId);
    }

    public Trace getTraceFragment(String tenantId, String id) {
        Span span = this.getSpan(tenantId, id);
        if (span == null) {
            return null;
        }
        InteractionNode interactionNode = this.spanToNode(span);
        interactionNode.setNodes(this.recursiveTraceFragment(tenantId, span));
        Trace trace = this.spanToTrace(span);
        trace.getNodes().add(interactionNode);
        return trace;
    }

    public Trace getTrace(String tenantId, String id) {
        Trace trace;
        String clientId;
        Span span = this.getSpan(tenantId, id);
        if ((span == null || span.serverSpan()) && this.getSpan(tenantId, clientId = SpanUniqueIdGenerator.getClientId((String)id)) != null) {
            id = clientId;
        }
        if ((trace = this.getTraceFragment(tenantId, id)) != null) {
            this.processConnectedFragment(tenantId, trace);
        }
        return trace;
    }

    protected void processConnectedFragment(String tenantId, Trace fragment) {
        List producers = NodeUtil.findNodes((List)fragment.getNodes(), Producer.class);
        for (Producer producer : producers) {
            if (producer.getCorrelationIds().isEmpty()) continue;
            List<Trace> fragments = this.getTraceFragments(tenantId, producer.getCorrelationIds().stream().map(correlationIdentifier -> correlationIdentifier.getValue()).collect(Collectors.toList()));
            for (Trace descendant : fragments) {
                producer.getNodes().addAll(descendant.getNodes());
                this.processConnectedFragment(tenantId, descendant);
            }
        }
    }

    private List<Trace> getTraceFragments(String tenantId, List<String> ids) {
        ArrayList<Trace> traces = new ArrayList<Trace>();
        for (String id : ids) {
            Trace traceFragment = this.getTraceFragment(tenantId, id);
            if (traceFragment == null) continue;
            traces.add(traceFragment);
        }
        return traces;
    }

    private List<Node> recursiveTraceFragment(String tenantId, Span parent) {
        List<Span> spanChildren = this.getChildren(tenantId, parent.getId());
        if (spanChildren == null) {
            return Collections.emptyList();
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Span child : spanChildren) {
            InteractionNode node = this.spanToNode(child);
            if (!parent.clientSpan()) {
                nodes.add((Node)node);
            }
            if (child.clientSpan()) continue;
            node.setNodes(this.recursiveTraceFragment(tenantId, child));
        }
        return nodes;
    }

    private Trace spanToTrace(Span span) {
        if (span == null) {
            throw new NullPointerException();
        }
        Trace trace = new Trace();
        trace.setId(span.getId());
        trace.setStartTime(span.getTimestamp() != null ? span.getTimestamp() : 0L);
        trace.setHostAddress(span.ipv4());
        return trace;
    }

    private InteractionNode spanToNode(Span span) {
        Component node;
        String url;
        String string = url = span.url() != null ? span.url().getPath() : null;
        if (span.binaryAnnotationMapping().getComponentType() != null) {
            node = new Component(url, span.binaryAnnotationMapping().getComponentType());
        } else if (span.serverSpan()) {
            node = new Consumer(url, span.binaryAnnotationMapping().getEndpointType());
            node.addInteractionCorrelationId(span.getId());
        } else if (span.clientSpan()) {
            node = new Producer(url, span.binaryAnnotationMapping().getEndpointType());
            node.addInteractionCorrelationId(span.getId());
        } else {
            node = new Component(url, null);
        }
        node.setProperties(new HashSet(span.binaryAnnotationMapping().getProperties()));
        node.getProperties().add(new Property("service", span.service()));
        node.setDetails(new HashMap(span.binaryAnnotationMapping().getNodeDetails()));
        if (span.getTimestamp() != null) {
            node.setBaseTime(TimeUnit.NANOSECONDS.convert(span.getTimestamp(), TimeUnit.MICROSECONDS));
        }
        if (span.getDuration() != null) {
            node.setDuration(TimeUnit.NANOSECONDS.convert(span.getDuration(), TimeUnit.MICROSECONDS));
        }
        return node;
    }

    private <T> T deserialize(String json, Class<T> type) throws IOException {
        JsonParser parser = mapper.getFactory().createParser(json);
        return (T)parser.readValueAs(type);
    }

    private String serialize(Object object) throws IOException {
        StringWriter out = new StringWriter();
        JsonGenerator gen = mapper.getFactory().createGenerator((Writer)out);
        gen.writeObject(object);
        gen.close();
        out.close();
        return out.toString();
    }
}

