/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.server.elasticsearch;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequestBuilder;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.AdminClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryFilterBuilder;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.filter.Filter;
import org.elasticsearch.search.aggregations.bucket.filter.FilterAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.filter.InternalFilter;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogram;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramBuilder;
import org.elasticsearch.search.aggregations.bucket.missing.Missing;
import org.elasticsearch.search.aggregations.bucket.missing.MissingBuilder;
import org.elasticsearch.search.aggregations.bucket.nested.Nested;
import org.elasticsearch.search.aggregations.bucket.nested.NestedBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.elasticsearch.search.aggregations.metrics.avg.Avg;
import org.elasticsearch.search.aggregations.metrics.avg.AvgBuilder;
import org.elasticsearch.search.aggregations.metrics.percentiles.PercentilesBuilder;
import org.elasticsearch.search.aggregations.metrics.stats.Stats;
import org.elasticsearch.search.aggregations.metrics.stats.StatsBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.hawkular.apm.api.model.analytics.Cardinality;
import org.hawkular.apm.api.model.analytics.CommunicationSummaryStatistics;
import org.hawkular.apm.api.model.analytics.NodeSummaryStatistics;
import org.hawkular.apm.api.model.analytics.NodeTimeseriesStatistics;
import org.hawkular.apm.api.model.analytics.Percentiles;
import org.hawkular.apm.api.model.analytics.PropertyInfo;
import org.hawkular.apm.api.model.analytics.TimeseriesStatistics;
import org.hawkular.apm.api.model.analytics.TransactionInfo;
import org.hawkular.apm.api.model.config.txn.TransactionConfig;
import org.hawkular.apm.api.model.events.ApmEvent;
import org.hawkular.apm.api.model.events.CommunicationDetails;
import org.hawkular.apm.api.model.events.CompletionTime;
import org.hawkular.apm.api.model.events.NodeDetails;
import org.hawkular.apm.api.model.trace.Trace;
import org.hawkular.apm.api.services.AbstractAnalyticsService;
import org.hawkular.apm.api.services.ConfigurationService;
import org.hawkular.apm.api.services.Criteria;
import org.hawkular.apm.api.services.StoreException;
import org.hawkular.apm.api.utils.EndpointUtil;
import org.hawkular.apm.server.elasticsearch.ElasticsearchClient;
import org.hawkular.apm.server.elasticsearch.ElasticsearchUtil;
import org.hawkular.apm.server.elasticsearch.TraceServiceElasticsearch;
import org.hawkular.apm.server.elasticsearch.log.MsgLogger;

public class AnalyticsServiceElasticsearch
extends AbstractAnalyticsService {
    private static final MsgLogger msgLog = MsgLogger.LOGGER;
    private static final String COMMUNICATION_DETAILS_TYPE = "communicationdetails";
    private static final String NODE_DETAILS_TYPE = "nodedetails";
    private static final String TRACE_COMPLETION_TIME_TYPE = "tracecompletion";
    private static final ObjectMapper mapper = new ObjectMapper();
    private static ElasticsearchClient client = ElasticsearchClient.getSingleton();
    @Inject
    private ConfigurationService configService;

    protected List<Trace> getFragments(String tenantId, Criteria criteria) {
        return TraceServiceElasticsearch.internalQuery(client, tenantId, criteria);
    }

    public List<TransactionInfo> getTransactionInfo(String tenantId, Criteria criteria) {
        String index = client.getIndex(tenantId);
        if (!AnalyticsServiceElasticsearch.refresh(index)) {
            return null;
        }
        if (criteria.getTransaction() != null) {
            criteria = new Criteria(criteria);
            criteria.setTransaction(null);
        }
        TermsBuilder cardinalityBuilder = ((TermsBuilder)AggregationBuilders.terms((String)"cardinality").field("transaction")).order(Terms.Order.aggregation((String)"_count", (boolean)false)).size(criteria.getMaxResponseSize());
        BoolQueryBuilder query = ElasticsearchUtil.buildQuery(criteria, "transaction", Trace.class);
        SearchRequestBuilder request = this.getBaseSearchRequestBuilder("trace", index, criteria, query, 0).addAggregation((AbstractAggregationBuilder)cardinalityBuilder);
        SearchResponse response = AnalyticsServiceElasticsearch.getSearchResponse(request);
        Terms terms = (Terms)response.getAggregations().get("cardinality");
        List<TransactionInfo> txnInfo = terms.getBuckets().stream().map(AnalyticsServiceElasticsearch::toTransactionInfo).collect(Collectors.toList());
        if (this.configService != null) {
            Map btcs = this.configService.getTransactions(tenantId, 0L);
            txnInfo.forEach(ti -> {
                TransactionConfig btc = (TransactionConfig)btcs.get(ti.getName());
                if (btc != null) {
                    ti.setLevel(btc.getLevel());
                    ti.setStaticConfig(true);
                    btcs.remove(ti.getName());
                }
            });
            btcs.forEach((k, v) -> txnInfo.add(new TransactionInfo().setName(k).setLevel(v.getLevel()).setStaticConfig(true)));
        }
        Collections.sort(txnInfo, new Comparator<TransactionInfo>(){

            @Override
            public int compare(TransactionInfo ti1, TransactionInfo ti2) {
                return ti1.getName().compareTo(ti2.getName());
            }
        });
        return txnInfo;
    }

    public List<PropertyInfo> getPropertyInfo(String tenantId, Criteria criteria) {
        String index = client.getIndex(tenantId);
        if (!AnalyticsServiceElasticsearch.refresh(index)) {
            return null;
        }
        BoolQueryBuilder query = ElasticsearchUtil.buildQuery(criteria, "transaction", CompletionTime.class);
        TermsBuilder cardinalityBuilder = ((TermsBuilder)AggregationBuilders.terms((String)"cardinality").field("properties.name")).order(Terms.Order.aggregation((String)"_count", (boolean)false)).size(criteria.getMaxResponseSize());
        NestedBuilder nestedBuilder = (NestedBuilder)AggregationBuilders.nested((String)"nested").path("properties").subAggregation((AbstractAggregationBuilder)cardinalityBuilder);
        SearchRequestBuilder request = this.getTraceCompletionRequest(index, criteria, query, 0).addAggregation((AbstractAggregationBuilder)nestedBuilder);
        SearchResponse response = AnalyticsServiceElasticsearch.getSearchResponse(request);
        Nested nested = (Nested)response.getAggregations().get("nested");
        Terms terms = (Terms)nested.getAggregations().get("cardinality");
        return terms.getBuckets().stream().map(AnalyticsServiceElasticsearch::toPropertyInfo).sorted((one, another) -> one.getName().compareTo(another.getName())).collect(Collectors.toList());
    }

    public long getTraceCompletionCount(String tenantId, Criteria criteria) {
        return this.getTraceCompletionCount(tenantId, criteria, false);
    }

    public long getTraceCompletionFaultCount(String tenantId, Criteria criteria) {
        return this.getTraceCompletionCount(tenantId, criteria, true);
    }

    public List<CompletionTime> getTraceCompletions(String tenantId, Criteria criteria) {
        String index = client.getIndex(tenantId);
        if (!AnalyticsServiceElasticsearch.refresh(index)) {
            return null;
        }
        BoolQueryBuilder query = ElasticsearchUtil.buildQuery(criteria, "transaction", CompletionTime.class);
        SearchRequestBuilder request = this.getTraceCompletionRequest(index, criteria, query, criteria.getMaxResponseSize());
        request.addSort("timestamp", SortOrder.DESC);
        SearchResponse response = AnalyticsServiceElasticsearch.getSearchResponse(request);
        if (response.isTimedOut()) {
            return null;
        }
        return Arrays.stream(response.getHits().getHits()).map(AnalyticsServiceElasticsearch::toCompletionTime).filter(c -> c != null).collect(Collectors.toList());
    }

    public Percentiles getTraceCompletionPercentiles(String tenantId, Criteria criteria) {
        String index = client.getIndex(tenantId);
        if (!AnalyticsServiceElasticsearch.refresh(index)) {
            return null;
        }
        PercentilesBuilder percentileAgg = (PercentilesBuilder)AggregationBuilders.percentiles((String)"percentiles").field("duration");
        BoolQueryBuilder query = ElasticsearchUtil.buildQuery(criteria, "transaction", CompletionTime.class);
        SearchRequestBuilder request = this.getTraceCompletionRequest(index, criteria, query, 0).addAggregation((AbstractAggregationBuilder)percentileAgg);
        SearchResponse response = AnalyticsServiceElasticsearch.getSearchResponse(request);
        org.elasticsearch.search.aggregations.metrics.percentiles.Percentiles agg = (org.elasticsearch.search.aggregations.metrics.percentiles.Percentiles)response.getAggregations().get("percentiles");
        Percentiles percentiles = new Percentiles();
        agg.forEach(p -> percentiles.addPercentile((int)p.getPercent(), (long)p.getValue()));
        return percentiles;
    }

    public List<TimeseriesStatistics> getTraceCompletionTimeseriesStatistics(String tenantId, Criteria criteria, long interval) {
        String index = client.getIndex(tenantId);
        if (!AnalyticsServiceElasticsearch.refresh(index)) {
            return null;
        }
        StatsBuilder statsBuilder = (StatsBuilder)AggregationBuilders.stats((String)"stats").field("duration");
        FilterAggregationBuilder faultCountBuilder = AggregationBuilders.filter((String)"faults").filter((FilterBuilder)FilterBuilders.queryFilter((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"properties.name", (Object)"fault"))));
        NestedBuilder nestedFaultCountBuilder = (NestedBuilder)AggregationBuilders.nested((String)"nested").path("properties").subAggregation((AbstractAggregationBuilder)faultCountBuilder);
        DateHistogramBuilder histogramBuilder = (DateHistogramBuilder)((DateHistogramBuilder)((DateHistogramBuilder)AggregationBuilders.dateHistogram((String)"histogram").interval(interval).field("timestamp")).subAggregation((AbstractAggregationBuilder)statsBuilder)).subAggregation((AbstractAggregationBuilder)nestedFaultCountBuilder);
        BoolQueryBuilder query = ElasticsearchUtil.buildQuery(criteria, "transaction", CompletionTime.class);
        SearchRequestBuilder request = this.getTraceCompletionRequest(index, criteria, query, 0).addAggregation((AbstractAggregationBuilder)histogramBuilder);
        SearchResponse response = AnalyticsServiceElasticsearch.getSearchResponse(request);
        DateHistogram histogram = (DateHistogram)response.getAggregations().get("histogram");
        return histogram.getBuckets().stream().map(AnalyticsServiceElasticsearch::toTimeseriesStatistics).collect(Collectors.toList());
    }

    public List<Cardinality> getTraceCompletionFaultDetails(String tenantId, Criteria criteria) {
        return this.getTraceCompletionPropertyDetails(tenantId, criteria, "fault");
    }

    public List<Cardinality> getTraceCompletionPropertyDetails(String tenantId, Criteria criteria, String property) {
        String index = client.getIndex(tenantId);
        if (!AnalyticsServiceElasticsearch.refresh(index)) {
            return null;
        }
        BoolQueryBuilder nestedQuery = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"properties.name", (Object)property));
        BoolQueryBuilder query = ElasticsearchUtil.buildQuery(criteria, "transaction", CompletionTime.class);
        query.must((QueryBuilder)QueryBuilders.nestedQuery((String)"properties", (QueryBuilder)nestedQuery));
        TermsBuilder cardinalityBuilder = ((TermsBuilder)AggregationBuilders.terms((String)"cardinality").field("properties.value")).order(Terms.Order.aggregation((String)"_count", (boolean)false)).size(criteria.getMaxResponseSize());
        FilterAggregationBuilder filterAggBuilder = (FilterAggregationBuilder)AggregationBuilders.filter((String)"nestedfilter").filter((FilterBuilder)FilterBuilders.queryFilter((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"properties.name", (Object)property)))).subAggregation((AbstractAggregationBuilder)cardinalityBuilder);
        NestedBuilder nestedBuilder = (NestedBuilder)AggregationBuilders.nested((String)"nested").path("properties").subAggregation((AbstractAggregationBuilder)filterAggBuilder);
        SearchRequestBuilder request = this.getTraceCompletionRequest(index, criteria, query, 0).addAggregation((AbstractAggregationBuilder)nestedBuilder);
        SearchResponse response = AnalyticsServiceElasticsearch.getSearchResponse(request);
        Nested nested = (Nested)response.getAggregations().get("nested");
        InternalFilter filteredAgg = (InternalFilter)nested.getAggregations().get("nestedfilter");
        Terms terms = (Terms)filteredAgg.getAggregations().get("cardinality");
        return terms.getBuckets().stream().map(AnalyticsServiceElasticsearch::toCardinality).sorted((one, another) -> one.getValue().compareTo(another.getValue())).collect(Collectors.toList());
    }

    public List<NodeTimeseriesStatistics> getNodeTimeseriesStatistics(String tenantId, Criteria criteria, long interval) {
        String index = client.getIndex(tenantId);
        if (!AnalyticsServiceElasticsearch.refresh(index)) {
            return null;
        }
        AvgBuilder avgBuilder = (AvgBuilder)AggregationBuilders.avg((String)"avg").field("actual");
        TermsBuilder componentsBuilder = (TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"components").field("componentType")).size(criteria.getMaxResponseSize()).subAggregation((AbstractAggregationBuilder)avgBuilder);
        DateHistogramBuilder histogramBuilder = (DateHistogramBuilder)((DateHistogramBuilder)AggregationBuilders.dateHistogram((String)"histogram").interval(interval).field("timestamp")).subAggregation((AbstractAggregationBuilder)componentsBuilder);
        BoolQueryBuilder query = ElasticsearchUtil.buildQuery(criteria, "transaction", NodeDetails.class);
        SearchRequestBuilder request = this.getNodeDetailsRequest(index, criteria, query, 0).addAggregation((AbstractAggregationBuilder)histogramBuilder);
        SearchResponse response = AnalyticsServiceElasticsearch.getSearchResponse(request);
        DateHistogram histogram = (DateHistogram)response.getAggregations().get("histogram");
        return histogram.getBuckets().stream().map(AnalyticsServiceElasticsearch::toNodeTimeseriesStatistics).collect(Collectors.toList());
    }

    public Collection<NodeSummaryStatistics> getNodeSummaryStatistics(String tenantId, Criteria criteria) {
        String index = client.getIndex(tenantId);
        if (!AnalyticsServiceElasticsearch.refresh(index)) {
            return null;
        }
        ArrayList<NodeSummaryStatistics> stats = new ArrayList<NodeSummaryStatistics>();
        AvgBuilder actualBuilder = (AvgBuilder)AggregationBuilders.avg((String)"actual").field("actual");
        AvgBuilder elapsedBuilder = (AvgBuilder)AggregationBuilders.avg((String)"elapsed").field("elapsed");
        TermsBuilder operationsBuilder = (TermsBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"operations").field("operation")).size(criteria.getMaxResponseSize()).subAggregation((AbstractAggregationBuilder)actualBuilder)).subAggregation((AbstractAggregationBuilder)elapsedBuilder);
        MissingBuilder missingOperationBuilder = (MissingBuilder)((MissingBuilder)AggregationBuilders.missing((String)"missingOperation").field("operation").subAggregation((AbstractAggregationBuilder)actualBuilder)).subAggregation((AbstractAggregationBuilder)elapsedBuilder);
        TermsBuilder urisBuilder = (TermsBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"uris").field("uri")).size(criteria.getMaxResponseSize()).subAggregation((AbstractAggregationBuilder)operationsBuilder)).subAggregation((AbstractAggregationBuilder)missingOperationBuilder);
        MissingBuilder missingUrisBuilder = (MissingBuilder)((MissingBuilder)AggregationBuilders.missing((String)"missingUri").field("uri").subAggregation((AbstractAggregationBuilder)operationsBuilder)).subAggregation((AbstractAggregationBuilder)missingOperationBuilder);
        TermsBuilder componentsBuilder = (TermsBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"components").field("componentType")).size(criteria.getMaxResponseSize()).subAggregation((AbstractAggregationBuilder)urisBuilder)).subAggregation((AbstractAggregationBuilder)missingUrisBuilder);
        TermsBuilder interactionUrisBuilder = (TermsBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"uris").field("uri")).size(criteria.getMaxResponseSize()).subAggregation((AbstractAggregationBuilder)actualBuilder)).subAggregation((AbstractAggregationBuilder)elapsedBuilder);
        MissingBuilder missingComponentsBuilder = (MissingBuilder)AggregationBuilders.missing((String)"missingcomponent").field("componentType").subAggregation((AbstractAggregationBuilder)interactionUrisBuilder);
        TermsBuilder nodesBuilder = (TermsBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"types").field("type")).size(criteria.getMaxResponseSize()).subAggregation((AbstractAggregationBuilder)componentsBuilder)).subAggregation((AbstractAggregationBuilder)missingComponentsBuilder);
        BoolQueryBuilder query = ElasticsearchUtil.buildQuery(criteria, "transaction", NodeDetails.class);
        SearchRequestBuilder request = this.getNodeDetailsRequest(index, criteria, query, 0).addAggregation((AbstractAggregationBuilder)nodesBuilder);
        SearchResponse response = AnalyticsServiceElasticsearch.getSearchResponse(request);
        Terms types = (Terms)response.getAggregations().get("types");
        for (Terms.Bucket typeBucket : types.getBuckets()) {
            Terms components = (Terms)typeBucket.getAggregations().get("components");
            for (Terms.Bucket componentBucket : components.getBuckets()) {
                NodeSummaryStatistics stat;
                Avg elapsed;
                Avg actual;
                Terms uris = (Terms)componentBucket.getAggregations().get("uris");
                for (Terms.Bucket uriBucket : uris.getBuckets()) {
                    Terms operations = (Terms)uriBucket.getAggregations().get("operations");
                    for (Terms.Bucket operationBucket : operations.getBuckets()) {
                        Avg actual2 = (Avg)operationBucket.getAggregations().get("actual");
                        Avg elapsed2 = (Avg)operationBucket.getAggregations().get("elapsed");
                        NodeSummaryStatistics stat2 = new NodeSummaryStatistics();
                        stat2.setComponentType(this.getComponentTypeForBucket(typeBucket, componentBucket));
                        stat2.setUri(uriBucket.getKey());
                        stat2.setOperation(operationBucket.getKey());
                        stat2.setActual((long)actual2.getValue());
                        stat2.setElapsed((long)elapsed2.getValue());
                        stat2.setCount(operationBucket.getDocCount());
                        stats.add(stat2);
                    }
                    Missing missingOp = (Missing)uriBucket.getAggregations().get("missingOperation");
                    if (missingOp == null || missingOp.getDocCount() <= 0L) continue;
                    actual = (Avg)missingOp.getAggregations().get("actual");
                    elapsed = (Avg)missingOp.getAggregations().get("elapsed");
                    if (actual.getValueAsString().equals("NaN")) continue;
                    stat = new NodeSummaryStatistics();
                    stat.setComponentType(this.getComponentTypeForBucket(typeBucket, componentBucket));
                    stat.setUri(uriBucket.getKey());
                    stat.setActual((long)actual.getValue());
                    stat.setElapsed((long)elapsed.getValue());
                    stat.setCount(missingOp.getDocCount());
                    stats.add(stat);
                }
                Missing missingUri = (Missing)componentBucket.getAggregations().get("missingUri");
                if (missingUri.getDocCount() <= 0L) continue;
                Terms operations = (Terms)missingUri.getAggregations().get("operations");
                for (Terms.Bucket operationBucket : operations.getBuckets()) {
                    actual = (Avg)operationBucket.getAggregations().get("actual");
                    elapsed = (Avg)operationBucket.getAggregations().get("elapsed");
                    stat = new NodeSummaryStatistics();
                    stat.setComponentType(this.getComponentTypeForBucket(typeBucket, componentBucket));
                    stat.setOperation(operationBucket.getKey());
                    stat.setActual((long)actual.getValue());
                    stat.setElapsed((long)elapsed.getValue());
                    stat.setCount(operationBucket.getDocCount());
                    stats.add(stat);
                }
            }
            Missing missingComponents = (Missing)typeBucket.getAggregations().get("missingcomponent");
            Terms uris = (Terms)missingComponents.getAggregations().get("uris");
            for (Terms.Bucket uriBucket : uris.getBuckets()) {
                Avg actual = (Avg)uriBucket.getAggregations().get("actual");
                Avg elapsed = (Avg)uriBucket.getAggregations().get("elapsed");
                NodeSummaryStatistics stat = new NodeSummaryStatistics();
                stat.setComponentType(typeBucket.getKey());
                stat.setUri(uriBucket.getKey());
                stat.setActual((long)actual.getValue());
                stat.setElapsed((long)elapsed.getValue());
                stat.setCount(uriBucket.getDocCount());
                stats.add(stat);
            }
        }
        return stats;
    }

    protected Collection<CommunicationSummaryStatistics> doGetCommunicationSummaryStatistics(String tenantId, Criteria criteria) {
        String index = client.getIndex(tenantId);
        HashMap<String, CommunicationSummaryStatistics> stats = new HashMap<String, CommunicationSummaryStatistics>();
        if (!criteria.transactionWide()) {
            Criteria txnWideCriteria = criteria.deriveTransactionWide();
            this.buildCommunicationSummaryStatistics(stats, index, txnWideCriteria, false);
        }
        this.buildCommunicationSummaryStatistics(stats, index, criteria, true);
        return stats.values();
    }

    private void buildCommunicationSummaryStatistics(Map<String, CommunicationSummaryStatistics> stats, String index, Criteria criteria, boolean addMetrics) {
        if (!AnalyticsServiceElasticsearch.refresh(index)) {
            return;
        }
        BoolQueryBuilder query = ElasticsearchUtil.buildQuery(criteria, "transaction", null);
        query = query.mustNot((QueryBuilder)QueryBuilders.matchQuery((String)"internal", (Object)"true"));
        StatsBuilder latencyBuilder = (StatsBuilder)AggregationBuilders.stats((String)"latency").field("latency");
        TermsBuilder targetBuilder = (TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"target").field("target")).size(criteria.getMaxResponseSize()).subAggregation((AbstractAggregationBuilder)latencyBuilder);
        TermsBuilder sourceBuilder = (TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"source").field("source")).size(criteria.getMaxResponseSize()).subAggregation((AbstractAggregationBuilder)targetBuilder);
        SearchRequestBuilder request = this.getBaseSearchRequestBuilder(COMMUNICATION_DETAILS_TYPE, index, criteria, query, 0).addAggregation((AbstractAggregationBuilder)sourceBuilder);
        SearchResponse response = AnalyticsServiceElasticsearch.getSearchResponse(request);
        for (Terms.Bucket sourceBucket : ((Terms)response.getAggregations().get("source")).getBuckets()) {
            Terms targets = (Terms)sourceBucket.getAggregations().get("target");
            CommunicationSummaryStatistics css = stats.get(sourceBucket.getKey());
            if (css == null) {
                css = new CommunicationSummaryStatistics();
                css.setId(sourceBucket.getKey());
                css.setUri(EndpointUtil.decodeEndpointURI((String)css.getId()));
                css.setOperation(EndpointUtil.decodeEndpointOperation((String)css.getId(), (boolean)true));
                stats.put(css.getId(), css);
            }
            if (addMetrics) {
                css.setCount(sourceBucket.getDocCount());
            }
            for (Terms.Bucket targetBucket : targets.getBuckets()) {
                Stats latency = (Stats)targetBucket.getAggregations().get("latency");
                String linkId = targetBucket.getKey();
                CommunicationSummaryStatistics.ConnectionStatistics con = (CommunicationSummaryStatistics.ConnectionStatistics)css.getOutbound().get(linkId);
                if (con == null) {
                    con = new CommunicationSummaryStatistics.ConnectionStatistics();
                    css.getOutbound().put(linkId, con);
                }
                if (!addMetrics) continue;
                con.setMinimumLatency((long)latency.getMin());
                con.setAverageLatency((long)latency.getAvg());
                con.setMaximumLatency((long)latency.getMax());
                con.setCount(targetBucket.getDocCount());
            }
        }
        this.addNodeInformation(stats, index, criteria, addMetrics, false);
        this.addNodeInformation(stats, index, criteria, addMetrics, true);
    }

    protected void addNodeInformation(Map<String, CommunicationSummaryStatistics> stats, String index, Criteria criteria, boolean addMetrics, boolean clients) {
        String serviceName;
        CommunicationSummaryStatistics css;
        String id;
        Stats elapsed;
        BoolQueryBuilder query = ElasticsearchUtil.buildQuery(criteria, "transaction", null);
        StatsBuilder durationBuilder = (StatsBuilder)AggregationBuilders.stats((String)"elapsed").field("elapsed");
        TermsBuilder serviceTerm = (TermsBuilder)AggregationBuilders.terms((String)"serviceTerm").field("properties.value");
        FilterAggregationBuilder propertiesServiceFilter = (FilterAggregationBuilder)AggregationBuilders.filter((String)"propertiesServiceFilter").filter((FilterBuilder)FilterBuilders.queryFilter((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"properties.name", (Object)"service")))).subAggregation((AbstractAggregationBuilder)serviceTerm);
        NestedBuilder nestedProperties = (NestedBuilder)AggregationBuilders.nested((String)"nestedProperties").path("properties").subAggregation((AbstractAggregationBuilder)propertiesServiceFilter);
        TermsBuilder operationsBuilder2 = (TermsBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"operations").field("operation")).size(criteria.getMaxResponseSize()).subAggregation((AbstractAggregationBuilder)durationBuilder)).subAggregation((AbstractAggregationBuilder)nestedProperties);
        MissingBuilder missingOperationBuilder2 = (MissingBuilder)((MissingBuilder)AggregationBuilders.missing((String)"missingOperation").field("operation").subAggregation((AbstractAggregationBuilder)durationBuilder)).subAggregation((AbstractAggregationBuilder)nestedProperties);
        TermsBuilder urisBuilder2 = (TermsBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"uris").field("uri")).size(criteria.getMaxResponseSize()).subAggregation((AbstractAggregationBuilder)operationsBuilder2)).subAggregation((AbstractAggregationBuilder)missingOperationBuilder2);
        MissingBuilder missingUriBuilder2 = (MissingBuilder)((MissingBuilder)AggregationBuilders.missing((String)"missingUri").field("uri").subAggregation((AbstractAggregationBuilder)operationsBuilder2)).subAggregation((AbstractAggregationBuilder)missingOperationBuilder2);
        query = query.must((QueryBuilder)QueryBuilders.matchQuery((String)"initial", (Object)"true"));
        query = clients ? query.must((QueryBuilder)QueryBuilders.matchQuery((String)"type", (Object)"Producer")) : query.mustNot((QueryBuilder)QueryBuilders.matchQuery((String)"type", (Object)"Producer"));
        SearchRequestBuilder request2 = this.getBaseSearchRequestBuilder(NODE_DETAILS_TYPE, index, criteria, query, 0);
        request2.addAggregation((AbstractAggregationBuilder)urisBuilder2).addAggregation((AbstractAggregationBuilder)missingUriBuilder2);
        SearchResponse response2 = AnalyticsServiceElasticsearch.getSearchResponse(request2);
        Terms completions = (Terms)response2.getAggregations().get("uris");
        for (Terms.Bucket urisBucket : completions.getBuckets()) {
            String uri = urisBucket.getKey();
            if (clients) {
                uri = EndpointUtil.encodeClientURI((String)uri);
            }
            for (Terms.Bucket operationBucket : ((Terms)urisBucket.getAggregations().get("operations")).getBuckets()) {
                String serviceName2;
                Stats elapsed2 = (Stats)operationBucket.getAggregations().get("elapsed");
                String id2 = EndpointUtil.encodeEndpoint((String)uri, (String)operationBucket.getKey());
                CommunicationSummaryStatistics css2 = stats.get(id2);
                if (css2 == null) {
                    css2 = new CommunicationSummaryStatistics();
                    css2.setId(id2);
                    css2.setUri(uri);
                    css2.setOperation(operationBucket.getKey());
                    stats.put(id2, css2);
                }
                if (addMetrics) {
                    this.doAddMetrics(css2, elapsed2, operationBucket.getDocCount());
                }
                if ((serviceName2 = this.serviceName((Terms)((Filter)((Nested)operationBucket.getAggregations().get("nestedProperties")).getAggregations().get("propertiesServiceFilter")).getAggregations().get("serviceTerm"))) == null) continue;
                css2.setServiceName(serviceName2);
            }
            Missing missingOp = (Missing)urisBucket.getAggregations().get("missingOperation");
            if (missingOp.getDocCount() <= 0L) continue;
            elapsed = (Stats)missingOp.getAggregations().get("elapsed");
            id = EndpointUtil.encodeEndpoint((String)uri, null);
            css = stats.get(id);
            if (css == null) {
                css = new CommunicationSummaryStatistics();
                css.setId(id);
                css.setUri(uri);
                stats.put(id, css);
            }
            if (addMetrics) {
                this.doAddMetrics(css, elapsed, missingOp.getDocCount());
            }
            if ((serviceName = this.serviceName((Terms)((Filter)((Nested)missingOp.getAggregations().get("nestedProperties")).getAggregations().get("propertiesServiceFilter")).getAggregations().get("serviceTerm"))) == null) continue;
            css.setServiceName(serviceName);
        }
        Missing missingUri = (Missing)response2.getAggregations().get("missingUri");
        if (missingUri.getDocCount() > 0L) {
            Terms operations = (Terms)missingUri.getAggregations().get("operations");
            for (Terms.Bucket operationBucket : operations.getBuckets()) {
                elapsed = (Stats)operationBucket.getAggregations().get("elapsed");
                id = EndpointUtil.encodeEndpoint(null, (String)operationBucket.getKey());
                css = stats.get(id);
                if (css == null) {
                    css = new CommunicationSummaryStatistics();
                    css.setId(id);
                    css.setOperation(operationBucket.getKey());
                    stats.put(id, css);
                }
                if ((serviceName = this.serviceName((Terms)((Filter)((Nested)operationBucket.getAggregations().get("nestedProperties")).getAggregations().get("propertiesServiceFilter")).getAggregations().get("serviceTerm"))) != null) {
                    css.setServiceName(serviceName);
                }
                if (!addMetrics) continue;
                this.doAddMetrics(css, elapsed, operationBucket.getDocCount());
            }
        }
    }

    public List<TimeseriesStatistics> getEndpointResponseTimeseriesStatistics(String tenantId, Criteria criteria, long interval) {
        String index = client.getIndex(tenantId);
        if (!AnalyticsServiceElasticsearch.refresh(index)) {
            return null;
        }
        StatsBuilder statsBuilder = (StatsBuilder)AggregationBuilders.stats((String)"stats").field("elapsed");
        FilterAggregationBuilder faultCountBuilder = AggregationBuilders.filter((String)"faults").filter((FilterBuilder)FilterBuilders.queryFilter((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"properties.name", (Object)"fault"))));
        NestedBuilder nestedFaultCountBuilder = (NestedBuilder)AggregationBuilders.nested((String)"nested").path("properties").subAggregation((AbstractAggregationBuilder)faultCountBuilder);
        DateHistogramBuilder histogramBuilder = (DateHistogramBuilder)((DateHistogramBuilder)((DateHistogramBuilder)AggregationBuilders.dateHistogram((String)"histogram").interval(interval).field("timestamp")).subAggregation((AbstractAggregationBuilder)statsBuilder)).subAggregation((AbstractAggregationBuilder)nestedFaultCountBuilder);
        BoolQueryBuilder query = ElasticsearchUtil.buildQuery(criteria, "transaction", NodeDetails.class);
        query.must((QueryBuilder)QueryBuilders.termQuery((String)"type", (String)"Consumer"));
        SearchRequestBuilder request = this.getNodeDetailsRequest(index, criteria, query, 0).addAggregation((AbstractAggregationBuilder)histogramBuilder);
        SearchResponse response = AnalyticsServiceElasticsearch.getSearchResponse(request);
        DateHistogram histogram = (DateHistogram)response.getAggregations().get("histogram");
        return histogram.getBuckets().stream().map(AnalyticsServiceElasticsearch::toTimeseriesStatistics).collect(Collectors.toList());
    }

    protected List<Cardinality> getEndpointPropertyDetails(String tenantId, Criteria criteria, String property) {
        String index = client.getIndex(tenantId);
        if (!AnalyticsServiceElasticsearch.refresh(index)) {
            return null;
        }
        BoolQueryBuilder nestedQuery = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"properties.name", (Object)property));
        BoolQueryBuilder query = ElasticsearchUtil.buildQuery(criteria, "transaction", CompletionTime.class);
        query = query.must((QueryBuilder)QueryBuilders.matchQuery((String)"initial", (Object)"true"));
        query.must((QueryBuilder)QueryBuilders.nestedQuery((String)"properties", (QueryBuilder)nestedQuery));
        TermsBuilder cardinalityBuilder = ((TermsBuilder)AggregationBuilders.terms((String)"cardinality").field("properties.value")).order(Terms.Order.aggregation((String)"_count", (boolean)false)).size(criteria.getMaxResponseSize());
        FilterAggregationBuilder filterAggBuilder = (FilterAggregationBuilder)AggregationBuilders.filter((String)"nestedfilter").filter((FilterBuilder)FilterBuilders.queryFilter((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"properties.name", (Object)property)))).subAggregation((AbstractAggregationBuilder)cardinalityBuilder);
        NestedBuilder nestedBuilder = (NestedBuilder)AggregationBuilders.nested((String)"nested").path("properties").subAggregation((AbstractAggregationBuilder)filterAggBuilder);
        SearchRequestBuilder request = this.getNodeDetailsRequest(index, criteria, query, 0).addAggregation((AbstractAggregationBuilder)nestedBuilder);
        SearchResponse response = AnalyticsServiceElasticsearch.getSearchResponse(request);
        Nested nested = (Nested)response.getAggregations().get("nested");
        InternalFilter filteredAgg = (InternalFilter)nested.getAggregations().get("nestedfilter");
        Terms terms = (Terms)filteredAgg.getAggregations().get("cardinality");
        return terms.getBuckets().stream().map(AnalyticsServiceElasticsearch::toCardinality).sorted((one, another) -> one.getValue().compareTo(another.getValue())).collect(Collectors.toList());
    }

    public Set<String> getHostNames(String tenantId, Criteria criteria) {
        String index = client.getIndex(tenantId);
        if (!AnalyticsServiceElasticsearch.refresh(index)) {
            return null;
        }
        List<Trace> btxns = TraceServiceElasticsearch.internalQuery(client, tenantId, criteria);
        return btxns.stream().filter(t -> t.getHostName() != null && !t.getHostName().trim().isEmpty()).map(Trace::getHostName).sorted().collect(Collectors.toSet());
    }

    public void storeCommunicationDetails(String tenantId, List<CommunicationDetails> communicationDetails) throws StoreException {
        this.bulkStoreApmEvents(tenantId, communicationDetails, COMMUNICATION_DETAILS_TYPE);
    }

    public void storeNodeDetails(String tenantId, List<NodeDetails> nodeDetails) throws StoreException {
        this.bulkStoreApmEvents(tenantId, nodeDetails, NODE_DETAILS_TYPE);
    }

    public void storeTraceCompletions(String tenantId, List<CompletionTime> completionTimes) throws StoreException {
        this.bulkStoreApmEvents(tenantId, completionTimes, TRACE_COMPLETION_TIME_TYPE);
    }

    private void bulkStoreApmEvents(String tenantId, List<? extends ApmEvent> events, String type) throws StoreException {
        client.initTenant(tenantId);
        BulkRequestBuilder bulkRequestBuilder = client.getClient().prepareBulk();
        for (ApmEvent apmEvent : events) {
            String json = AnalyticsServiceElasticsearch.toJson(apmEvent);
            if (null == json) continue;
            if (msgLog.isTraceEnabled()) {
                msgLog.tracef("Storing event: %s", json);
            }
            bulkRequestBuilder.add(AnalyticsServiceElasticsearch.toIndexRequestBuilder(client, tenantId, type, apmEvent.getId(), json));
        }
        BulkResponse bulkItemResponses = (BulkResponse)bulkRequestBuilder.execute().actionGet();
        if (bulkItemResponses.hasFailures()) {
            if (msgLog.isTraceEnabled()) {
                msgLog.trace("Failed to store event to elasticsearch: " + bulkItemResponses.buildFailureMessage());
            }
            throw new StoreException(bulkItemResponses.buildFailureMessage());
        }
        if (msgLog.isTraceEnabled()) {
            msgLog.trace("Success storing event to elasticsearch");
        }
    }

    public void clear(String tenantId) {
        client.clearTenant(tenantId);
    }

    private static String toJson(Object ct) {
        try {
            return mapper.writeValueAsString(ct);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    private static IndexRequestBuilder toIndexRequestBuilder(ElasticsearchClient client, String tenantId, String type, String id, String json) {
        return client.getClient().prepareIndex(client.getIndex(tenantId), type, id).setSource(json);
    }

    private static NodeTimeseriesStatistics toNodeTimeseriesStatistics(DateHistogram.Bucket bucket) {
        Terms term = (Terms)bucket.getAggregations().get("components");
        NodeTimeseriesStatistics s = new NodeTimeseriesStatistics();
        s.setTimestamp(bucket.getKeyAsDate().getMillis());
        term.getBuckets().forEach(b -> {
            Avg avg = (Avg)b.getAggregations().get("avg");
            NodeTimeseriesStatistics.NodeComponentTypeStatistics component = new NodeTimeseriesStatistics.NodeComponentTypeStatistics((long)avg.getValue(), b.getDocCount());
            s.getComponentTypes().put(b.getKey(), component);
        });
        return s;
    }

    private static boolean refresh(String index) {
        try {
            AdminClient adminClient = client.getClient().admin();
            RefreshRequestBuilder refreshRequestBuilder = adminClient.indices().prepareRefresh(new String[]{index});
            adminClient.indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
            return true;
        }
        catch (IndexMissingException t) {
            if (msgLog.isTraceEnabled()) {
                msgLog.tracef("Index [%s] not found, unable to proceed.", index);
            }
            return false;
        }
    }

    private static Cardinality toCardinality(Terms.Bucket bucket) {
        Cardinality card = new Cardinality();
        card.setValue(bucket.getKey());
        card.setCount(bucket.getDocCount());
        return card;
    }

    private static TimeseriesStatistics toTimeseriesStatistics(DateHistogram.Bucket bucket) {
        Stats stat = (Stats)bucket.getAggregations().get("stats");
        long faultCount = ((Filter)((Nested)bucket.getAggregations().get("nested")).getAggregations().get("faults")).getDocCount();
        TimeseriesStatistics s = new TimeseriesStatistics();
        s.setTimestamp(bucket.getKeyAsDate().getMillis());
        s.setAverage((long)stat.getAvg());
        s.setMin((long)stat.getMin());
        s.setMax((long)stat.getMax());
        s.setCount(stat.getCount());
        s.setFaultCount(faultCount);
        return s;
    }

    private static CompletionTime toCompletionTime(SearchHit searchHit) {
        try {
            return (CompletionTime)mapper.readValue(searchHit.getSourceAsString(), CompletionTime.class);
        }
        catch (IOException e) {
            msgLog.errorFailedToParse(e);
            return null;
        }
    }

    private static TransactionInfo toTransactionInfo(Terms.Bucket bucket) {
        TransactionInfo ti = new TransactionInfo();
        ti.setName(bucket.getKey());
        ti.setCount(bucket.getDocCount());
        return ti;
    }

    private static PropertyInfo toPropertyInfo(Terms.Bucket bucket) {
        PropertyInfo pi = new PropertyInfo();
        pi.setName(bucket.getKey());
        return pi;
    }

    private static SearchResponse getSearchResponse(SearchRequestBuilder request) {
        SearchResponse response = (SearchResponse)request.execute().actionGet();
        if (response.isTimedOut()) {
            msgLog.warnQueryTimedOut();
        }
        return response;
    }

    private String getComponentTypeForBucket(Terms.Bucket typeBucket, Terms.Bucket parent) {
        if (typeBucket.getKey().equalsIgnoreCase("consumer")) {
            return "consumer";
        }
        if (typeBucket.getKey().equalsIgnoreCase("producer")) {
            return "producer";
        }
        return parent.getKey();
    }

    private void doAddMetrics(CommunicationSummaryStatistics css, Stats duration, long docCount) {
        css.setMinimumDuration((long)duration.getMin());
        css.setAverageDuration((long)duration.getAvg());
        css.setMaximumDuration((long)duration.getMax());
        css.setCount(docCount);
    }

    private long getTraceCompletionCount(String tenantId, Criteria criteria, boolean onlyFaulty) {
        SearchResponse response;
        String index = client.getIndex(tenantId);
        if (!AnalyticsServiceElasticsearch.refresh(index)) {
            return 0L;
        }
        BoolQueryBuilder query = ElasticsearchUtil.buildQuery(criteria, "transaction", CompletionTime.class);
        SearchRequestBuilder request = this.getTraceCompletionRequest(index, criteria, query, 0);
        if (onlyFaulty) {
            QueryFilterBuilder filter = FilterBuilders.queryFilter((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"properties.name", (Object)"fault")));
            request.setPostFilter((FilterBuilder)FilterBuilders.nestedFilter((String)"properties", (FilterBuilder)filter));
        }
        if ((response = (SearchResponse)request.execute().actionGet()).isTimedOut()) {
            msgLog.warnQueryTimedOut();
            return 0L;
        }
        return response.getHits().getTotalHits();
    }

    private SearchRequestBuilder getTraceCompletionRequest(String index, Criteria criteria, BoolQueryBuilder query, int maxSize) {
        return this.getBaseSearchRequestBuilder(TRACE_COMPLETION_TIME_TYPE, index, criteria, query, maxSize);
    }

    private SearchRequestBuilder getNodeDetailsRequest(String index, Criteria criteria, BoolQueryBuilder query, int maxSize) {
        return this.getBaseSearchRequestBuilder(NODE_DETAILS_TYPE, index, criteria, query, maxSize);
    }

    private SearchRequestBuilder getBaseSearchRequestBuilder(String type, String index, Criteria criteria, BoolQueryBuilder query, int maxSize) {
        return client.getClient().prepareSearch(new String[]{index}).setTypes(new String[]{type}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setTimeout(TimeValue.timeValueMillis((long)criteria.getTimeout())).setSize(maxSize).setQuery((QueryBuilder)query);
    }

    private String serviceName(Terms serviceTerm) {
        if (serviceTerm == null) {
            return null;
        }
        String serviceName = null;
        if (serviceTerm.getBuckets().size() > 0) {
            serviceName = ((Terms.Bucket)serviceTerm.getBuckets().iterator().next()).getKey();
        }
        return serviceName;
    }
}

