/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.server.elasticsearch;

import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.hawkular.apm.api.model.analytics.BuildStamp;
import org.hawkular.apm.api.model.analytics.Cardinality;
import org.hawkular.apm.api.model.analytics.ServiceDeployment;
import org.hawkular.apm.api.services.Criteria;
import org.hawkular.apm.api.services.ServiceDeploymentService;
import org.hawkular.apm.server.elasticsearch.AnalyticsServiceElasticsearch;

public class ServiceDeploymentServiceElasticsearch
implements ServiceDeploymentService {
    @Inject
    AnalyticsServiceElasticsearch analyticsService;

    public List<ServiceDeployment> getServiceDeployments(String tenantId, Criteria criteria) {
        Criteria serviceCriteria = new Criteria(criteria);
        return this.analyticsService.getTraceCompletionPropertyDetails(tenantId, serviceCriteria, "service").stream().map(c -> this.getService(c.getValue(), tenantId, serviceCriteria)).collect(Collectors.toList());
    }

    public List<ServiceDeployment> getServiceDeployments(String tenantId) {
        return this.getServiceDeployments(tenantId, null);
    }

    public ServiceDeployment getService(String serviceName, String tenantId, Criteria criteria) {
        Criteria buildStampCriteria = new Criteria(criteria);
        buildStampCriteria.addProperty("service", serviceName, Criteria.Operator.EQ);
        List buildStamps = this.analyticsService.getEndpointPropertyDetails(tenantId, buildStampCriteria, "buildStamp").stream().map(this::toBuildStamp).collect(Collectors.toList());
        return new ServiceDeployment(serviceName, buildStamps);
    }

    public ServiceDeployment getService(String serviceName, String tenantId) {
        return this.getService(serviceName, tenantId, null);
    }

    private BuildStamp toBuildStamp(Cardinality cardinality) {
        return new BuildStamp(cardinality.getValue());
    }
}

