/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.server.elasticsearch;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequestBuilder;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ExistsFilterBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.filter.FilterAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.filter.InternalFilter;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogram;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramBuilder;
import org.elasticsearch.search.aggregations.bucket.missing.Missing;
import org.elasticsearch.search.aggregations.bucket.missing.MissingBuilder;
import org.elasticsearch.search.aggregations.bucket.nested.Nested;
import org.elasticsearch.search.aggregations.bucket.nested.NestedBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.elasticsearch.search.aggregations.metrics.avg.Avg;
import org.elasticsearch.search.aggregations.metrics.avg.AvgBuilder;
import org.elasticsearch.search.aggregations.metrics.percentiles.Percentile;
import org.elasticsearch.search.aggregations.metrics.percentiles.PercentilesBuilder;
import org.elasticsearch.search.aggregations.metrics.stats.Stats;
import org.elasticsearch.search.aggregations.metrics.stats.StatsBuilder;
import org.hawkular.apm.api.model.analytics.Cardinality;
import org.hawkular.apm.api.model.analytics.CommunicationSummaryStatistics;
import org.hawkular.apm.api.model.analytics.CompletionTimeseriesStatistics;
import org.hawkular.apm.api.model.analytics.NodeSummaryStatistics;
import org.hawkular.apm.api.model.analytics.NodeTimeseriesStatistics;
import org.hawkular.apm.api.model.analytics.Percentiles;
import org.hawkular.apm.api.model.analytics.PrincipalInfo;
import org.hawkular.apm.api.model.events.CommunicationDetails;
import org.hawkular.apm.api.model.events.CompletionTime;
import org.hawkular.apm.api.model.events.NodeDetails;
import org.hawkular.apm.api.model.trace.Trace;
import org.hawkular.apm.api.services.AbstractAnalyticsService;
import org.hawkular.apm.api.services.Criteria;
import org.hawkular.apm.api.services.StoreException;
import org.hawkular.apm.api.utils.EndpointUtil;
import org.hawkular.apm.server.elasticsearch.ElasticsearchClient;
import org.hawkular.apm.server.elasticsearch.ElasticsearchUtil;
import org.hawkular.apm.server.elasticsearch.TraceServiceElasticsearch;
import org.hawkular.apmserver.elasticsearch.log.MsgLogger;

public class AnalyticsServiceElasticsearch
extends AbstractAnalyticsService {
    private static final Logger log = Logger.getLogger(AnalyticsServiceElasticsearch.class.getName());
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private static final String COMMUNICATION_DETAILS_TYPE = "communicationdetails";
    private static final String NODE_DETAILS_TYPE = "nodedetails";
    private static final String TRACE_COMPLETION_TIME_TYPE = "tracecompletiontime";
    private static final String FRAGMENT_COMPLETION_TIME_TYPE = "fragmentcompletiontime";
    private static final ObjectMapper mapper = new ObjectMapper();
    @Inject
    private ElasticsearchClient client;

    public ElasticsearchClient getElasticsearchClient() {
        return this.client;
    }

    public void setElasticsearchClient(ElasticsearchClient client) {
        this.client = client;
    }

    protected List<Trace> getFragments(String tenantId, Criteria criteria) {
        return TraceServiceElasticsearch.internalQuery(this.client, tenantId, criteria);
    }

    public List<PrincipalInfo> getPrincipalInfo(String tenantId, Criteria criteria) {
        ArrayList<PrincipalInfo> ret;
        block4: {
            String index = this.client.getIndex(tenantId);
            ret = new ArrayList<PrincipalInfo>();
            try {
                RefreshRequestBuilder refreshRequestBuilder = this.client.getElasticsearchClient().admin().indices().prepareRefresh(new String[]{index});
                this.client.getElasticsearchClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
                BoolQueryBuilder query = ElasticsearchUtil.buildQuery(criteria, "startTime", "businessTransaction");
                TermsBuilder cardinalityBuilder = ((TermsBuilder)AggregationBuilders.terms((String)"cardinality").field("principal")).order(Terms.Order.aggregation((String)"_count", (boolean)false)).size(criteria.getMaxResponseSize());
                SearchRequestBuilder request = this.client.getElasticsearchClient().prepareSearch(new String[]{index}).setTypes(new String[]{"trace"}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).addAggregation((AbstractAggregationBuilder)cardinalityBuilder).setTimeout(TimeValue.timeValueMillis((long)criteria.getTimeout())).setSize(0).setQuery((QueryBuilder)query);
                SearchResponse response = (SearchResponse)request.execute().actionGet();
                if (response.isTimedOut()) {
                    this.msgLog.warnQueryTimedOut();
                }
                Terms terms = (Terms)response.getAggregations().get("cardinality");
                for (Terms.Bucket bucket : terms.getBuckets()) {
                    PrincipalInfo pi = new PrincipalInfo();
                    pi.setId(bucket.getKey());
                    pi.setCount(bucket.getDocCount());
                    ret.add(pi);
                }
            }
            catch (IndexMissingException t) {
                if (!this.msgLog.isTraceEnabled()) break block4;
                this.msgLog.tracef("No index found, so unable to get principal details", new Object[0]);
            }
        }
        Collections.sort(ret, new Comparator<PrincipalInfo>(){

            @Override
            public int compare(PrincipalInfo arg0, PrincipalInfo arg1) {
                return arg0.getId().compareTo(arg1.getId());
            }
        });
        return ret;
    }

    public long getTraceCompletionCount(String tenantId, Criteria criteria) {
        String index = this.client.getIndex(tenantId);
        try {
            RefreshRequestBuilder refreshRequestBuilder = this.client.getElasticsearchClient().admin().indices().prepareRefresh(new String[]{index});
            this.client.getElasticsearchClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
            BoolQueryBuilder query = ElasticsearchUtil.buildQuery(criteria, "timestamp", "businessTransaction");
            SearchRequestBuilder request = this.client.getElasticsearchClient().prepareSearch(new String[]{index}).setTypes(new String[]{TRACE_COMPLETION_TIME_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setTimeout(TimeValue.timeValueMillis((long)criteria.getTimeout())).setSize(0).setQuery((QueryBuilder)query);
            SearchResponse response = (SearchResponse)request.execute().actionGet();
            if (response.isTimedOut()) {
                this.msgLog.warnQueryTimedOut();
                return 0L;
            }
            return response.getHits().getTotalHits();
        }
        catch (IndexMissingException t) {
            if (this.msgLog.isTraceEnabled()) {
                this.msgLog.tracef("No index found, so unable to get completion count", new Object[0]);
            }
            return 0L;
        }
    }

    public long getTraceCompletionFaultCount(String tenantId, Criteria criteria) {
        String index = this.client.getIndex(tenantId);
        try {
            RefreshRequestBuilder refreshRequestBuilder = this.client.getElasticsearchClient().admin().indices().prepareRefresh(new String[]{index});
            this.client.getElasticsearchClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
            BoolQueryBuilder query = ElasticsearchUtil.buildQuery(criteria, "timestamp", "businessTransaction");
            ExistsFilterBuilder filter = FilterBuilders.existsFilter((String)"fault");
            SearchRequestBuilder request = this.client.getElasticsearchClient().prepareSearch(new String[]{index}).setTypes(new String[]{TRACE_COMPLETION_TIME_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setTimeout(TimeValue.timeValueMillis((long)criteria.getTimeout())).setSize(0).setQuery((QueryBuilder)query).setPostFilter((FilterBuilder)filter);
            SearchResponse response = (SearchResponse)request.execute().actionGet();
            if (response.isTimedOut()) {
                this.msgLog.warnQueryTimedOut();
                return 0L;
            }
            return response.getHits().getTotalHits();
        }
        catch (IndexMissingException t) {
            if (this.msgLog.isTraceEnabled()) {
                this.msgLog.tracef("No index found, so unable to get completion faultcount", new Object[0]);
            }
            return 0L;
        }
    }

    public Percentiles getTraceCompletionPercentiles(String tenantId, Criteria criteria) {
        Percentiles percentiles;
        block4: {
            String index = this.client.getIndex(tenantId);
            percentiles = new Percentiles();
            try {
                RefreshRequestBuilder refreshRequestBuilder = this.client.getElasticsearchClient().admin().indices().prepareRefresh(new String[]{index});
                this.client.getElasticsearchClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
                BoolQueryBuilder query = ElasticsearchUtil.buildQuery(criteria, "timestamp", "businessTransaction");
                PercentilesBuilder percentileAgg = (PercentilesBuilder)AggregationBuilders.percentiles((String)"percentiles").field("duration");
                SearchRequestBuilder request = this.client.getElasticsearchClient().prepareSearch(new String[]{index}).setTypes(new String[]{TRACE_COMPLETION_TIME_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).addAggregation((AbstractAggregationBuilder)percentileAgg).setTimeout(TimeValue.timeValueMillis((long)criteria.getTimeout())).setSize(0).setQuery((QueryBuilder)query);
                SearchResponse response = (SearchResponse)request.execute().actionGet();
                if (response.isTimedOut()) {
                    this.msgLog.warnQueryTimedOut();
                }
                org.elasticsearch.search.aggregations.metrics.percentiles.Percentiles agg = (org.elasticsearch.search.aggregations.metrics.percentiles.Percentiles)response.getAggregations().get("percentiles");
                for (Percentile entry : agg) {
                    percentiles.addPercentile((int)entry.getPercent(), (long)entry.getValue());
                }
            }
            catch (IndexMissingException t) {
                if (!this.msgLog.isTraceEnabled()) break block4;
                this.msgLog.tracef("No index found, so unable to get completion percentiles", new Object[0]);
            }
        }
        return percentiles;
    }

    public List<CompletionTimeseriesStatistics> getTraceCompletionTimeseriesStatistics(String tenantId, Criteria criteria, long interval) {
        ArrayList<CompletionTimeseriesStatistics> stats;
        block4: {
            String index = this.client.getIndex(tenantId);
            stats = new ArrayList<CompletionTimeseriesStatistics>();
            try {
                RefreshRequestBuilder refreshRequestBuilder = this.client.getElasticsearchClient().admin().indices().prepareRefresh(new String[]{index});
                this.client.getElasticsearchClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
                BoolQueryBuilder query = ElasticsearchUtil.buildQuery(criteria, "timestamp", "businessTransaction");
                StatsBuilder statsBuilder = (StatsBuilder)AggregationBuilders.stats((String)"stats").field("duration");
                MissingBuilder faultCountBuilder = AggregationBuilders.missing((String)"faults").field("fault");
                DateHistogramBuilder histogramBuilder = (DateHistogramBuilder)((DateHistogramBuilder)((DateHistogramBuilder)AggregationBuilders.dateHistogram((String)"histogram").interval(interval).field("timestamp")).subAggregation((AbstractAggregationBuilder)statsBuilder)).subAggregation((AbstractAggregationBuilder)faultCountBuilder);
                SearchRequestBuilder request = this.client.getElasticsearchClient().prepareSearch(new String[]{index}).setTypes(new String[]{TRACE_COMPLETION_TIME_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).addAggregation((AbstractAggregationBuilder)histogramBuilder).setTimeout(TimeValue.timeValueMillis((long)criteria.getTimeout())).setSize(0).setQuery((QueryBuilder)query);
                SearchResponse response = (SearchResponse)request.execute().actionGet();
                if (response.isTimedOut()) {
                    this.msgLog.warnQueryTimedOut();
                }
                DateHistogram histogram = (DateHistogram)response.getAggregations().get("histogram");
                for (DateHistogram.Bucket bucket : histogram.getBuckets()) {
                    Stats stat = (Stats)bucket.getAggregations().get("stats");
                    Missing missing = (Missing)bucket.getAggregations().get("faults");
                    CompletionTimeseriesStatistics s = new CompletionTimeseriesStatistics();
                    s.setTimestamp(bucket.getKeyAsDate().getMillis());
                    s.setAverage((long)stat.getAvg());
                    s.setMin((long)stat.getMin());
                    s.setMax((long)stat.getMax());
                    s.setCount(stat.getCount());
                    s.setFaultCount(stat.getCount() - missing.getDocCount());
                    stats.add(s);
                }
            }
            catch (IndexMissingException t) {
                if (!this.msgLog.isTraceEnabled()) break block4;
                this.msgLog.tracef("No index found, so unable to get completion timeseries stats", new Object[0]);
            }
        }
        return stats;
    }

    public List<Cardinality> getTraceCompletionFaultDetails(String tenantId, Criteria criteria) {
        ArrayList<Cardinality> ret;
        block4: {
            String index = this.client.getIndex(tenantId);
            ret = new ArrayList<Cardinality>();
            try {
                RefreshRequestBuilder refreshRequestBuilder = this.client.getElasticsearchClient().admin().indices().prepareRefresh(new String[]{index});
                this.client.getElasticsearchClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
                BoolQueryBuilder query = ElasticsearchUtil.buildQuery(criteria, "timestamp", "businessTransaction");
                TermsBuilder cardinalityBuilder = ((TermsBuilder)AggregationBuilders.terms((String)"cardinality").field("fault")).order(Terms.Order.aggregation((String)"_count", (boolean)false)).size(criteria.getMaxResponseSize());
                SearchRequestBuilder request = this.client.getElasticsearchClient().prepareSearch(new String[]{index}).setTypes(new String[]{TRACE_COMPLETION_TIME_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).addAggregation((AbstractAggregationBuilder)cardinalityBuilder).setTimeout(TimeValue.timeValueMillis((long)criteria.getTimeout())).setSize(0).setQuery((QueryBuilder)query);
                SearchResponse response = (SearchResponse)request.execute().actionGet();
                if (response.isTimedOut()) {
                    this.msgLog.warnQueryTimedOut();
                }
                Terms terms = (Terms)response.getAggregations().get("cardinality");
                for (Terms.Bucket bucket : terms.getBuckets()) {
                    Cardinality card = new Cardinality();
                    card.setValue(bucket.getKey());
                    card.setCount(bucket.getDocCount());
                    ret.add(card);
                }
            }
            catch (IndexMissingException t) {
                if (!this.msgLog.isTraceEnabled()) break block4;
                this.msgLog.tracef("No index found, so unable to get completion fault details", new Object[0]);
            }
        }
        Collections.sort(ret, new Comparator<Cardinality>(){

            @Override
            public int compare(Cardinality arg0, Cardinality arg1) {
                return (int)(arg1.getCount() - arg0.getCount());
            }
        });
        return ret;
    }

    public List<Cardinality> getTraceCompletionPropertyDetails(String tenantId, Criteria criteria, String property) {
        ArrayList<Cardinality> ret;
        block4: {
            String index = this.client.getIndex(tenantId);
            ret = new ArrayList<Cardinality>();
            try {
                RefreshRequestBuilder refreshRequestBuilder = this.client.getElasticsearchClient().admin().indices().prepareRefresh(new String[]{index});
                this.client.getElasticsearchClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
                BoolQueryBuilder query = ElasticsearchUtil.buildQuery(criteria, "timestamp", "businessTransaction");
                BoolQueryBuilder nestedQuery = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"properties.name", (Object)property));
                query.must((QueryBuilder)QueryBuilders.nestedQuery((String)"properties", (QueryBuilder)nestedQuery));
                TermsBuilder cardinalityBuilder = ((TermsBuilder)AggregationBuilders.terms((String)"cardinality").field("properties.value")).order(Terms.Order.aggregation((String)"_count", (boolean)false)).size(criteria.getMaxResponseSize());
                FilterAggregationBuilder filterAggBuilder = (FilterAggregationBuilder)AggregationBuilders.filter((String)"nestedfilter").filter((FilterBuilder)FilterBuilders.queryFilter((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"properties.name", (Object)property)))).subAggregation((AbstractAggregationBuilder)cardinalityBuilder);
                NestedBuilder nestedBuilder = (NestedBuilder)AggregationBuilders.nested((String)"nested").path("properties").subAggregation((AbstractAggregationBuilder)filterAggBuilder);
                SearchRequestBuilder request = this.client.getElasticsearchClient().prepareSearch(new String[]{index}).setTypes(new String[]{TRACE_COMPLETION_TIME_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).addAggregation((AbstractAggregationBuilder)nestedBuilder).setTimeout(TimeValue.timeValueMillis((long)criteria.getTimeout())).setSize(0).setQuery((QueryBuilder)query);
                SearchResponse response = (SearchResponse)request.execute().actionGet();
                if (response.isTimedOut()) {
                    this.msgLog.warnQueryTimedOut();
                }
                Nested nested = (Nested)response.getAggregations().get("nested");
                InternalFilter filteredAgg = (InternalFilter)nested.getAggregations().get("nestedfilter");
                Terms terms = (Terms)filteredAgg.getAggregations().get("cardinality");
                for (Terms.Bucket bucket : terms.getBuckets()) {
                    Cardinality card = new Cardinality();
                    card.setValue(bucket.getKey());
                    card.setCount(bucket.getDocCount());
                    ret.add(card);
                }
            }
            catch (IndexMissingException t) {
                if (!this.msgLog.isTraceEnabled()) break block4;
                this.msgLog.tracef("No index found, so unable to get completion property details", new Object[0]);
            }
        }
        Collections.sort(ret, new Comparator<Cardinality>(){

            @Override
            public int compare(Cardinality arg0, Cardinality arg1) {
                return arg0.getValue().compareTo(arg1.getValue());
            }
        });
        return ret;
    }

    public List<NodeTimeseriesStatistics> getNodeTimeseriesStatistics(String tenantId, Criteria criteria, long interval) {
        int numOfNodes;
        long queryTime;
        ArrayList<NodeTimeseriesStatistics> stats;
        block7: {
            String index = this.client.getIndex(tenantId);
            stats = new ArrayList<NodeTimeseriesStatistics>();
            queryTime = 0L;
            numOfNodes = 0;
            if (log.isLoggable(Level.FINEST)) {
                queryTime = System.currentTimeMillis();
            }
            try {
                RefreshRequestBuilder refreshRequestBuilder = this.client.getElasticsearchClient().admin().indices().prepareRefresh(new String[]{index});
                this.client.getElasticsearchClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
                BoolQueryBuilder query = ElasticsearchUtil.buildQuery(criteria, "timestamp", "businessTransaction");
                AvgBuilder avgBuilder = (AvgBuilder)AggregationBuilders.avg((String)"avg").field("actual");
                TermsBuilder componentsBuilder = (TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"components").field("componentType")).size(criteria.getMaxResponseSize()).subAggregation((AbstractAggregationBuilder)avgBuilder);
                DateHistogramBuilder histogramBuilder = (DateHistogramBuilder)((DateHistogramBuilder)AggregationBuilders.dateHistogram((String)"histogram").interval(interval).field("timestamp")).subAggregation((AbstractAggregationBuilder)componentsBuilder);
                SearchRequestBuilder request = this.client.getElasticsearchClient().prepareSearch(new String[]{index}).setTypes(new String[]{NODE_DETAILS_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).addAggregation((AbstractAggregationBuilder)histogramBuilder).setTimeout(TimeValue.timeValueMillis((long)criteria.getTimeout())).setSize(0).setQuery((QueryBuilder)query);
                SearchResponse response = (SearchResponse)request.execute().actionGet();
                if (response.isTimedOut()) {
                    this.msgLog.warnQueryTimedOut();
                }
                DateHistogram histogram = (DateHistogram)response.getAggregations().get("histogram");
                for (DateHistogram.Bucket bucket : histogram.getBuckets()) {
                    Terms term = (Terms)bucket.getAggregations().get("components");
                    NodeTimeseriesStatistics s = new NodeTimeseriesStatistics();
                    s.setTimestamp(bucket.getKeyAsDate().getMillis());
                    for (Terms.Bucket termBucket : term.getBuckets()) {
                        Avg avg = (Avg)termBucket.getAggregations().get("avg");
                        s.getComponentTypes().put(termBucket.getKey(), new NodeTimeseriesStatistics.NodeComponentTypeStatistics((long)avg.getValue(), termBucket.getDocCount()));
                    }
                    stats.add(s);
                    numOfNodes = (int)((long)numOfNodes + bucket.getDocCount());
                }
            }
            catch (IndexMissingException t) {
                if (!this.msgLog.isTraceEnabled()) break block7;
                this.msgLog.tracef("No index found, so unable to get node timeseries stats", new Object[0]);
            }
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Performance: Results processed in " + (System.currentTimeMillis() - queryTime) + "ms and " + "number of nodes processed = " + numOfNodes);
        }
        return stats;
    }

    public Collection<NodeSummaryStatistics> getNodeSummaryStatistics(String tenantId, Criteria criteria) {
        ArrayList<NodeSummaryStatistics> stats;
        block16: {
            String index = this.client.getIndex(tenantId);
            stats = new ArrayList<NodeSummaryStatistics>();
            try {
                RefreshRequestBuilder refreshRequestBuilder = this.client.getElasticsearchClient().admin().indices().prepareRefresh(new String[]{index});
                this.client.getElasticsearchClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
                BoolQueryBuilder query = ElasticsearchUtil.buildQuery(criteria, "timestamp", "businessTransaction");
                AvgBuilder actualBuilder = (AvgBuilder)AggregationBuilders.avg((String)"actual").field("actual");
                AvgBuilder elapsedBuilder = (AvgBuilder)AggregationBuilders.avg((String)"elapsed").field("elapsed");
                TermsBuilder operationsBuilder = (TermsBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"operations").field("operation")).size(criteria.getMaxResponseSize()).subAggregation((AbstractAggregationBuilder)actualBuilder)).subAggregation((AbstractAggregationBuilder)elapsedBuilder);
                MissingBuilder missingOperationBuilder = (MissingBuilder)((MissingBuilder)AggregationBuilders.missing((String)"missingOperation").field("operation").subAggregation((AbstractAggregationBuilder)actualBuilder)).subAggregation((AbstractAggregationBuilder)elapsedBuilder);
                TermsBuilder urisBuilder = (TermsBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"uris").field("uri")).size(criteria.getMaxResponseSize()).subAggregation((AbstractAggregationBuilder)operationsBuilder)).subAggregation((AbstractAggregationBuilder)missingOperationBuilder);
                TermsBuilder componentsBuilder = (TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"components").field("componentType")).size(criteria.getMaxResponseSize()).subAggregation((AbstractAggregationBuilder)urisBuilder);
                TermsBuilder interactionUrisBuilder = (TermsBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"uris").field("uri")).size(criteria.getMaxResponseSize()).subAggregation((AbstractAggregationBuilder)actualBuilder)).subAggregation((AbstractAggregationBuilder)elapsedBuilder);
                MissingBuilder missingComponentsBuilder = (MissingBuilder)AggregationBuilders.missing((String)"missingcomponent").field("componentType").subAggregation((AbstractAggregationBuilder)interactionUrisBuilder);
                TermsBuilder nodesBuilder = (TermsBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"types").field("type")).size(criteria.getMaxResponseSize()).subAggregation((AbstractAggregationBuilder)componentsBuilder)).subAggregation((AbstractAggregationBuilder)missingComponentsBuilder);
                SearchRequestBuilder request = this.client.getElasticsearchClient().prepareSearch(new String[]{index}).setTypes(new String[]{NODE_DETAILS_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).addAggregation((AbstractAggregationBuilder)nodesBuilder).setTimeout(TimeValue.timeValueMillis((long)criteria.getTimeout())).setSize(0).setQuery((QueryBuilder)query);
                SearchResponse response = (SearchResponse)request.execute().actionGet();
                if (response.isTimedOut()) {
                    this.msgLog.warnQueryTimedOut();
                }
                Terms types = (Terms)response.getAggregations().get("types");
                for (Terms.Bucket typeBucket : types.getBuckets()) {
                    Terms components = (Terms)typeBucket.getAggregations().get("components");
                    for (Terms.Bucket componentBucket : components.getBuckets()) {
                        Terms uris = (Terms)componentBucket.getAggregations().get("uris");
                        for (Terms.Bucket uriBucket : uris.getBuckets()) {
                            Terms operations = (Terms)uriBucket.getAggregations().get("operations");
                            for (Terms.Bucket operationBucket : operations.getBuckets()) {
                                Avg actual = (Avg)operationBucket.getAggregations().get("actual");
                                Avg elapsed = (Avg)operationBucket.getAggregations().get("elapsed");
                                NodeSummaryStatistics stat = new NodeSummaryStatistics();
                                if (typeBucket.getKey().equalsIgnoreCase("consumer")) {
                                    stat.setComponentType("consumer");
                                } else if (typeBucket.getKey().equalsIgnoreCase("producer")) {
                                    stat.setComponentType("producer");
                                } else {
                                    stat.setComponentType(componentBucket.getKey());
                                }
                                stat.setUri(uriBucket.getKey());
                                stat.setOperation(operationBucket.getKey());
                                stat.setActual((long)actual.getValue());
                                stat.setElapsed((long)elapsed.getValue());
                                stat.setCount(operationBucket.getDocCount());
                                stats.add(stat);
                            }
                            Missing missingOp = (Missing)uriBucket.getAggregations().get("missingOperation");
                            if (missingOp == null || missingOp.getDocCount() <= 0L) continue;
                            Avg actual = (Avg)missingOp.getAggregations().get("actual");
                            Avg elapsed = (Avg)missingOp.getAggregations().get("elapsed");
                            if (actual.getValueAsString().equals("NaN")) continue;
                            NodeSummaryStatistics stat = new NodeSummaryStatistics();
                            if (typeBucket.getKey().equalsIgnoreCase("consumer")) {
                                stat.setComponentType("consumer");
                            } else if (typeBucket.getKey().equalsIgnoreCase("producer")) {
                                stat.setComponentType("producer");
                            } else {
                                stat.setComponentType(componentBucket.getKey());
                            }
                            stat.setUri(uriBucket.getKey());
                            stat.setActual((long)actual.getValue());
                            stat.setElapsed((long)elapsed.getValue());
                            stat.setCount(missingOp.getDocCount());
                            stats.add(stat);
                        }
                    }
                    Missing missingComponents = (Missing)typeBucket.getAggregations().get("missingcomponent");
                    Terms uris = (Terms)missingComponents.getAggregations().get("uris");
                    for (Terms.Bucket uriBucket : uris.getBuckets()) {
                        Avg actual = (Avg)uriBucket.getAggregations().get("actual");
                        Avg elapsed = (Avg)uriBucket.getAggregations().get("elapsed");
                        NodeSummaryStatistics stat = new NodeSummaryStatistics();
                        stat.setComponentType(typeBucket.getKey());
                        stat.setUri(uriBucket.getKey());
                        stat.setActual((long)actual.getValue());
                        stat.setElapsed((long)elapsed.getValue());
                        stat.setCount(uriBucket.getDocCount());
                        stats.add(stat);
                    }
                }
            }
            catch (IndexMissingException t) {
                if (!this.msgLog.isTraceEnabled()) break block16;
                this.msgLog.tracef("No index found, so unable to get node summary stats", new Object[0]);
            }
        }
        return stats;
    }

    protected Collection<CommunicationSummaryStatistics> doGetCommunicationSummaryStatistics(String tenantId, Criteria criteria) {
        String index = this.client.getIndex(tenantId);
        HashMap<String, CommunicationSummaryStatistics> stats = new HashMap<String, CommunicationSummaryStatistics>();
        if (!criteria.transactionWide()) {
            Criteria txnWideCriteria = criteria.deriveTransactionWide();
            this.buildCommunicationSummaryStatistics(stats, index, txnWideCriteria, false);
        }
        this.buildCommunicationSummaryStatistics(stats, index, criteria, true);
        return stats.values();
    }

    protected void buildCommunicationSummaryStatistics(Map<String, CommunicationSummaryStatistics> stats, String index, Criteria criteria, boolean addMetrics) {
        block13: {
            try {
                RefreshRequestBuilder refreshRequestBuilder = this.client.getElasticsearchClient().admin().indices().prepareRefresh(new String[]{index});
                this.client.getElasticsearchClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
                BoolQueryBuilder query = ElasticsearchUtil.buildQuery(criteria, "timestamp", "businessTransaction");
                query = query.mustNot((QueryBuilder)QueryBuilders.matchQuery((String)"internal", (Object)"true"));
                StatsBuilder latencyBuilder = (StatsBuilder)AggregationBuilders.stats((String)"latency").field("latency");
                TermsBuilder targetBuilder = (TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"target").field("target")).size(criteria.getMaxResponseSize()).subAggregation((AbstractAggregationBuilder)latencyBuilder);
                TermsBuilder sourceBuilder = (TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"source").field("source")).size(criteria.getMaxResponseSize()).subAggregation((AbstractAggregationBuilder)targetBuilder);
                SearchRequestBuilder request = this.client.getElasticsearchClient().prepareSearch(new String[]{index}).setTypes(new String[]{COMMUNICATION_DETAILS_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).addAggregation((AbstractAggregationBuilder)sourceBuilder).setTimeout(TimeValue.timeValueMillis((long)criteria.getTimeout())).setSize(0).setQuery((QueryBuilder)query);
                SearchResponse response = (SearchResponse)request.execute().actionGet();
                if (response.isTimedOut()) {
                    this.msgLog.warnQueryTimedOut();
                }
                Terms sources = (Terms)response.getAggregations().get("source");
                for (Terms.Bucket sourceBucket : sources.getBuckets()) {
                    Terms targets = (Terms)sourceBucket.getAggregations().get("target");
                    String id = sourceBucket.getKey();
                    CommunicationSummaryStatistics css = stats.get(id);
                    if (css == null) {
                        css = new CommunicationSummaryStatistics();
                        css.setId(sourceBucket.getKey());
                        stats.put(css.getId(), css);
                    }
                    if (addMetrics) {
                        css.setCount(sourceBucket.getDocCount());
                    }
                    for (Terms.Bucket targetBucket : targets.getBuckets()) {
                        Stats latency = (Stats)targetBucket.getAggregations().get("latency");
                        String linkId = targetBucket.getKey();
                        CommunicationSummaryStatistics.ConnectionStatistics con = (CommunicationSummaryStatistics.ConnectionStatistics)css.getOutbound().get(linkId);
                        if (con == null) {
                            con = new CommunicationSummaryStatistics.ConnectionStatistics();
                            css.getOutbound().put(linkId, con);
                        }
                        if (!addMetrics) continue;
                        con.setMinimumLatency((long)latency.getMin());
                        con.setAverageLatency((long)latency.getAvg());
                        con.setMaximumLatency((long)latency.getMax());
                        con.setCount(targetBucket.getDocCount());
                    }
                }
                StatsBuilder durationBuilder = (StatsBuilder)AggregationBuilders.stats((String)"duration").field("duration");
                TermsBuilder operationsBuilder2 = (TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"operations").field("operation")).size(criteria.getMaxResponseSize()).subAggregation((AbstractAggregationBuilder)durationBuilder);
                MissingBuilder missingOperationBuilder2 = (MissingBuilder)AggregationBuilders.missing((String)"missingOperation").field("operation").subAggregation((AbstractAggregationBuilder)durationBuilder);
                TermsBuilder urisBuilder2 = (TermsBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"uris").field("uri")).size(criteria.getMaxResponseSize()).subAggregation((AbstractAggregationBuilder)operationsBuilder2)).subAggregation((AbstractAggregationBuilder)missingOperationBuilder2);
                SearchRequestBuilder request2 = this.client.getElasticsearchClient().prepareSearch(new String[]{index}).setTypes(new String[]{FRAGMENT_COMPLETION_TIME_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).addAggregation((AbstractAggregationBuilder)urisBuilder2).setTimeout(TimeValue.timeValueMillis((long)criteria.getTimeout())).setSize(0).setQuery((QueryBuilder)query);
                SearchResponse response2 = (SearchResponse)request2.execute().actionGet();
                if (response2.isTimedOut()) {
                    this.msgLog.warnQueryTimedOut();
                }
                Terms completions = (Terms)response2.getAggregations().get("uris");
                for (Terms.Bucket urisBucket : completions.getBuckets()) {
                    Terms operations = (Terms)urisBucket.getAggregations().get("operations");
                    for (Terms.Bucket operationBucket : operations.getBuckets()) {
                        Stats duration = (Stats)operationBucket.getAggregations().get("duration");
                        String id = EndpointUtil.encodeEndpoint((String)urisBucket.getKey(), (String)operationBucket.getKey());
                        CommunicationSummaryStatistics css = stats.get(id);
                        if (css == null) {
                            css = new CommunicationSummaryStatistics();
                            css.setId(id);
                            stats.put(id, css);
                        }
                        if (!addMetrics) continue;
                        css.setMinimumDuration((long)duration.getMin());
                        css.setAverageDuration((long)duration.getAvg());
                        css.setMaximumDuration((long)duration.getMax());
                        css.setCount(operationBucket.getDocCount());
                    }
                    Missing missingOp = (Missing)urisBucket.getAggregations().get("missingOperation");
                    if (missingOp == null || missingOp.getDocCount() <= 0L) continue;
                    Stats duration = (Stats)missingOp.getAggregations().get("duration");
                    String id = urisBucket.getKey();
                    CommunicationSummaryStatistics css = stats.get(id);
                    if (css == null) {
                        css = new CommunicationSummaryStatistics();
                        css.setId(id);
                        stats.put(id, css);
                    }
                    if (!addMetrics) continue;
                    css.setMinimumDuration((long)duration.getMin());
                    css.setAverageDuration((long)duration.getAvg());
                    css.setMaximumDuration((long)duration.getMax());
                    css.setCount(missingOp.getDocCount());
                }
            }
            catch (IndexMissingException t) {
                if (!this.msgLog.isTraceEnabled()) break block13;
                this.msgLog.tracef("No index found, so unable to get communication summary stats", new Object[0]);
            }
        }
    }

    public List<String> getHostNames(String tenantId, Criteria criteria) {
        ArrayList<String> ret;
        block7: {
            ret = new ArrayList<String>();
            String index = this.client.getIndex(tenantId);
            try {
                RefreshRequestBuilder refreshRequestBuilder = this.client.getElasticsearchClient().admin().indices().prepareRefresh(new String[]{index});
                this.client.getElasticsearchClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
                BoolQueryBuilder query = ElasticsearchUtil.buildQuery(criteria, "startTime", "businessTransaction");
                SearchRequestBuilder request = this.client.getElasticsearchClient().prepareSearch(new String[]{index}).setTypes(new String[]{"trace"}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setTimeout(TimeValue.timeValueMillis((long)criteria.getTimeout())).setSize(criteria.getMaxResponseSize()).setQuery((QueryBuilder)query);
                SearchResponse response = (SearchResponse)request.execute().actionGet();
                if (response.isTimedOut()) {
                    this.msgLog.warnQueryTimedOut();
                }
                ArrayList<Object> btxns = new ArrayList<Object>();
                for (SearchHit searchHitFields : response.getHits()) {
                    try {
                        btxns.add(mapper.readValue(searchHitFields.getSourceAsString(), Trace.class));
                    }
                    catch (Exception e) {
                        this.msgLog.errorFailedToParse(e);
                    }
                }
                for (int i = 0; i < btxns.size(); ++i) {
                    Trace trace = (Trace)btxns.get(i);
                    if (trace.getHostName() == null || trace.getHostName().trim().isEmpty() || ret.contains(trace.getHostName())) continue;
                    ret.add(trace.getHostName());
                }
            }
            catch (IndexMissingException t) {
                if (!this.msgLog.isTraceEnabled()) break block7;
                this.msgLog.tracef("No index found, so unable to get host names", new Object[0]);
            }
        }
        Collections.sort(ret);
        return ret;
    }

    public void storeCommunicationDetails(String tenantId, List<CommunicationDetails> communicationDetails) throws StoreException {
        this.client.initTenant(tenantId);
        BulkRequestBuilder bulkRequestBuilder = this.client.getElasticsearchClient().prepareBulk();
        try {
            for (int i = 0; i < communicationDetails.size(); ++i) {
                CommunicationDetails cd = communicationDetails.get(i);
                String json = mapper.writeValueAsString((Object)cd);
                if (this.msgLog.isTraceEnabled()) {
                    this.msgLog.tracef("Storing communication details: %s", json);
                }
                bulkRequestBuilder.add(this.client.getElasticsearchClient().prepareIndex(this.client.getIndex(tenantId), COMMUNICATION_DETAILS_TYPE, cd.getId()).setSource(json));
            }
        }
        catch (JsonProcessingException e) {
            throw new StoreException((Throwable)e);
        }
        BulkResponse bulkItemResponses = (BulkResponse)bulkRequestBuilder.execute().actionGet();
        if (bulkItemResponses.hasFailures()) {
            if (this.msgLog.isTraceEnabled()) {
                this.msgLog.trace("Failed to store communication details to elasticsearch: " + bulkItemResponses.buildFailureMessage());
            }
            throw new StoreException(bulkItemResponses.buildFailureMessage());
        }
        if (this.msgLog.isTraceEnabled()) {
            this.msgLog.trace("Success storing communication details to elasticsearch");
        }
    }

    public void storeNodeDetails(String tenantId, List<NodeDetails> nodeDetails) throws StoreException {
        this.client.initTenant(tenantId);
        BulkRequestBuilder bulkRequestBuilder = this.client.getElasticsearchClient().prepareBulk();
        try {
            for (int i = 0; i < nodeDetails.size(); ++i) {
                NodeDetails rt = nodeDetails.get(i);
                String json = mapper.writeValueAsString((Object)rt);
                if (this.msgLog.isTraceEnabled()) {
                    this.msgLog.tracef("Storing node details: %s", json);
                }
                bulkRequestBuilder.add(this.client.getElasticsearchClient().prepareIndex(this.client.getIndex(tenantId), NODE_DETAILS_TYPE, rt.getId()).setSource(json));
            }
        }
        catch (JsonProcessingException e) {
            throw new StoreException((Throwable)e);
        }
        BulkResponse bulkItemResponses = (BulkResponse)bulkRequestBuilder.execute().actionGet();
        if (bulkItemResponses.hasFailures()) {
            if (this.msgLog.isTraceEnabled()) {
                this.msgLog.trace("Failed to store node details to elasticsearch: " + bulkItemResponses.buildFailureMessage());
            }
            throw new StoreException(bulkItemResponses.buildFailureMessage());
        }
        if (this.msgLog.isTraceEnabled()) {
            this.msgLog.trace("Success storing node details to elasticsearch");
        }
    }

    public void storeTraceCompletionTimes(String tenantId, List<CompletionTime> completionTimes) throws StoreException {
        this.client.initTenant(tenantId);
        BulkRequestBuilder bulkRequestBuilder = this.client.getElasticsearchClient().prepareBulk();
        try {
            for (int i = 0; i < completionTimes.size(); ++i) {
                CompletionTime ct = completionTimes.get(i);
                String json = mapper.writeValueAsString((Object)ct);
                if (this.msgLog.isTraceEnabled()) {
                    this.msgLog.tracef("Storing btxn completion time: %s", json);
                }
                bulkRequestBuilder.add(this.client.getElasticsearchClient().prepareIndex(this.client.getIndex(tenantId), TRACE_COMPLETION_TIME_TYPE, ct.getId()).setSource(json));
            }
        }
        catch (JsonProcessingException e) {
            throw new StoreException((Throwable)e);
        }
        BulkResponse bulkItemResponses = (BulkResponse)bulkRequestBuilder.execute().actionGet();
        if (bulkItemResponses.hasFailures()) {
            if (this.msgLog.isTraceEnabled()) {
                this.msgLog.trace("Failed to store btxn completion times to elasticsearch: " + bulkItemResponses.buildFailureMessage());
            }
            throw new StoreException(bulkItemResponses.buildFailureMessage());
        }
        if (this.msgLog.isTraceEnabled()) {
            this.msgLog.trace("Success storing btxn completion times to elasticsearch");
        }
    }

    public void storeFragmentCompletionTimes(String tenantId, List<CompletionTime> completionTimes) throws StoreException {
        this.client.initTenant(tenantId);
        BulkRequestBuilder bulkRequestBuilder = this.client.getElasticsearchClient().prepareBulk();
        try {
            for (int i = 0; i < completionTimes.size(); ++i) {
                CompletionTime ct = completionTimes.get(i);
                String json = mapper.writeValueAsString((Object)ct);
                if (this.msgLog.isTraceEnabled()) {
                    this.msgLog.tracef("Storing fragment completion time: %s", json);
                }
                bulkRequestBuilder.add(this.client.getElasticsearchClient().prepareIndex(this.client.getIndex(tenantId), FRAGMENT_COMPLETION_TIME_TYPE, ct.getId()).setSource(json));
            }
        }
        catch (JsonProcessingException e) {
            throw new StoreException((Throwable)e);
        }
        BulkResponse bulkItemResponses = (BulkResponse)bulkRequestBuilder.execute().actionGet();
        if (bulkItemResponses.hasFailures()) {
            if (this.msgLog.isTraceEnabled()) {
                this.msgLog.trace("Failed to store fragment completion times to elasticsearch: " + bulkItemResponses.buildFailureMessage());
            }
            throw new StoreException(bulkItemResponses.buildFailureMessage());
        }
        if (this.msgLog.isTraceEnabled()) {
            this.msgLog.trace("Success storing fragment completion times to elasticsearch");
        }
    }

    public void clear(String tenantId) {
        String index = this.client.getIndex(tenantId);
        try {
            this.client.getElasticsearchClient().admin().indices().prepareDelete(new String[]{index}).execute().actionGet();
            this.client.clear(tenantId);
        }
        catch (IndexMissingException indexMissingException) {
            // empty catch block
        }
    }
}

