/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.server.jms;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import org.hawkular.apm.api.services.Publisher;
import org.hawkular.apm.api.services.PublisherMetricHandler;
import org.hawkular.apm.api.services.ServiceLifecycle;
import org.hawkular.apm.api.services.ServiceStatus;
import org.hawkular.apm.api.utils.PropertyUtil;
import org.hawkular.apm.server.jms.log.MsgLogger;

public abstract class AbstractPublisherJMS<T>
implements Publisher<T>,
ServiceLifecycle,
ServiceStatus {
    private static final Logger log = Logger.getLogger(AbstractPublisherJMS.class.getName());
    private static final int DEFAULT_INITIAL_RETRY_COUNT = 3;
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private static ObjectMapper mapper = new ObjectMapper();
    private Connection connection;
    private Session session;
    private MessageProducer producer;
    private int initialRetryCount = PropertyUtil.getPropertyAsInteger((String)"HAWKULAR_APM_PROCESSOR_MAX_RETRY_COUNT", (Integer)3);

    public boolean isAvailable() {
        return !PropertyUtil.hasProperty((String)"HAWKULAR_APM_URI_PUBLISHER");
    }

    protected abstract String getDestinationURI();

    public int getInitialRetryCount() {
        return this.initialRetryCount;
    }

    public void setInitialRetryCount(int initialRetryCount) {
        this.initialRetryCount = initialRetryCount;
    }

    @PostConstruct
    public void init() {
        try {
            InitialContext context = new InitialContext();
            ConnectionFactory connectionFactory = (ConnectionFactory)context.lookup("java:/APMJMSCF");
            this.connection = connectionFactory.createConnection();
            this.session = this.connection.createSession(false, 1);
            Destination destination = (Destination)context.lookup(this.getDestinationURI());
            this.producer = this.session.createProducer(destination);
            this.connection.start();
        }
        catch (Exception e) {
            this.msgLog.errorFailedToInitPublisher(this.getDestinationURI(), e);
        }
    }

    protected void doPublish(String tenantId, List<T> items, String subscriber, int retryCount, long delay) throws Exception {
        String data = mapper.writeValueAsString(items);
        TextMessage tm = this.session.createTextMessage(data);
        if (tenantId != null) {
            tm.setStringProperty("tenant", tenantId);
        }
        if (subscriber != null) {
            tm.setStringProperty("subscriber", subscriber);
        }
        tm.setIntProperty("retryCount", retryCount);
        if (delay > 0L) {
            tm.setLongProperty("_AMQ_SCHED_DELIVERY", System.currentTimeMillis() + delay);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Publish: " + tm);
        }
        this.producer.send((Message)tm);
    }

    public void publish(String tenantId, List<T> items, int retryCount, long delay) throws Exception {
        this.doPublish(tenantId, items, null, retryCount, delay);
    }

    public void publish(String tenantId, List<T> items) throws Exception {
        this.doPublish(tenantId, items, null, this.getInitialRetryCount(), 0L);
    }

    public void retry(String tenantId, List<T> items, String subscriber, int retryCount, long delay) throws Exception {
        this.doPublish(tenantId, items, subscriber, retryCount, delay);
    }

    @PreDestroy
    public void close() {
        try {
            if (this.session != null) {
                this.session.close();
            }
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (Exception e) {
            this.msgLog.errorFailedToClosePublisher(this.getDestinationURI(), e);
        }
    }

    public void setMetricHandler(PublisherMetricHandler<T> handler) {
    }
}

