/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.server.jms;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.inject.Inject;
import javax.jms.MessageListener;
import org.hawkular.apm.api.model.events.CommunicationDetails;
import org.hawkular.apm.server.api.services.CacheException;
import org.hawkular.apm.server.api.services.CommunicationDetailsCache;
import org.hawkular.apm.server.api.task.AbstractProcessor;
import org.hawkular.apm.server.api.task.Processor;
import org.hawkular.apm.server.api.task.RetryAttemptException;
import org.hawkular.apm.server.jms.CommunicationDetailsPublisherJMS;
import org.hawkular.apm.server.jms.RetryCapableMDB;

@MessageDriven(name="CommunicationDetails_CommunicationDetailsCache", messageListenerInterface=MessageListener.class, activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Topic"), @ActivationConfigProperty(propertyName="destination", propertyValue="CommunicationDetails"), @ActivationConfigProperty(propertyName="subscriptionDurability", propertyValue="Durable"), @ActivationConfigProperty(propertyName="clientID", propertyValue="apm-${jboss.node.name}"), @ActivationConfigProperty(propertyName="subscriptionName", propertyValue="CommunicationDetailsCache"), @ActivationConfigProperty(propertyName="messageSelector", propertyValue="subscriber IS NULL OR subscriber = 'CommunicationDetailsCache'")})
public class CommunicationDetailsCacheMDB
extends RetryCapableMDB<CommunicationDetails, Void> {
    @Inject
    private CommunicationDetailsPublisherJMS communicationDetailsPublisher;
    @Inject
    private CommunicationDetailsCache communicationDetailsCache;
    public static final String SUBSCRIBER = "CommunicationDetailsCache";

    public CommunicationDetailsCacheMDB() {
        super(SUBSCRIBER);
    }

    @PostConstruct
    public void init() {
        this.setRetryPublisher(this.communicationDetailsPublisher);
        this.setTypeReference(new TypeReference<List<CommunicationDetails>>(){});
        this.setProcessor(new AbstractProcessor<CommunicationDetails, Void>(Processor.ProcessorType.ManyToMany){

            public List<Void> processManyToMany(String tenantId, List<CommunicationDetails> items) throws RetryAttemptException {
                try {
                    CommunicationDetailsCacheMDB.this.communicationDetailsCache.store(tenantId, items);
                }
                catch (CacheException e) {
                    throw new RetryAttemptException((Throwable)e);
                }
                return null;
            }
        });
    }
}

