/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.server.jms.span;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.inject.Inject;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.hawkular.apm.server.api.model.zipkin.Span;
import org.hawkular.apm.server.api.services.CacheException;
import org.hawkular.apm.server.api.services.SpanCache;
import org.hawkular.apm.server.api.utils.zipkin.SpanUniqueIdGenerator;

@MessageDriven(name="Span_Cache", messageListenerInterface=MessageListener.class, activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Topic"), @ActivationConfigProperty(propertyName="destination", propertyValue="Spans"), @ActivationConfigProperty(propertyName="subscriptionDurability", propertyValue="Durable"), @ActivationConfigProperty(propertyName="clientID", propertyValue="apm-${jboss.node.name}"), @ActivationConfigProperty(propertyName="subscriptionName", propertyValue="SpanCache")})
public class SpanCacheMDB
implements MessageListener {
    private static final Logger log = Logger.getLogger(SpanCacheMDB.class.getName());
    public static final String SUBSCRIBER = "SpanCache";
    private static final ObjectMapper mapper = new ObjectMapper();
    @Inject
    private SpanCache spanCache;
    private TypeReference<List<Span>> typeRef = new TypeReference<List<Span>>(){};

    public void onMessage(Message message) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Message received=" + message);
        }
        try {
            String tenantId = message.getStringProperty("tenant");
            String data = ((TextMessage)message).getText();
            List items = (List)mapper.readValue(data, this.typeRef);
            this.spanCache.store(tenantId, items, SpanUniqueIdGenerator::toUnique);
        }
        catch (IOException | JMSException | CacheException e) {
            log.log(Level.SEVERE, "Failed to process message", e);
        }
    }
}

