/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.server.jms.span;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.inject.Inject;
import javax.jms.MessageListener;
import org.hawkular.apm.api.services.StoreException;
import org.hawkular.apm.server.api.model.zipkin.Span;
import org.hawkular.apm.server.api.services.SpanService;
import org.hawkular.apm.server.api.task.AbstractProcessor;
import org.hawkular.apm.server.api.task.Processor;
import org.hawkular.apm.server.api.task.RetryAttemptException;
import org.hawkular.apm.server.api.utils.zipkin.SpanUniqueIdGenerator;
import org.hawkular.apm.server.jms.RetryCapableMDB;
import org.hawkular.apm.server.jms.span.SpanPublisherJMS;

@MessageDriven(name="Span_Store", messageListenerInterface=MessageListener.class, activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Topic"), @ActivationConfigProperty(propertyName="destination", propertyValue="Spans"), @ActivationConfigProperty(propertyName="subscriptionDurability", propertyValue="Durable"), @ActivationConfigProperty(propertyName="clientID", propertyValue="SpanStore"), @ActivationConfigProperty(propertyName="subscriptionName", propertyValue="SpanStore"), @ActivationConfigProperty(propertyName="messageSelector", propertyValue="subscriber IS NULL OR subscriber = 'SpanStore'")})
public class SpanStoreMDB
extends RetryCapableMDB<Span, Void> {
    public static final String SUBSCRIBER = "SpanStore";
    @Inject
    private SpanPublisherJMS spanPublisher;
    @Inject
    private SpanService spanService;

    public SpanStoreMDB() {
        super(SUBSCRIBER);
    }

    @PostConstruct
    public void init() {
        this.setRetryPublisher(this.spanPublisher);
        this.setTypeReference(new TypeReference<List<Span>>(){});
        this.setProcessor(new AbstractProcessor<Span, Void>(Processor.ProcessorType.ManyToMany){

            public List<Void> processManyToMany(String tenantId, List<Span> spans) throws RetryAttemptException {
                try {
                    SpanStoreMDB.this.spanService.storeSpan(tenantId, spans, SpanUniqueIdGenerator::toUnique);
                }
                catch (StoreException ex) {
                    throw new RetryAttemptException((Throwable)ex);
                }
                return null;
            }
        });
    }
}

