/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.server.jms.trace;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.inject.Inject;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.hawkular.apm.api.model.trace.Trace;
import org.hawkular.apm.server.api.services.ProducerInfoCache;
import org.hawkular.apm.server.api.utils.ProducerInfoUtil;

@MessageDriven(name="Trace_ProducerInfoCache", messageListenerInterface=MessageListener.class, activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Topic"), @ActivationConfigProperty(propertyName="destination", propertyValue="Traces"), @ActivationConfigProperty(propertyName="subscriptionDurability", propertyValue="Durable"), @ActivationConfigProperty(propertyName="clientID", propertyValue="apm-${jboss.node.name}"), @ActivationConfigProperty(propertyName="subscriptionName", propertyValue="ProducerInfoCache")})
public class ProducerInfoCacheMDB
implements MessageListener {
    private static final Logger log = Logger.getLogger(ProducerInfoCacheMDB.class.getName());
    @Inject
    private ProducerInfoCache producerInfoCache;
    private static final ObjectMapper mapper = new ObjectMapper();
    private TypeReference<List<Trace>> typeRef = new TypeReference<List<Trace>>(){};

    public void onMessage(Message message) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Message received=" + message);
        }
        try {
            String tenantId = message.getStringProperty("tenant");
            String data = ((TextMessage)message).getText();
            List items = (List)mapper.readValue(data, this.typeRef);
            ProducerInfoUtil.initialise((String)tenantId, (List)items, (ProducerInfoCache)this.producerInfoCache);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

