/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.server.jms;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.inject.Inject;
import javax.jms.MessageListener;
import org.hawkular.apm.api.model.trace.Trace;
import org.hawkular.apm.api.services.StoreException;
import org.hawkular.apm.api.services.TraceService;
import org.hawkular.apm.server.api.task.AbstractProcessor;
import org.hawkular.apm.server.api.task.Processor;
import org.hawkular.apm.server.api.task.RetryAttemptException;
import org.hawkular.apm.server.jms.RetryCapableMDB;
import org.hawkular.apm.server.jms.TracePublisherJMS;

@MessageDriven(name="Trace_Store", messageListenerInterface=MessageListener.class, activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Topic"), @ActivationConfigProperty(propertyName="destination", propertyValue="Traces"), @ActivationConfigProperty(propertyName="subscriptionDurability", propertyValue="Durable"), @ActivationConfigProperty(propertyName="clientID", propertyValue="TraceStore"), @ActivationConfigProperty(propertyName="subscriptionName", propertyValue="TraceStore"), @ActivationConfigProperty(propertyName="messageSelector", propertyValue="subscriber IS NULL OR subscriber = 'TraceStore'")})
public class TraceStoreMDB
extends RetryCapableMDB<Trace, Void> {
    @Inject
    private TracePublisherJMS tracePublisher;
    @Inject
    private TraceService traceService;
    public static final String SUBSCRIBER = "TraceStore";

    public TraceStoreMDB() {
        super(SUBSCRIBER);
    }

    @PostConstruct
    public void init() {
        this.setRetryPublisher(this.tracePublisher);
        this.setTypeReference(new TypeReference<List<Trace>>(){});
        this.setProcessor(new AbstractProcessor<Trace, Void>(Processor.ProcessorType.ManyToMany){

            public List<Void> processManyToMany(String tenantId, List<Trace> items) throws RetryAttemptException {
                try {
                    TraceStoreMDB.this.traceService.storeTraces(tenantId, items);
                }
                catch (StoreException se) {
                    throw new RetryAttemptException((Throwable)se);
                }
                return null;
            }
        });
    }
}

