/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.server.jms;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.inject.Inject;
import javax.jms.MessageListener;
import org.hawkular.apm.api.model.events.CompletionTime;
import org.hawkular.apm.api.services.AnalyticsService;
import org.hawkular.apm.api.services.StoreException;
import org.hawkular.apm.server.api.task.AbstractProcessor;
import org.hawkular.apm.server.api.task.Processor;
import org.hawkular.apm.server.api.task.RetryAttemptException;
import org.hawkular.apm.server.jms.FragmentCompletionTimePublisherJMS;
import org.hawkular.apm.server.jms.RetryCapableMDB;

@MessageDriven(name="FragmentCompletionTimes_Store", messageListenerInterface=MessageListener.class, activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Topic"), @ActivationConfigProperty(propertyName="destination", propertyValue="FragmentCompletionTimes"), @ActivationConfigProperty(propertyName="subscriptionDurability", propertyValue="Durable"), @ActivationConfigProperty(propertyName="clientID", propertyValue="FragmentCompletionTimeStore"), @ActivationConfigProperty(propertyName="subscriptionName", propertyValue="FragmentCompletionTimeStore"), @ActivationConfigProperty(propertyName="messageSelector", propertyValue="subscriber IS NULL OR subscriber = 'FragmentCompletionTimeStore'")})
public class FragmentCompletionTimeStoreMDB
extends RetryCapableMDB<CompletionTime, Void> {
    @Inject
    private FragmentCompletionTimePublisherJMS fragmentCompletionTimePublisher;
    @Inject
    private AnalyticsService analyticsService;
    public static final String SUBSCRIBER = "FragmentCompletionTimeStore";

    public FragmentCompletionTimeStoreMDB() {
        super(SUBSCRIBER);
    }

    @PostConstruct
    public void init() {
        this.setRetryPublisher(this.fragmentCompletionTimePublisher);
        this.setTypeReference(new TypeReference<List<CompletionTime>>(){});
        this.setProcessor(new AbstractProcessor<CompletionTime, Void>(Processor.ProcessorType.ManyToMany){

            public List<Void> processManyToMany(String tenantId, List<CompletionTime> items) throws RetryAttemptException {
                try {
                    FragmentCompletionTimeStoreMDB.this.analyticsService.storeFragmentCompletionTimes(tenantId, items);
                }
                catch (StoreException se) {
                    throw new RetryAttemptException((Throwable)se);
                }
                return null;
            }
        });
    }
}

