/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.server.kafka;

import java.util.List;
import java.util.concurrent.Executor;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.hawkular.apm.api.utils.PropertyUtil;
import org.hawkular.apm.server.api.cdi.Eager;
import org.hawkular.apm.server.api.services.SpanPublisher;
import org.hawkular.apm.server.api.utils.zipkin.ZipkinSpanConvertor;
import org.jboss.logging.Logger;
import zipkin.Component;
import zipkin.collector.kafka.KafkaCollector;
import zipkin.storage.AsyncSpanConsumer;
import zipkin.storage.AsyncSpanStore;
import zipkin.storage.SpanStore;
import zipkin.storage.StorageAdapters;
import zipkin.storage.StorageComponent;

@Eager
@ApplicationScoped
public class KafkaZipkinSpansConsumer {
    private static final Logger log = Logger.getLogger(KafkaZipkinSpansConsumer.class);
    @Inject
    private SpanPublisher spanPublisher;

    @PostConstruct
    public void initializeZipkinKafkaCollector() {
        if (PropertyUtil.getKafkaZookeeper() == null) {
            return;
        }
        if (this.spanPublisher == null) {
            throw new IllegalStateException("Span publisher is null!");
        }
        log.infof("Initializing Zipkin kafka collector", new Object[0]);
        KafkaCollector kafkaCollector = KafkaCollector.builder().zookeeper(PropertyUtil.getKafkaZookeeper()).storage((StorageComponent)new APMZipkinSpanStorage(this.spanPublisher)).build();
        kafkaCollector.start();
    }

    private static class APMZipkinSpanStorage
    implements StorageComponent {
        private final AsyncSpanConsumer asyncSpanConsumer;
        private final Executor callingThread = command -> command.run();

        public APMZipkinSpanStorage(SpanPublisher spanPublisher) {
            this.asyncSpanConsumer = StorageAdapters.blockingToAsync(spans -> {
                try {
                    spanPublisher.publish(null, ZipkinSpanConvertor.spans((List)spans));
                }
                catch (Exception e) {
                    log.errorf("Could not publish spans, reason: %s", (Object)e.getMessage());
                }
            }, (Executor)this.callingThread);
        }

        public SpanStore spanStore() {
            throw new UnsupportedOperationException();
        }

        public AsyncSpanStore asyncSpanStore() {
            throw new UnsupportedOperationException();
        }

        public AsyncSpanConsumer asyncSpanConsumer() {
            return this.asyncSpanConsumer;
        }

        public Component.CheckResult check() {
            return Component.CheckResult.OK;
        }

        public void close() {
        }
    }
}

