/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.processor.alerts;

import feign.RequestInterceptor;
import feign.Retryer;
import feign.auth.BasicAuthRequestInterceptor;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.hystrix.HystrixFeign;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import java.util.List;
import javax.ejb.Asynchronous;
import javax.ejb.Stateless;
import org.hawkular.apm.api.utils.PropertyUtil;
import org.hawkular.apm.processor.alerts.AlertsService;
import org.hawkular.apm.processor.alerts.Event;
import org.hawkular.apm.processor.alerts.MsgLogger;

@Stateless
public class AlertsPublisher {
    private static final MsgLogger logger = MsgLogger.LOGGER;
    private static final String BASE_URL = PropertyUtil.getProperty((String)"HAWKULAR_URI");
    private static final String USERNAME = PropertyUtil.getProperty((String)"HAWKULAR_USERNAME");
    private static final String PASSWORD = PropertyUtil.getProperty((String)"HAWKULAR_PASSWORD");
    private static final String TARGET = String.format("%s/hawkular/alerts", BASE_URL);

    @Asynchronous
    public void publish(List<Event> eventList) {
        eventList.forEach(completionTime -> this.publish((Event)completionTime));
    }

    @Asynchronous
    public void publish(Event event) {
        if (BASE_URL == null || BASE_URL.isEmpty()) {
            logger.hawkularServerNotConfigured();
            return;
        }
        if (USERNAME == null || USERNAME.isEmpty()) {
            logger.hawkularServerUsernameNotConfigured();
            return;
        }
        if (PASSWORD == null || PASSWORD.isEmpty()) {
            logger.hawkularServerPasswordNotConfigured();
            return;
        }
        ((AlertsService)HystrixFeign.builder().requestInterceptor((RequestInterceptor)new BasicAuthRequestInterceptor(USERNAME, PASSWORD)).encoder((Encoder)new JacksonEncoder()).decoder((Decoder)new JacksonDecoder()).retryer((Retryer)new Retryer.Default()).target(AlertsService.class, TARGET)).addEvent(event);
    }
}

