/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.processor.alerts;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.inject.Inject;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.hawkular.apm.api.model.events.NodeDetails;
import org.hawkular.apm.processor.alerts.AlertsPublisher;
import org.hawkular.apm.processor.alerts.Event;
import org.hawkular.apm.processor.alerts.MsgLogger;

@MessageDriven(name="NodeDetails_Alerts", messageListenerInterface=MessageListener.class, activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Topic"), @ActivationConfigProperty(propertyName="destination", propertyValue="NodeDetails"), @ActivationConfigProperty(propertyName="subscriptionDurability", propertyValue="Durable"), @ActivationConfigProperty(propertyName="clientID", propertyValue="InvocationAlertsPublisher"), @ActivationConfigProperty(propertyName="subscriptionName", propertyValue="InvocationAlertsPublisher"), @ActivationConfigProperty(propertyName="messageSelector", propertyValue="subscriber IS NULL OR subscriber = 'InvocationAlertsPublisher'")})
public class InvocationAlertsPublisherMDB
implements MessageListener {
    static final String SUBSCRIBER = "InvocationAlertsPublisher";
    private static final MsgLogger logger = MsgLogger.LOGGER;
    private static final ObjectMapper mapper = new ObjectMapper();
    @Inject
    AlertsPublisher publisher;

    public void onMessage(Message message) {
        logger.invocationDetailsReceived();
        try {
            String data = ((TextMessage)message).getText();
            List items = (List)mapper.readValue(data, (TypeReference)new TypeReference<List<NodeDetails>>(){});
            List<Event> events = items.stream().filter(nd -> nd.isInitial()).map(InvocationAlertsPublisherMDB::toEvent).collect(Collectors.toList());
            if (!events.isEmpty()) {
                this.publisher.publish(events);
            }
        }
        catch (IOException | JMSException e) {
            logger.errorPublishingToAlerts(e);
        }
    }

    public static Event toEvent(NodeDetails nodeDetails) {
        Event event = new Event();
        event.getContext().put("id", nodeDetails.getId());
        if (null != nodeDetails.getUri()) {
            event.getTags().put("uri", nodeDetails.getUri());
        }
        if (null != nodeDetails.getOperation()) {
            event.getTags().put("operation", nodeDetails.getOperation());
        }
        event.initTagsFromProperties(nodeDetails.getProperties());
        event.setDataId("Invocation");
        event.setCategory("APM");
        event.setDataSource(nodeDetails.getHostName());
        event.setId(UUID.randomUUID().toString());
        event.setCtime(nodeDetails.getTimestamp());
        event.setText(Long.toString(nodeDetails.getElapsed()));
        return event;
    }
}

