/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.processor.alerts;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.inject.Inject;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.hawkular.apm.api.model.events.CompletionTime;
import org.hawkular.apm.processor.alerts.AlertsPublisher;
import org.hawkular.apm.processor.alerts.Event;
import org.hawkular.apm.processor.alerts.MsgLogger;

@MessageDriven(name="TraceCompletions_Alerts", messageListenerInterface=MessageListener.class, activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Topic"), @ActivationConfigProperty(propertyName="destination", propertyValue="TraceCompletions"), @ActivationConfigProperty(propertyName="subscriptionDurability", propertyValue="Durable"), @ActivationConfigProperty(propertyName="clientID", propertyValue="TraceCompletionAlertsPublisher"), @ActivationConfigProperty(propertyName="subscriptionName", propertyValue="TraceCompletionAlertsPublisher"), @ActivationConfigProperty(propertyName="messageSelector", propertyValue="subscriber IS NULL OR subscriber = 'TraceCompletionAlertsPublisher'")})
public class TraceCompletionAlertsPublisherMDB
implements MessageListener {
    static final String SUBSCRIBER = "TraceCompletionAlertsPublisher";
    private static final MsgLogger logger = MsgLogger.LOGGER;
    private static final ObjectMapper mapper = new ObjectMapper();
    @Inject
    AlertsPublisher publisher;

    public void onMessage(Message message) {
        logger.traceCompletionTimeReceived();
        try {
            String data = ((TextMessage)message).getText();
            List items = (List)mapper.readValue(data, (TypeReference)new TypeReference<List<CompletionTime>>(){});
            List<Event> events = items.stream().map(TraceCompletionAlertsPublisherMDB::toEvent).collect(Collectors.toList());
            if (!events.isEmpty()) {
                this.publisher.publish(events);
            }
        }
        catch (IOException | JMSException e) {
            logger.errorPublishingToAlerts(e);
        }
    }

    public static Event toEvent(CompletionTime completionTime) {
        Event event = new Event();
        event.getContext().put("id", completionTime.getId());
        if (null != completionTime.getUri()) {
            event.getTags().put("uri", completionTime.getUri());
        }
        if (null != completionTime.getOperation()) {
            event.getTags().put("operation", completionTime.getOperation());
        }
        event.initTagsFromProperties(completionTime.getProperties());
        event.setDataId("TraceCompletion");
        event.setCategory("APM");
        event.setDataSource(completionTime.getHostName());
        event.setId(UUID.randomUUID().toString());
        event.setCtime(completionTime.getTimestamp());
        event.setText(Long.toString(completionTime.getDuration()));
        return event;
    }
}

