/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.server.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.hawkular.apm.api.model.analytics.Percentiles;
import org.hawkular.apm.api.services.AnalyticsService;
import org.hawkular.apm.api.services.Criteria;
import org.hawkular.apm.server.api.security.SecurityProvider;
import org.hawkular.apm.server.rest.RESTServiceUtil;

@Path(value="analytics")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(value="analytics", description="Analytics")
public class AnalyticsHandler {
    private static final Logger perfLog = Logger.getLogger("org.hawkular.apm.performance.analytics");
    private static final org.jboss.logging.Logger log = org.jboss.logging.Logger.getLogger(AnalyticsHandler.class);
    @Inject
    SecurityProvider securityProvider;
    @Inject
    AnalyticsService analyticsService;

    @GET
    @Path(value="unboundendpoints")
    @Produces(value={"application/json"})
    @ApiOperation(value="Identify the unbound endpoints", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getUnboundEndpoints(@Context SecurityContext context, @HeaderParam(value="Hawkular-Tenant") String tenantId, @Suspended AsyncResponse response, @ApiParam(required=false, value="optional 'start' time, default 1 hour before current time") @DefaultValue(value="0") @QueryParam(value="startTime") long startTime, @ApiParam(required=false, value="optional 'end' time, default current time") @DefaultValue(value="0") @QueryParam(value="endTime") long endTime, @ApiParam(required=false, value="compress list to show common patterns") @DefaultValue(value="false") @QueryParam(value="compress") boolean compress) {
        try {
            log.tracef("Get unbound endpoints: start [%s] end [%s]", startTime, endTime);
            List endpoints = this.analyticsService.getUnboundEndpoints(this.securityProvider.validate(tenantId, context.getUserPrincipal().getName()), startTime, endTime, compress);
            log.tracef("Got unbound endpoints: start [%s] end [%s] = [%s]", startTime, endTime, (Object)endpoints);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)endpoints).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debug((Object)e.getMessage(), e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="boundendpoints/{name}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Identify the bound endpoints for a business transaction", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getBoundEndpoints(@Context SecurityContext context, @HeaderParam(value="Hawkular-Tenant") String tenantId, @Suspended AsyncResponse response, @ApiParam(required=true, value="business transaction name") @PathParam(value="name") String name, @ApiParam(required=false, value="optional 'start' time, default 1 hour before current time") @DefaultValue(value="0") @QueryParam(value="startTime") long startTime, @ApiParam(required=false, value="optional 'end' time, default current time") @DefaultValue(value="0") @QueryParam(value="endTime") long endTime) {
        try {
            log.tracef("Get bound endpoints: name [%s] start [%s] end [%s]", (Object)name, (Object)startTime, (Object)endTime);
            List endpoints = this.analyticsService.getBoundEndpoints(this.securityProvider.validate(tenantId, context.getUserPrincipal().getName()), name, startTime, endTime);
            log.tracef("Got bound endpoints: name [%s] start [%s] end [%s] = [%s]", new Object[]{name, startTime, endTime, endpoints});
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)endpoints).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debug((Object)e.getMessage(), e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="properties")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get property information", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getPropertyInfo(@Context SecurityContext context, @HeaderParam(value="Hawkular-Tenant") String tenantId, @Suspended AsyncResponse response, @ApiParam(required=true, value="business transaction name") @QueryParam(value="businessTransaction") String businessTransaction, @ApiParam(required=false, value="traces after this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="startTime") long startTime, @ApiParam(required=false, value="traces before this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="endTime") long endTime, @ApiParam(required=false, value="host name") @QueryParam(value="hostName") String hostName, @ApiParam(required=false, value="principal") @QueryParam(value="principal") String principal, @ApiParam(required=false, value="uri") @QueryParam(value="uri") String uri, @ApiParam(required=false, value="operation") @QueryParam(value="operation") String operation, @ApiParam(required=false, value="traces with these properties, defined as a comma separated list of name|value pairs") @DefaultValue(value="") @QueryParam(value="properties") String properties, @ApiParam(required=false, value="faults") @QueryParam(value="faults") String faults) {
        try {
            Criteria criteria = new Criteria();
            criteria.setBusinessTransaction(businessTransaction);
            criteria.setStartTime(startTime);
            criteria.setEndTime(endTime);
            criteria.setHostName(hostName);
            criteria.setPrincipal(principal);
            criteria.setUri(uri);
            criteria.setOperation(operation);
            RESTServiceUtil.decodeProperties(criteria.getProperties(), properties);
            RESTServiceUtil.decodeFaults(criteria.getFaults(), faults);
            log.tracef("Get property info for criteria [%s]", (Object)criteria);
            List pis = this.analyticsService.getPropertyInfo(this.securityProvider.validate(tenantId, context.getUserPrincipal().getName()), criteria);
            log.tracef("Got property info for criteria [%s] = [%s]", (Object)criteria, (Object)pis);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)pis).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debug((Object)e.getMessage(), e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @POST
    @Path(value="properties")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get property information", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getPropertyInfo(@Context SecurityContext context, @HeaderParam(value="Hawkular-Tenant") String tenantId, @Suspended AsyncResponse response, @ApiParam(required=true, value="query criteria") Criteria criteria) {
        try {
            log.tracef("Get property info for criteria [POST] [%s]", (Object)criteria);
            List pis = this.analyticsService.getPropertyInfo(this.securityProvider.validate(tenantId, context.getUserPrincipal().getName()), criteria);
            log.tracef("Got property info for criteria [POST] [%s] = [%s]", (Object)criteria, (Object)pis);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)pis).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debug((Object)e.getMessage(), e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="principals")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get principal information", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getPrincipalInfo(@Context SecurityContext context, @HeaderParam(value="Hawkular-Tenant") String tenantId, @Suspended AsyncResponse response, @ApiParam(required=true, value="business transaction name") @QueryParam(value="businessTransaction") String businessTransaction, @ApiParam(required=false, value="traces after this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="startTime") long startTime, @ApiParam(required=false, value="traces before this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="endTime") long endTime, @ApiParam(required=false, value="host name") @QueryParam(value="hostName") String hostName, @ApiParam(required=false, value="principal") @QueryParam(value="principal") String principal, @ApiParam(required=false, value="uri") @QueryParam(value="uri") String uri, @ApiParam(required=false, value="operation") @QueryParam(value="operation") String operation, @ApiParam(required=false, value="traces with these properties, defined as a comma separated list of name|value pairs") @DefaultValue(value="") @QueryParam(value="properties") String properties, @ApiParam(required=false, value="faults") @QueryParam(value="faults") String faults) {
        try {
            Criteria criteria = new Criteria();
            criteria.setBusinessTransaction(businessTransaction);
            criteria.setStartTime(startTime);
            criteria.setEndTime(endTime);
            criteria.setHostName(hostName);
            criteria.setPrincipal(principal);
            criteria.setUri(uri);
            criteria.setOperation(operation);
            RESTServiceUtil.decodeProperties(criteria.getProperties(), properties);
            RESTServiceUtil.decodeFaults(criteria.getFaults(), faults);
            log.tracef("Get principal info for criteria [%s]", (Object)criteria);
            List pis = this.analyticsService.getPrincipalInfo(this.securityProvider.validate(tenantId, context.getUserPrincipal().getName()), criteria);
            log.tracef("Got principal info for criteria [%s] = [%s]", (Object)criteria, (Object)pis);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)pis).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debug((Object)e.getMessage(), e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @POST
    @Path(value="principals")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get principal information", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getPrincipalInfo(@Context SecurityContext context, @HeaderParam(value="Hawkular-Tenant") String tenantId, @Suspended AsyncResponse response, @ApiParam(required=true, value="query criteria") Criteria criteria) {
        try {
            log.tracef("Get principal info for criteria [POST] [%s]", (Object)criteria);
            List pis = this.analyticsService.getPrincipalInfo(this.securityProvider.validate(tenantId, context.getUserPrincipal().getName()), criteria);
            log.tracef("Got principal info for criteria [POST] [%s] = [%s]", (Object)criteria, (Object)pis);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)pis).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debug((Object)e.getMessage(), e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="trace/completion/count")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the trace completion count", response=Long.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getTraceCompletionCount(@Context SecurityContext context, @HeaderParam(value="Hawkular-Tenant") String tenantId, @Suspended AsyncResponse response, @ApiParam(required=true, value="business transaction name") @QueryParam(value="businessTransaction") String businessTransaction, @ApiParam(required=false, value="traces after this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="startTime") long startTime, @ApiParam(required=false, value="traces before this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="endTime") long endTime, @ApiParam(required=false, value="host name") @QueryParam(value="hostName") String hostName, @ApiParam(required=false, value="principal") @QueryParam(value="principal") String principal, @ApiParam(required=false, value="uri") @QueryParam(value="uri") String uri, @ApiParam(required=false, value="operation") @QueryParam(value="operation") String operation, @ApiParam(required=false, value="traces with these properties, defined as a comma separated list of name|value pairs") @DefaultValue(value="") @QueryParam(value="properties") String properties, @ApiParam(required=false, value="faults") @QueryParam(value="faults") String faults) {
        try {
            Criteria criteria = new Criteria();
            criteria.setBusinessTransaction(businessTransaction);
            criteria.setStartTime(startTime);
            criteria.setEndTime(endTime);
            criteria.setHostName(hostName);
            criteria.setPrincipal(principal);
            criteria.setUri(uri);
            criteria.setOperation(operation);
            RESTServiceUtil.decodeProperties(criteria.getProperties(), properties);
            RESTServiceUtil.decodeFaults(criteria.getFaults(), faults);
            log.tracef("Get trace completion count for criteria [%s]", (Object)criteria);
            long count = this.analyticsService.getTraceCompletionCount(this.securityProvider.validate(tenantId, context.getUserPrincipal().getName()), criteria);
            log.tracef("Got trace completion count: criteria [%s] = [%s]", (Object)criteria, (Object)count);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)count).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debug((Object)e.getMessage(), e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @POST
    @Path(value="trace/completion/count")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the trace completion count", response=Long.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getTraceCompletionCount(@Context SecurityContext context, @HeaderParam(value="Hawkular-Tenant") String tenantId, @Suspended AsyncResponse response, @ApiParam(required=true, value="query criteria") Criteria criteria) {
        try {
            log.tracef("Get trace completion count for criteria [%s]", (Object)criteria);
            long count = this.analyticsService.getTraceCompletionCount(this.securityProvider.validate(tenantId, context.getUserPrincipal().getName()), criteria);
            log.tracef("Got trace completion count: criteria [%s] = [%s]", (Object)criteria, (Object)count);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)count).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debug((Object)e.getMessage(), e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="trace/completion/faultcount")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the number of trace instances that returned a fault", response=Long.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getTraceCompletionFaultCount(@Context SecurityContext context, @HeaderParam(value="Hawkular-Tenant") String tenantId, @Suspended AsyncResponse response, @ApiParam(required=true, value="business transaction name") @QueryParam(value="businessTransaction") String businessTransaction, @ApiParam(required=false, value="traces after this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="startTime") long startTime, @ApiParam(required=false, value="traces before this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="endTime") long endTime, @ApiParam(required=false, value="host name") @QueryParam(value="hostName") String hostName, @ApiParam(required=false, value="principal") @QueryParam(value="principal") String principal, @ApiParam(required=false, value="uri") @QueryParam(value="uri") String uri, @ApiParam(required=false, value="operation") @QueryParam(value="operation") String operation, @ApiParam(required=false, value="traces with these properties, defined as a comma separated list of name|value pairs") @DefaultValue(value="") @QueryParam(value="properties") String properties, @ApiParam(required=false, value="faults") @QueryParam(value="faults") String faults) {
        try {
            Criteria criteria = new Criteria();
            criteria.setBusinessTransaction(businessTransaction);
            criteria.setStartTime(startTime);
            criteria.setEndTime(endTime);
            criteria.setHostName(hostName);
            criteria.setPrincipal(principal);
            criteria.setUri(uri);
            criteria.setOperation(operation);
            RESTServiceUtil.decodeProperties(criteria.getProperties(), properties);
            RESTServiceUtil.decodeFaults(criteria.getFaults(), faults);
            log.tracef("Get trace fault count for criteria [%s]", (Object)criteria);
            long count = this.analyticsService.getTraceCompletionFaultCount(this.securityProvider.validate(tenantId, context.getUserPrincipal().getName()), criteria);
            log.tracef("Got trace fault count: criteria [%s] = [%s]", (Object)criteria, (Object)count);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)count).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debug((Object)e.getMessage(), e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @POST
    @Path(value="trace/completion/faultcount")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the number of trace instances that returned a fault", response=Long.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getTraceCompletionFaultCount(@Context SecurityContext context, @HeaderParam(value="Hawkular-Tenant") String tenantId, @Suspended AsyncResponse response, @ApiParam(required=true, value="query criteria") Criteria criteria) {
        try {
            log.tracef("Get trace fault count for criteria [%s]", (Object)criteria);
            long count = this.analyticsService.getTraceCompletionFaultCount(this.securityProvider.validate(tenantId, context.getUserPrincipal().getName()), criteria);
            log.tracef("Got trace fault count: criteria [%s] = [%s]", (Object)criteria, (Object)count);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)count).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debug((Object)e.getMessage(), e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="trace/completion/times")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the trace completion times associated with criteria", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getTraceCompletionTimes(@Context SecurityContext context, @HeaderParam(value="Hawkular-Tenant") String tenantId, @Suspended AsyncResponse response, @ApiParam(required=true, value="business transaction name") @QueryParam(value="businessTransaction") String businessTransaction, @ApiParam(required=false, value="traces after this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="startTime") long startTime, @ApiParam(required=false, value="traces before this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="endTime") long endTime, @ApiParam(required=false, value="host name") @QueryParam(value="hostName") String hostName, @ApiParam(required=false, value="principal") @QueryParam(value="principal") String principal, @ApiParam(required=false, value="uri") @QueryParam(value="uri") String uri, @ApiParam(required=false, value="operation") @QueryParam(value="operation") String operation, @ApiParam(required=false, value="traces with these properties, defined as a comma separated list of name|value pairs") @DefaultValue(value="") @QueryParam(value="properties") String properties, @ApiParam(required=false, value="faults") @QueryParam(value="faults") String faults) {
        try {
            Criteria criteria = new Criteria();
            criteria.setBusinessTransaction(businessTransaction);
            criteria.setStartTime(startTime);
            criteria.setEndTime(endTime);
            criteria.setHostName(hostName);
            criteria.setPrincipal(principal);
            criteria.setUri(uri);
            criteria.setOperation(operation);
            RESTServiceUtil.decodeProperties(criteria.getProperties(), properties);
            RESTServiceUtil.decodeFaults(criteria.getFaults(), faults);
            log.tracef("Get trace completion times for criteria (GET) [%s]", (Object)criteria);
            List times = this.analyticsService.getTraceCompletionTimes(this.securityProvider.validate(tenantId, context.getUserPrincipal().getName()), criteria);
            log.tracef("Got trace completion times for criteria (GET) [%s] = %s", (Object)criteria, (Object)times);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)times).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debug((Object)e.getMessage(), e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @POST
    @Path(value="trace/completion/times")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the trace completion times associated with criteria", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getTraceCompletionTimes(@Context SecurityContext context, @HeaderParam(value="Hawkular-Tenant") String tenantId, @Suspended AsyncResponse response, @ApiParam(required=true, value="query criteria") Criteria criteria) {
        try {
            log.tracef("Get trace completion times for criteria (POST) [%s]", (Object)criteria);
            List times = this.analyticsService.getTraceCompletionTimes(this.securityProvider.validate(tenantId, context.getUserPrincipal().getName()), criteria);
            log.tracef("Got trace completion times for criteria (POST) [%s] = %s", (Object)criteria, (Object)times);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)times).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debug((Object)e.getMessage(), e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="trace/completion/percentiles")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the trace completion percentiles associated with criteria", response=Percentiles.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getTraceCompletionPercentiles(@Context SecurityContext context, @HeaderParam(value="Hawkular-Tenant") String tenantId, @Suspended AsyncResponse response, @ApiParam(required=true, value="business transaction name") @QueryParam(value="businessTransaction") String businessTransaction, @ApiParam(required=false, value="traces after this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="startTime") long startTime, @ApiParam(required=false, value="traces before this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="endTime") long endTime, @ApiParam(required=false, value="host name") @QueryParam(value="hostName") String hostName, @ApiParam(required=false, value="principal") @QueryParam(value="principal") String principal, @ApiParam(required=false, value="uri") @QueryParam(value="uri") String uri, @ApiParam(required=false, value="operation") @QueryParam(value="operation") String operation, @ApiParam(required=false, value="traces with these properties, defined as a comma separated list of name|value pairs") @DefaultValue(value="") @QueryParam(value="properties") String properties, @ApiParam(required=false, value="faults") @QueryParam(value="faults") String faults) {
        try {
            Criteria criteria = new Criteria();
            criteria.setBusinessTransaction(businessTransaction);
            criteria.setStartTime(startTime);
            criteria.setEndTime(endTime);
            criteria.setHostName(hostName);
            criteria.setPrincipal(principal);
            criteria.setUri(uri);
            criteria.setOperation(operation);
            RESTServiceUtil.decodeProperties(criteria.getProperties(), properties);
            RESTServiceUtil.decodeFaults(criteria.getFaults(), faults);
            log.tracef("Get trace completion percentiles for criteria [%s]", (Object)criteria);
            Percentiles stats = this.analyticsService.getTraceCompletionPercentiles(this.securityProvider.validate(tenantId, context.getUserPrincipal().getName()), criteria);
            log.tracef("Got trace completion percentiles for criteria [%s] = %s", (Object)criteria, (Object)stats);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)stats).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debug((Object)e.getMessage(), e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="trace/completion/statistics")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the trace completion timeseries statistics associated with criteria", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getTraceCompletionTimeseriesStatistics(@Context SecurityContext context, @HeaderParam(value="Hawkular-Tenant") String tenantId, @Suspended AsyncResponse response, @ApiParam(required=true, value="business transaction name") @QueryParam(value="businessTransaction") String businessTransaction, @ApiParam(required=false, value="traces after this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="startTime") long startTime, @ApiParam(required=false, value="traces before this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="endTime") long endTime, @ApiParam(required=false, value="host name") @QueryParam(value="hostName") String hostName, @ApiParam(required=false, value="principal") @QueryParam(value="principal") String principal, @ApiParam(required=false, value="uri") @QueryParam(value="uri") String uri, @ApiParam(required=false, value="operation") @QueryParam(value="operation") String operation, @ApiParam(required=false, value="traces with these properties, defined as a comma separated list of name|value pairs") @DefaultValue(value="") @QueryParam(value="properties") String properties, @ApiParam(required=false, value="aggregation time interval (in milliseconds)") @DefaultValue(value="60000") @QueryParam(value="interval") long interval, @ApiParam(required=false, value="faults") @QueryParam(value="faults") String faults) {
        try {
            Criteria criteria = new Criteria();
            criteria.setBusinessTransaction(businessTransaction);
            criteria.setStartTime(startTime);
            criteria.setEndTime(endTime);
            criteria.setHostName(hostName);
            criteria.setPrincipal(principal);
            criteria.setUri(uri);
            criteria.setOperation(operation);
            RESTServiceUtil.decodeProperties(criteria.getProperties(), properties);
            RESTServiceUtil.decodeFaults(criteria.getFaults(), faults);
            log.tracef("Get trace completion timeseries statistics for criteria [%s] interval [%s]", (Object)criteria, (Object)interval);
            List stats = this.analyticsService.getTraceCompletionTimeseriesStatistics(this.securityProvider.validate(tenantId, context.getUserPrincipal().getName()), criteria, interval);
            log.tracef("Got trace completion timeseries statistics for criteria [%s] = %s", (Object)criteria, (Object)stats);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)stats).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debug((Object)e.getMessage(), e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @POST
    @Path(value="trace/completion/statistics")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the trace completion timeseries statistics associated with criteria", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getTraceCompletionTimeseriesStatistics(@Context SecurityContext context, @HeaderParam(value="Hawkular-Tenant") String tenantId, @Suspended AsyncResponse response, @ApiParam(required=false, value="aggregation time interval (in milliseconds)") @DefaultValue(value="60000") @QueryParam(value="interval") long interval, @ApiParam(required=true, value="query criteria") Criteria criteria) {
        try {
            log.tracef("Get trace completion timeseries statistics for criteria [%s] interval [%s]", (Object)criteria, (Object)interval);
            List stats = this.analyticsService.getTraceCompletionTimeseriesStatistics(this.securityProvider.validate(tenantId, context.getUserPrincipal().getName()), criteria, interval);
            log.tracef("Got trace completion timeseries statistics for criteria [%s] = %s", (Object)criteria, (Object)stats);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)stats).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debug((Object)e.getMessage(), e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="trace/completion/faults")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the trace completion fault details associated with criteria", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getTraceCompletionFaultDetails(@Context SecurityContext context, @HeaderParam(value="Hawkular-Tenant") String tenantId, @Suspended AsyncResponse response, @ApiParam(required=true, value="business transaction name") @QueryParam(value="businessTransaction") String businessTransaction, @ApiParam(required=false, value="traces after this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="startTime") long startTime, @ApiParam(required=false, value="traces before this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="endTime") long endTime, @ApiParam(required=false, value="host name") @QueryParam(value="hostName") String hostName, @ApiParam(required=false, value="principal") @QueryParam(value="principal") String principal, @ApiParam(required=false, value="uri") @QueryParam(value="uri") String uri, @ApiParam(required=false, value="operation") @QueryParam(value="operation") String operation, @ApiParam(required=false, value="traces with these properties, defined as a comma separated list of name|value pairs") @DefaultValue(value="") @QueryParam(value="properties") String properties, @ApiParam(required=false, value="faults") @QueryParam(value="faults") String faults) {
        try {
            Criteria criteria = new Criteria();
            criteria.setBusinessTransaction(businessTransaction);
            criteria.setStartTime(startTime);
            criteria.setEndTime(endTime);
            criteria.setHostName(hostName);
            criteria.setPrincipal(principal);
            criteria.setUri(uri);
            criteria.setOperation(operation);
            RESTServiceUtil.decodeProperties(criteria.getProperties(), properties);
            RESTServiceUtil.decodeFaults(criteria.getFaults(), faults);
            log.tracef("Get trace completion fault details for criteria (GET) [%s]", (Object)criteria);
            List cards = this.analyticsService.getTraceCompletionFaultDetails(this.securityProvider.validate(tenantId, context.getUserPrincipal().getName()), criteria);
            log.tracef("Got trace completion fault details for criteria (GET) [%s] = %s", (Object)criteria, (Object)cards);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)cards).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debug((Object)e.getMessage(), e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @POST
    @Path(value="trace/completion/faults")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the trace completion fault details associated with criteria", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getTraceCompletionFaultDetails(@Context SecurityContext context, @HeaderParam(value="Hawkular-Tenant") String tenantId, @Suspended AsyncResponse response, @ApiParam(required=true, value="query criteria") Criteria criteria) {
        try {
            log.tracef("Get trace completion fault details for criteria (POST) [%s]", (Object)criteria);
            List cards = this.analyticsService.getTraceCompletionFaultDetails(this.securityProvider.validate(tenantId, context.getUserPrincipal().getName()), criteria);
            log.tracef("Got trace completion fault details for criteria (POST) [%s] = %s", (Object)criteria, (Object)cards);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)cards).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debug((Object)e.getMessage(), e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="trace/completion/property/{property}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the trace completion property details associated with criteria", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getTraceCompletionPropertyDetails(@Context SecurityContext context, @HeaderParam(value="Hawkular-Tenant") String tenantId, @Suspended AsyncResponse response, @ApiParam(required=true, value="business transaction name") @QueryParam(value="businessTransaction") String businessTransaction, @ApiParam(required=false, value="traces after this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="startTime") long startTime, @ApiParam(required=false, value="traces before this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="endTime") long endTime, @ApiParam(required=false, value="host name") @QueryParam(value="hostName") String hostName, @ApiParam(required=false, value="principal") @QueryParam(value="principal") String principal, @ApiParam(required=false, value="uri") @QueryParam(value="uri") String uri, @ApiParam(required=false, value="operation") @QueryParam(value="operation") String operation, @ApiParam(required=false, value="traces with these properties, defined as a comma separated list of name|value pairs") @DefaultValue(value="") @QueryParam(value="properties") String properties, @ApiParam(required=false, value="faults") @QueryParam(value="faults") String faults, @ApiParam(required=false, value="property") @PathParam(value="property") String property) {
        try {
            Criteria criteria = new Criteria();
            criteria.setBusinessTransaction(businessTransaction);
            criteria.setStartTime(startTime);
            criteria.setEndTime(endTime);
            criteria.setHostName(hostName);
            criteria.setPrincipal(principal);
            criteria.setUri(uri);
            criteria.setOperation(operation);
            RESTServiceUtil.decodeProperties(criteria.getProperties(), properties);
            RESTServiceUtil.decodeFaults(criteria.getFaults(), faults);
            log.tracef("Get trace completion property details for criteria (GET) [%s] property [%s]", (Object)criteria, (Object)property);
            List cards = this.analyticsService.getTraceCompletionPropertyDetails(this.securityProvider.validate(tenantId, context.getUserPrincipal().getName()), criteria, property);
            log.tracef("Got trace completion property details for criteria (GET) [%s] = %s", (Object)criteria, (Object)cards);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)cards).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debug((Object)e.getMessage(), e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @POST
    @Path(value="trace/completion/property/{property}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the trace completion property details associated with criteria", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getTraceCompletionPropertyDetails(@Context SecurityContext context, @HeaderParam(value="Hawkular-Tenant") String tenantId, @Suspended AsyncResponse response, @ApiParam(required=false, value="property") @PathParam(value="property") String property, @ApiParam(required=true, value="query criteria") Criteria criteria) {
        try {
            log.tracef("Get trace completion property details for criteria (POST) [%s] property [%s]", (Object)criteria, (Object)property);
            List cards = this.analyticsService.getTraceCompletionPropertyDetails(this.securityProvider.validate(tenantId, context.getUserPrincipal().getName()), criteria, property);
            log.tracef("Got trace completion property details for criteria (POST) [%s] = %s", (Object)criteria, (Object)cards);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)cards).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debug((Object)e.getMessage(), e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="node/statistics")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the trace node timeseries statistics associated with criteria", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getNodeTimeseriesStatistics(@Context SecurityContext context, @HeaderParam(value="Hawkular-Tenant") String tenantId, @Suspended AsyncResponse response, @ApiParam(required=false, value="business transaction name") @QueryParam(value="businessTransaction") String businessTransaction, @ApiParam(required=false, value="traces after this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="startTime") long startTime, @ApiParam(required=false, value="traces before this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="endTime") long endTime, @ApiParam(required=false, value="host name") @QueryParam(value="hostName") String hostName, @ApiParam(required=false, value="principal") @QueryParam(value="principal") String principal, @ApiParam(required=false, value="uri") @QueryParam(value="uri") String uri, @ApiParam(required=false, value="operation") @QueryParam(value="operation") String operation, @ApiParam(required=false, value="traces with these properties, defined as a comma separated list of name|value pairs") @DefaultValue(value="") @QueryParam(value="properties") String properties, @ApiParam(required=false, value="aggregation time interval (in milliseconds)") @DefaultValue(value="60000") @QueryParam(value="interval") long interval) {
        try {
            Criteria criteria = new Criteria();
            criteria.setBusinessTransaction(businessTransaction);
            criteria.setStartTime(startTime);
            criteria.setEndTime(endTime);
            criteria.setHostName(hostName);
            criteria.setPrincipal(principal);
            criteria.setUri(uri);
            criteria.setOperation(operation);
            RESTServiceUtil.decodeProperties(criteria.getProperties(), properties);
            log.tracef("Get trace node timeseriesstatistics for criteria [%s] interval [%s]", (Object)criteria, (Object)interval);
            long perfStartTime = 0L;
            if (perfLog.isLoggable(Level.FINEST)) {
                perfStartTime = System.currentTimeMillis();
                perfLog.finest("Performance: about to query node timeseries (criteria hash=" + criteria.hashCode() + ")");
            }
            List stats = this.analyticsService.getNodeTimeseriesStatistics(this.securityProvider.validate(tenantId, context.getUserPrincipal().getName()), criteria, interval);
            if (perfLog.isLoggable(Level.FINEST)) {
                perfLog.finest("Performance: query node timeseries (criteria hash=" + criteria.hashCode() + ") duration=" + (System.currentTimeMillis() - perfStartTime) + "ms");
            }
            log.tracef("Got trace node timeseries statistics for criteria [%s] = %s", (Object)criteria, (Object)stats);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)stats).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debug((Object)e.getMessage(), e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @POST
    @Path(value="node/statistics")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the trace node timeseries statistics associated with criteria", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getNodeTimeseriesStatistics(@Context SecurityContext context, @HeaderParam(value="Hawkular-Tenant") String tenantId, @Suspended AsyncResponse response, @ApiParam(required=false, value="aggregation time interval (in milliseconds)") @DefaultValue(value="60000") @QueryParam(value="interval") long interval, @ApiParam(required=true, value="query criteria") Criteria criteria) {
        try {
            log.tracef("Get trace node timeseries statistics for criteria [%s] interval [%s]", (Object)criteria, (Object)interval);
            long perfStartTime = 0L;
            if (perfLog.isLoggable(Level.FINEST)) {
                perfStartTime = System.currentTimeMillis();
                perfLog.finest("Performance: about to query node timeseries (criteria hash=" + criteria.hashCode() + ")");
            }
            List stats = this.analyticsService.getNodeTimeseriesStatistics(this.securityProvider.validate(tenantId, context.getUserPrincipal().getName()), criteria, interval);
            if (perfLog.isLoggable(Level.FINEST)) {
                perfLog.finest("Performance: query node timeseries (criteria hash=" + criteria.hashCode() + ") duration=" + (System.currentTimeMillis() - perfStartTime) + "ms");
            }
            log.tracef("Got trace node timeseries statistics for criteria [%s] = %s", (Object)criteria, (Object)stats);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)stats).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debug((Object)e.getMessage(), e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="node/summary")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the trace node summary statistics associated with criteria", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getNodeSummaryStatistics(@Context SecurityContext context, @HeaderParam(value="Hawkular-Tenant") String tenantId, @Suspended AsyncResponse response, @ApiParam(required=false, value="business transaction name") @QueryParam(value="businessTransaction") String businessTransaction, @ApiParam(required=false, value="traces after this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="startTime") long startTime, @ApiParam(required=false, value="traces before this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="endTime") long endTime, @ApiParam(required=false, value="host name") @QueryParam(value="hostName") String hostName, @ApiParam(required=false, value="principal") @QueryParam(value="principal") String principal, @ApiParam(required=false, value="uri") @QueryParam(value="uri") String uri, @ApiParam(required=false, value="operation") @QueryParam(value="operation") String operation, @ApiParam(required=false, value="traces with these properties, defined as a comma separated list of name|value pairs") @DefaultValue(value="") @QueryParam(value="properties") String properties) {
        try {
            Criteria criteria = new Criteria();
            criteria.setBusinessTransaction(businessTransaction);
            criteria.setStartTime(startTime);
            criteria.setEndTime(endTime);
            criteria.setHostName(hostName);
            criteria.setPrincipal(principal);
            criteria.setUri(uri);
            criteria.setOperation(operation);
            RESTServiceUtil.decodeProperties(criteria.getProperties(), properties);
            log.tracef("Get trace node summary statistics for criteria [%s]", (Object)criteria);
            long perfStartTime = 0L;
            if (perfLog.isLoggable(Level.FINEST)) {
                perfStartTime = System.currentTimeMillis();
                perfLog.finest("Performance: about to query node summary (criteria hash=" + criteria.hashCode() + ")");
            }
            Collection stats = this.analyticsService.getNodeSummaryStatistics(this.securityProvider.validate(tenantId, context.getUserPrincipal().getName()), criteria);
            if (perfLog.isLoggable(Level.FINEST)) {
                perfLog.finest("Performance: query node summary (criteria hash=" + criteria.hashCode() + ") duration=" + (System.currentTimeMillis() - perfStartTime) + "ms");
            }
            log.tracef("Got trace node summary statistics for criteria [%s] = %s", (Object)criteria, (Object)stats);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)stats).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debug((Object)e.getMessage(), e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @POST
    @Path(value="node/summary")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the trace node summary statistics associated with criteria", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getNodeSummaryStatistics(@Context SecurityContext context, @HeaderParam(value="Hawkular-Tenant") String tenantId, @Suspended AsyncResponse response, @ApiParam(required=true, value="query criteria") Criteria criteria) {
        try {
            log.tracef("Get trace node summary statistics for criteria [%s]", (Object)criteria);
            long perfStartTime = 0L;
            if (perfLog.isLoggable(Level.FINEST)) {
                perfStartTime = System.currentTimeMillis();
                perfLog.finest("Performance: about to query node summary (criteria hash=" + criteria.hashCode() + ")");
            }
            Collection stats = this.analyticsService.getNodeSummaryStatistics(this.securityProvider.validate(tenantId, context.getUserPrincipal().getName()), criteria);
            if (perfLog.isLoggable(Level.FINEST)) {
                perfLog.finest("Performance: query node summary (criteria hash=" + criteria.hashCode() + ") duration=" + (System.currentTimeMillis() - perfStartTime) + "ms");
            }
            log.tracef("Got trace node summary statistics for criteria [%s] = %s", (Object)criteria, (Object)stats);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)stats).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debug((Object)e.getMessage(), e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="communication/summary")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the trace communication summary statistics associated with criteria", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getCommunicationSummaryStatistics(@Context SecurityContext context, @HeaderParam(value="Hawkular-Tenant") String tenantId, @Suspended AsyncResponse response, @ApiParam(required=false, value="business transaction name") @QueryParam(value="businessTransaction") String businessTransaction, @ApiParam(required=false, value="traces after this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="startTime") long startTime, @ApiParam(required=false, value="traces before this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="endTime") long endTime, @ApiParam(required=false, value="host name") @QueryParam(value="hostName") String hostName, @ApiParam(required=false, value="principal") @QueryParam(value="principal") String principal, @ApiParam(required=false, value="uri") @QueryParam(value="uri") String uri, @ApiParam(required=false, value="operation") @QueryParam(value="operation") String operation, @ApiParam(required=false, value="traces with these properties, defined as a comma separated list of name|value pairs") @DefaultValue(value="") @QueryParam(value="properties") String properties, @ApiParam(required=false, value="tree") @QueryParam(value="tree") boolean tree) {
        try {
            Criteria criteria = new Criteria();
            criteria.setBusinessTransaction(businessTransaction);
            criteria.setStartTime(startTime);
            criteria.setEndTime(endTime);
            criteria.setHostName(hostName);
            criteria.setPrincipal(principal);
            criteria.setUri(uri);
            criteria.setOperation(operation);
            RESTServiceUtil.decodeProperties(criteria.getProperties(), properties);
            log.tracef("Get trace communication summary statistics for criteria [%s] as tree [%s]", (Object)criteria, (Object)tree);
            long perfStartTime = 0L;
            if (perfLog.isLoggable(Level.FINEST)) {
                perfStartTime = System.currentTimeMillis();
                perfLog.finest("Performance: about to query communication summary (criteria hash=" + criteria.hashCode() + ")");
            }
            Collection stats = this.analyticsService.getCommunicationSummaryStatistics(this.securityProvider.validate(tenantId, context.getUserPrincipal().getName()), criteria, tree);
            if (perfLog.isLoggable(Level.FINEST)) {
                perfLog.finest("Performance: query communication summary (criteria hash=" + criteria.hashCode() + ") duration=" + (System.currentTimeMillis() - perfStartTime) + "ms");
            }
            log.tracef("Got trace communication summary statistics for criteria [%s] as tree [%s] = %s", (Object)criteria, (Object)tree, (Object)stats);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)stats).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debug((Object)e.getMessage(), e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @POST
    @Path(value="communication/summary")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the trace communication summary statistics associated with criteria", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getCommunicationSummaryStatistics(@Context SecurityContext context, @HeaderParam(value="Hawkular-Tenant") String tenantId, @Suspended AsyncResponse response, @ApiParam(required=true, value="query criteria") Criteria criteria, @ApiParam(required=false, value="tree") @QueryParam(value="tree") boolean tree) {
        try {
            log.tracef("Get trace communication summary statistics for criteria [%s] as tree [%s]", (Object)criteria, (Object)tree);
            long perfStartTime = 0L;
            if (perfLog.isLoggable(Level.FINEST)) {
                perfStartTime = System.currentTimeMillis();
                perfLog.finest("Performance: about to query communication summary (criteria hash=" + criteria.hashCode() + ")");
            }
            Collection stats = this.analyticsService.getCommunicationSummaryStatistics(this.securityProvider.validate(tenantId, context.getUserPrincipal().getName()), criteria, tree);
            if (perfLog.isLoggable(Level.FINEST)) {
                perfLog.finest("Performance: query communication summary (criteria hash=" + criteria.hashCode() + ") duration=" + (System.currentTimeMillis() - perfStartTime) + "ms");
            }
            log.tracef("Got trace communication summary statistics for criteria [%s] as tree [%s] = %s", (Object)criteria, (Object)tree, (Object)stats);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)stats).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debug((Object)e.getMessage(), e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="hostnames")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the host names associated with the criteria", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getHostNames(@Context SecurityContext context, @HeaderParam(value="Hawkular-Tenant") String tenantId, @Suspended AsyncResponse response, @ApiParam(required=false, value="business transaction name") @QueryParam(value="businessTransaction") String businessTransaction, @ApiParam(required=false, value="traces after this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="startTime") long startTime, @ApiParam(required=false, value="traces before this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="endTime") long endTime, @ApiParam(required=false, value="host name") @QueryParam(value="hostName") String hostName, @ApiParam(required=false, value="principal") @QueryParam(value="principal") String principal, @ApiParam(required=false, value="uri") @QueryParam(value="uri") String uri, @ApiParam(required=false, value="operation") @QueryParam(value="operation") String operation, @ApiParam(required=false, value="traces with these properties, defined as a comma separated list of name|value pairs") @DefaultValue(value="") @QueryParam(value="properties") String properties) {
        try {
            Criteria criteria = new Criteria();
            criteria.setBusinessTransaction(businessTransaction);
            criteria.setStartTime(startTime);
            criteria.setEndTime(endTime);
            criteria.setHostName(hostName);
            criteria.setPrincipal(principal);
            criteria.setUri(uri);
            criteria.setOperation(operation);
            RESTServiceUtil.decodeProperties(criteria.getProperties(), properties);
            log.tracef("Get host names for criteria [%s]", (Object)criteria);
            long perfStartTime = 0L;
            if (perfLog.isLoggable(Level.FINEST)) {
                perfStartTime = System.currentTimeMillis();
                perfLog.finest("Performance: about to query host names (criteria hash=" + criteria.hashCode() + ")");
            }
            List hostnames = this.analyticsService.getHostNames(this.securityProvider.validate(tenantId, context.getUserPrincipal().getName()), criteria);
            if (perfLog.isLoggable(Level.FINEST)) {
                perfLog.finest("Performance: query host names (criteria hash=" + criteria.hashCode() + ") duration=" + (System.currentTimeMillis() - perfStartTime) + "ms");
            }
            log.tracef("Got host names for criteria [%s] = %s", (Object)criteria, (Object)hostnames);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)hostnames).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debug((Object)e.getMessage(), e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @POST
    @Path(value="hostnames")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the host names associated with the criteria", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void getHostNames(@Context SecurityContext context, @HeaderParam(value="Hawkular-Tenant") String tenantId, @Suspended AsyncResponse response, @ApiParam(required=true, value="query criteria") Criteria criteria) {
        try {
            log.tracef("Get host names for criteria [%s]", (Object)criteria);
            long perfStartTime = 0L;
            if (perfLog.isLoggable(Level.FINEST)) {
                perfStartTime = System.currentTimeMillis();
                perfLog.finest("Performance: about to query host names (criteria hash=" + criteria.hashCode() + ")");
            }
            List hostnames = this.analyticsService.getHostNames(this.securityProvider.validate(tenantId, context.getUserPrincipal().getName()), criteria);
            if (perfLog.isLoggable(Level.FINEST)) {
                perfLog.finest("Performance: query host names (criteria hash=" + criteria.hashCode() + ") duration=" + (System.currentTimeMillis() - perfStartTime) + "ms");
            }
            log.tracef("Got host names for criteria [%s] = %s", (Object)criteria, (Object)hostnames);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)hostnames).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debug((Object)e.getMessage(), e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @DELETE
    @Path(value="/")
    @Produces(value={"application/json"})
    public void clear(@Context SecurityContext context, @HeaderParam(value="Hawkular-Tenant") String tenantId, @Suspended AsyncResponse response) {
        try {
            if (System.getProperties().containsKey("hawkular-apm.testmode")) {
                this.analyticsService.clear(this.securityProvider.validate(tenantId, context.getUserPrincipal().getName()));
                response.resume((Object)Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).build());
            } else {
                response.resume((Object)Response.status((Response.Status)Response.Status.FORBIDDEN).type(MediaType.APPLICATION_JSON_TYPE).build());
            }
        }
        catch (Throwable e) {
            log.debug((Object)e.getMessage(), e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }
}

