/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.server.rest;

import java.util.Set;
import java.util.StringTokenizer;
import org.hawkular.apm.api.model.trace.CorrelationIdentifier;
import org.hawkular.apm.api.services.Criteria;
import org.jboss.logging.Logger;

public class RESTServiceUtil {
    private static final Logger log = Logger.getLogger(RESTServiceUtil.class);

    public static void decodeProperties(Set<Criteria.PropertyCriteria> properties, String encoded) {
        if (encoded != null && !encoded.trim().isEmpty()) {
            StringTokenizer st = new StringTokenizer(encoded, ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                String[] parts = token.split("[|]");
                if (parts.length < 2) continue;
                String name = parts[0].trim();
                String value = parts[1].trim();
                Criteria.Operator op = Criteria.Operator.HAS;
                if (parts.length > 2) {
                    op = Criteria.Operator.valueOf((String)parts[2].trim());
                }
                log.tracef("Extracted property name [%s] value [%s] operator [%s]", (Object)name, (Object)value, (Object)op);
                properties.add(new Criteria.PropertyCriteria(name, value, op));
            }
        }
    }

    public static void decodeCorrelationIdentifiers(Set<CorrelationIdentifier> correlations, String encoded) {
        if (encoded != null && !encoded.trim().isEmpty()) {
            StringTokenizer st = new StringTokenizer(encoded, ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                String[] parts = token.split("[|]");
                if (parts.length != 2) continue;
                String scope = parts[0].trim();
                String value = parts[1].trim();
                log.tracef("Extracted correlation identifier scope [%s] value [%s]", (Object)scope, (Object)value);
                CorrelationIdentifier cid = new CorrelationIdentifier();
                cid.setScope(CorrelationIdentifier.Scope.valueOf((String)scope));
                cid.setValue(value);
                correlations.add(cid);
            }
        }
    }

    public static void decodeFaults(Set<Criteria.FaultCriteria> faults, String encoded) {
        if (encoded != null && !encoded.trim().isEmpty()) {
            StringTokenizer st = new StringTokenizer(encoded, ",");
            while (st.hasMoreTokens()) {
                String fault = st.nextToken();
                String[] parts = fault.split("[|]");
                if (parts.length < 1) continue;
                String value = parts[0].trim();
                Criteria.Operator op = Criteria.Operator.HAS;
                if (parts.length > 1) {
                    op = Criteria.Operator.valueOf((String)parts[1].trim());
                }
                log.tracef("Extracted fault value [%s] operator [%s]", (Object)value, (Object)op);
                faults.add(new Criteria.FaultCriteria(value, op));
            }
        }
    }
}

