/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.server.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.hawkular.apm.api.model.trace.Trace;
import org.hawkular.apm.api.services.Criteria;
import org.hawkular.apm.api.services.ServiceResolver;
import org.hawkular.apm.api.services.TracePublisher;
import org.hawkular.apm.api.services.TraceService;
import org.hawkular.apm.server.api.security.SecurityProvider;
import org.hawkular.apm.server.rest.RESTServiceUtil;
import org.jboss.logging.Logger;

@Path(value="traces")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(value="traces", description="Report/Query trace fragments")
public class TraceHandler {
    private static final Logger log = Logger.getLogger(TraceHandler.class);
    @Inject
    SecurityProvider securityProvider;
    @Inject
    TraceService traceService;
    TracePublisher tracePublisher;

    @PostConstruct
    public void init() {
        this.tracePublisher = (TracePublisher)ServiceResolver.getSingletonService(TracePublisher.class);
        if (this.tracePublisher == null) {
            log.error((Object)"Unable to locate Trace Publisher");
        }
    }

    @POST
    @Path(value="fragments")
    @ApiOperation(value="Add a list of trace fragments")
    @ApiResponses(value={@ApiResponse(code=200, message="Adding traces succeeded."), @ApiResponse(code=500, message="Unexpected error happened while storing the trace fragments")})
    public void addTraces(@Context SecurityContext context, @HeaderParam(value="Hawkular-Tenant") String tenantId, @Suspended AsyncResponse response, @ApiParam(value="List of traces", required=true) List<Trace> traces) {
        try {
            this.tracePublisher.publish(this.securityProvider.validate(tenantId, context.getUserPrincipal().getName()), traces);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).build());
        }
        catch (Throwable t) {
            log.debug((Object)t.getMessage(), t);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + t.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="fragments/{id}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve trace fragment for specified id", response=Trace.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success, trace found and returned"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=404, message="Unknown fragment id")})
    public void getFragment(@Context SecurityContext context, @HeaderParam(value="Hawkular-Tenant") String tenantId, @Suspended AsyncResponse response, @ApiParam(required=true, value="id of required trace fragment") @PathParam(value="id") String id) {
        try {
            Trace trace = this.traceService.getFragment(this.securityProvider.validate(tenantId, context.getUserPrincipal().getName()), id);
            if (trace == null) {
                log.tracef("Trace fragment '" + id + "' not found", new Object[0]);
                response.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).type(MediaType.APPLICATION_JSON_TYPE).build());
            } else {
                log.tracef("Trace fragment '" + id + "' found", new Object[0]);
                response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)trace).type(MediaType.APPLICATION_JSON_TYPE).build());
            }
        }
        catch (Throwable e) {
            log.debug((Object)e.getMessage(), e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="complete/{id}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve end to end trace for specified id", response=Trace.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success, trace found and returned"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=404, message="Unknown trace id")})
    public void getTrace(@Context SecurityContext context, @HeaderParam(value="Hawkular-Tenant") String tenantId, @Suspended AsyncResponse response, @ApiParam(required=true, value="id of required trace") @PathParam(value="id") String id) {
        try {
            Trace trace = this.traceService.getTrace(this.securityProvider.validate(tenantId, context.getUserPrincipal().getName()), id);
            if (trace == null) {
                log.tracef("Trace '" + id + "' not found", new Object[0]);
                response.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).type(MediaType.APPLICATION_JSON_TYPE).build());
            } else {
                log.tracef("Trace '" + id + "' found", new Object[0]);
                response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)trace).type(MediaType.APPLICATION_JSON_TYPE).build());
            }
        }
        catch (Throwable e) {
            log.debug((Object)e.getMessage(), e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="fragments/search")
    @Produces(value={"application/json"})
    @ApiOperation(value="Query trace fragments associated with criteria", response=Trace.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void queryFragments(@Context SecurityContext context, @HeaderParam(value="Hawkular-Tenant") String tenantId, @Suspended AsyncResponse response, @ApiParam(required=false, value="trace name") @QueryParam(value="businessTransaction") String businessTransaction, @ApiParam(required=false, value="retrieve traces after this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="startTime") long startTime, @ApiParam(required=false, value="retrieve traces before this time, millisecond since epoch") @DefaultValue(value="0") @QueryParam(value="endTime") long endTime, @ApiParam(required=false, value="retrieve traces with these properties, defined as a comma separated list of name|value pairs") @DefaultValue(value="") @QueryParam(value="properties") String properties, @ApiParam(required=false, value="retrieve traces with these correlation identifiers, defined as a comma separated list of scope|value pairs") @DefaultValue(value="") @QueryParam(value="correlations") String correlations) {
        try {
            Criteria criteria = new Criteria();
            criteria.setBusinessTransaction(businessTransaction);
            criteria.setStartTime(startTime);
            criteria.setEndTime(endTime);
            RESTServiceUtil.decodeProperties(criteria.getProperties(), properties);
            RESTServiceUtil.decodeCorrelationIdentifiers(criteria.getCorrelationIds(), correlations);
            log.tracef("Query trace fragments for criteria [%s]", (Object)criteria);
            List btxns = this.traceService.searchFragments(this.securityProvider.validate(tenantId, context.getUserPrincipal().getName()), criteria);
            log.tracef("Queried trace fragments for criteria [%s] = %s", (Object)criteria, (Object)btxns);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)btxns).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debug((Object)e.getMessage(), e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @POST
    @Path(value="fragments/search")
    @Produces(value={"application/json"})
    @ApiOperation(value="Query trace fragments associated with criteria", response=Trace.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public void queryFragmentsWithCriteria(@Context SecurityContext context, @HeaderParam(value="Hawkular-Tenant") String tenantId, @Suspended AsyncResponse response, @ApiParam(required=true, value="query criteria") Criteria criteria) {
        try {
            log.tracef("Query trace fragments for criteria [%s]", (Object)criteria);
            List btxns = this.traceService.searchFragments(this.securityProvider.validate(tenantId, context.getUserPrincipal().getName()), criteria);
            log.tracef("Queried trace fragments for criteria [%s] = %s", (Object)criteria, (Object)btxns);
            response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)btxns).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        catch (Throwable e) {
            log.debug((Object)e.getMessage(), e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @DELETE
    @Path(value="/")
    @Produces(value={"application/json"})
    public void clear(@Context SecurityContext context, @HeaderParam(value="Hawkular-Tenant") String tenantId, @Suspended AsyncResponse response) {
        try {
            if (System.getProperties().containsKey("hawkular-apm.testmode")) {
                this.traceService.clear(this.securityProvider.validate(tenantId, context.getUserPrincipal().getName()));
                response.resume((Object)Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).build());
            } else {
                response.resume((Object)Response.status((Response.Status)Response.Status.FORBIDDEN).type(MediaType.APPLICATION_JSON_TYPE).build());
            }
        }
        catch (Throwable e) {
            log.debug((Object)e.getMessage(), e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }
}

