/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.tools.instrumenter;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hawkular.apm.api.model.config.CollectorConfiguration;
import org.hawkular.apm.api.model.config.instrumentation.Instrumentation;
import org.hawkular.apm.instrumenter.rules.RuleTransformer;
import org.jboss.byteman.agent.Transformer;
import org.jboss.byteman.check.RuleCheck;
import org.jboss.byteman.modules.ModuleSystem;
import org.jboss.byteman.modules.NonModuleSystem;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Filter;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.resolver.api.maven.ConfigurableMavenResolverSystem;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;

public class InstrumenterUtil {
    private static final Logger log = Logger.getLogger(InstrumenterUtil.class.getName());
    private static final RuleTransformer ruleTransformer = new RuleTransformer();
    private static final ObjectMapper mapper = new ObjectMapper();

    public static void main(String[] args) {
        File configFile;
        File archiveFile;
        if (args.length != 3) {
            System.err.println("Usage: InstrumenterUtil archive config output");
            System.exit(1);
        }
        if (!(archiveFile = new File(args[0])).exists()) {
            System.err.println("Archive file does not exist - must be a jar");
            System.exit(1);
        }
        if (!archiveFile.isAbsolute()) {
            System.err.println("Archive file must have an absolute path");
            System.exit(1);
        }
        if (!(configFile = new File(args[1])).exists()) {
            System.err.println("Config file does not exist");
            System.exit(1);
        }
        JavaArchive archive = (JavaArchive)ShrinkWrap.createFromZipFile(JavaArchive.class, (File)archiveFile);
        try {
            CollectorConfiguration config = (CollectorConfiguration)mapper.readValue(configFile, CollectorConfiguration.class);
            if (InstrumenterUtil.instrument(archive, config)) {
                ((ZipExporter)archive.as(ZipExporter.class)).exportTo(new File(args[2]), true);
                System.out.println("Archive instrumented");
            } else {
                System.out.println("No classes were instrumented");
            }
        }
        catch (Exception e) {
            System.err.println("Failed to instrument: " + e);
        }
    }

    public static boolean instrument(JavaArchive archive, CollectorConfiguration config) {
        boolean modified = false;
        Map content = archive.getContent((Filter)new Filter<ArchivePath>(){

            public boolean include(ArchivePath path) {
                return path.get().endsWith(".class");
            }
        });
        ArrayList<String> scripts = new ArrayList<String>();
        ArrayList scriptNames = new ArrayList();
        Map instrumentTypes = config.getInstrumentation();
        for (Map.Entry stringInstrumentationEntry : instrumentTypes.entrySet()) {
            Instrumentation types = (Instrumentation)stringInstrumentationEntry.getValue();
            String rules = ruleTransformer.transform((String)stringInstrumentationEntry.getKey(), types, config.getProperty("version." + (String)stringInstrumentationEntry.getKey(), null));
            if (rules == null) continue;
            scriptNames.add(stringInstrumentationEntry.getKey());
            scripts.add(rules);
        }
        try {
            NonModuleSystem moduleSystem = new NonModuleSystem();
            Transformer transformer = new Transformer(null, (ModuleSystem)moduleSystem, scriptNames, scripts, false);
            for (Map.Entry archivePathNodeEntry : content.entrySet()) {
                byte[] newcls;
                byte[] cls;
                Node node = (Node)archivePathNodeEntry.getValue();
                InputStream is = node.getAsset().openStream();
                int count = is.read(cls = new byte[is.available()]);
                if (count != cls.length) {
                    log.warning("Incomplete data read");
                }
                is.close();
                String clsName = ((ArchivePath)archivePathNodeEntry.getKey()).get();
                clsName = clsName.replace(File.separatorChar, '.').substring(1, clsName.length() - 6);
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Check whether to instrument class '" + clsName + "' length=" + cls.length);
                }
                if ((newcls = transformer.transform(null, clsName, null, null, cls)) == null) continue;
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Instrumented class '" + clsName + "' length=" + newcls.length);
                }
                archive.delete((ArchivePath)archivePathNodeEntry.getKey());
                Asset asset = new Asset(){

                    public InputStream openStream() {
                        return new ByteArrayInputStream(newcls);
                    }
                };
                archive.add(asset, (ArchivePath)archivePathNodeEntry.getKey());
                modified = true;
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failed to instrument archive", e);
        }
        return modified;
    }

    public static CollectorConfiguration getCollectorConfiguration(String type, String version, boolean offline) throws Exception {
        CollectorConfiguration config = null;
        JavaArchive[] jars = null;
        jars = offline ? (JavaArchive[])((MavenFormatStage)((MavenStrategyStage)((ConfigurableMavenResolverSystem)Maven.configureResolver().workOffline()).resolve("org.hawkular.apm:hawkular-apm-instrumentation-" + type + ":" + version)).withoutTransitivity()).as(JavaArchive.class) : (JavaArchive[])((MavenFormatStage)((MavenStrategyStage)Maven.resolver().resolve("org.hawkular.apm:hawkular-apm-instrumentation-" + type + ":" + version)).withoutTransitivity()).as(JavaArchive.class);
        if (jars != null && jars.length > 0) {
            Map content = jars[0].getContent((Filter)new Filter<ArchivePath>(){

                public boolean include(ArchivePath path) {
                    return path.get().endsWith(".json");
                }
            });
            for (Map.Entry archivePathNodeEntry : content.entrySet()) {
                Node node = (Node)archivePathNodeEntry.getValue();
                InputStream is = node.getAsset().openStream();
                Throwable throwable = null;
                try {
                    CollectorConfiguration subconfig = (CollectorConfiguration)mapper.readValue(is, CollectorConfiguration.class);
                    if (config == null) {
                        config = subconfig;
                        continue;
                    }
                    config.merge(subconfig, true);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        }
        return config;
    }

    public static void initRuntime(CollectorConfiguration config) {
        RuleTransformer ruleTransformer = new RuleTransformer();
        RuleCheck ruleCheck = new RuleCheck();
        Map instrumentTypes = config.getInstrumentation();
        for (Map.Entry stringInstrumentationEntry : instrumentTypes.entrySet()) {
            Instrumentation types = (Instrumentation)stringInstrumentationEntry.getValue();
            String rules = ruleTransformer.transform((String)stringInstrumentationEntry.getKey(), types, config.getProperty("version." + (String)stringInstrumentationEntry.getKey(), null));
            if (rules == null) continue;
            ruleCheck.addRule((String)stringInstrumentationEntry.getKey(), rules);
        }
        ruleCheck.checkRules();
    }
}

