function mergeDeep(dst){"use strict";return angular.forEach(arguments,function(obj){obj!==dst&&angular.forEach(obj,function(value,key){dst[key]&&dst[key].constructor&&dst[key].constructor===Object?mergeDeep(dst[key],value):dst[key]=value})}),dst}angular.module("patternfly.card",[]),angular.module("patternfly.charts",["patternfly.utils","ui.bootstrap","ngSanitize"]),angular.module("patternfly.filters",["patternfly.select","ui.bootstrap"]),angular.module("patternfly.form",[]),angular.module("patternfly.notification",[]),angular.module("patternfly",["patternfly.autofocus","patternfly.card","patternfly.filters","patternfly.form","patternfly.notification","patternfly.select","patternfly.sort","patternfly.toolbars","patternfly.utils","patternfly.validation","patternfly.views"]),angular.module("patternfly.sort",["ui.bootstrap"]),angular.module("patternfly.toolbars",["patternfly.utils","patternfly.filters","patternfly.sort","patternfly.views"]),angular.module("patternfly.utils",[]),angular.module("patternfly.views",["patternfly.utils","patternfly.filters","patternfly.sort"]),angular.module("patternfly.autofocus",[]).directive("pfFocused",["$timeout",function($timeout){"use strict";return{restrict:"A",link:function(scope,element,attrs){scope.$watch(attrs.pfFocused,function(newValue){$timeout(function(){newValue&&(element[0].focus(),element[0].select&&element[0].select())})})}}}]),angular.module("patternfly.card").directive("pfAggregateStatusCard",function(){"use strict";return{restrict:"A",scope:{status:"=",showTopBorder:"@?",altLayout:"@?",layout:"@?"},templateUrl:"card/aggregate-status/aggregate-status-card.html",link:function(scope){scope.shouldShowTopBorder="true"===scope.showTopBorder,scope.isAltLayout="true"===scope.altLayout||"tall"===scope.layout,scope.isMiniLayout="mini"===scope.layout}}}),angular.module("patternfly.card").directive("pfCard",function(){"use strict";return{restrict:"A",transclude:!0,templateUrl:"card/basic/card.html",scope:{headTitle:"@",subTitle:"@?",showTopBorder:"@?",showTitlesSeparator:"@?",footer:"=?",filter:"=?"},controller:["$scope",function($scope){$scope.filter&&!$scope.currentFilter&&($scope.filter.defaultFilter?$scope.currentFilter=$scope.filter.filters[$scope.filter.defaultFilter]:$scope.currentFilter=$scope.filter.filters[0]),$scope.footerCallBackFn=function(){$scope.footerCallBackResult=$scope.footer.callBackFn()},$scope.filterCallBackFn=function(f){$scope.currentFilter=f,$scope.filter.callBackFn&&($scope.filterCallBackResult=$scope.filter.callBackFn(f))},$scope.showHeader=function(){return $scope.headTitle||$scope.showFilterInHeader()},$scope.showFilterInHeader=function(){return $scope.filter&&$scope.filter.filters&&$scope.filter.position&&"header"===$scope.filter.position},$scope.showFilterInFooter=function(){return $scope.filter&&$scope.filter.filters&&(!$scope.filter.position||"footer"===$scope.filter.position)}}],link:function(scope){scope.shouldShowTitlesSeparator=!scope.showTitlesSeparator||"true"===scope.showTitlesSeparator}}}),function(){"use strict";var patternflyDefaults=$().c3ChartDefaults();angular.module("patternfly.charts").constant("c3ChartDefaults",{getDefaultColors:patternflyDefaults.getDefaultColors,getDefaultDonut:patternflyDefaults.getDefaultDonut,getDefaultDonutSize:patternflyDefaults.getDefaultDonutSize,getDefaultDonutColor:patternflyDefaults.getDefaultDonutColors,getDefaultDonutLegend:patternflyDefaults.getDefaultDonutLegend,getDefaultDonutConfig:patternflyDefaults.getDefaultDonutConfig,getDefaultSparklineArea:patternflyDefaults.getDefaultSparklineArea,getDefaultSparklineSize:patternflyDefaults.getDefaultSparklineSize,getDefaultSparklineAxis:patternflyDefaults.getDefaultSparklineAxis,getDefaultSparklineColor:patternflyDefaults.getDefaultColors,getDefaultSparklineLegend:patternflyDefaults.getDefaultSparklineLegend,getDefaultSparklinePoint:patternflyDefaults.getDefaultSparklinePoint,getDefaultSparklineTooltip:patternflyDefaults.getDefaultSparklineTooltip,getDefaultSparklineConfig:patternflyDefaults.getDefaultSparklineConfig})}(),function(){"use strict";angular.module("patternfly.charts").directive("pfC3Chart",["$timeout",function($timeout){return{restrict:"A",scope:{config:"=",getChartCallback:"="},template:'<div id=""></div>',replace:!0,link:function(scope,element,attrs){scope.$watch("config",function(){$timeout(function(){var chart,chartData=scope.config;chartData.bindto="#"+attrs.id,chart=c3.generate(chartData),scope.getChartCallback&&scope.getChartCallback(chart)})},!0)}}}])}(),angular.module("patternfly.charts").directive("pfDonutPctChart",["pfUtils","$timeout",function(pfUtils,$timeout){"use strict";return{restrict:"A",scope:{config:"=",data:"=",centerLabel:"=?"},replace:!0,templateUrl:"charts/donut/donut-pct-chart.html",controller:["$scope",function($scope){var donutTooltip;$scope.donutChartId="donutChart",$scope.config.chartId&&($scope.donutChartId=$scope.config.chartId+$scope.donutChartId),$scope.updateAvailable=function(){$scope.data.available=$scope.data.total-$scope.data.used},void 0===$scope.data.available&&$scope.updateAvailable(),$scope.getStatusColor=function(used,thresholds){var color="#0088CE";return thresholds&&(color="#3f9c35",used>=thresholds.error?color="#CC0000":used>=thresholds.warning&&(color="#EC7A08")),color},$scope.statusDonutColor=function(scope){var color,percentUsed;return color={pattern:[]},percentUsed=scope.data.used/scope.data.total*100,color.pattern[0]=$scope.getStatusColor(percentUsed,scope.config.thresholds),color.pattern[1]="#D1D1D1",color},donutTooltip=function(scope){return{contents:function(d){var tooltipHtml;return tooltipHtml=scope.config.tooltipFn?'<span class="donut-tooltip-pf" style="white-space: nowrap;">'+scope.config.tooltipFn(d)+"</span>":'<span class="donut-tooltip-pf" style="white-space: nowrap;">'+Math.round(100*d[0].ratio)+"% "+$scope.config.units+" "+d[0].name+"</span>"}}},$scope.getDonutData=function(scope){return{columns:[["Used",scope.data.used],["Available",scope.data.available]],type:"donut",donut:{label:{show:!1}},groups:[["used","available"]],order:null}},$scope.getCenterLabelText=function(){var centerLabelText;return centerLabelText={bigText:$scope.data.used,smText:$scope.config.units+" Used"},$scope.config.centerLabelFn?(centerLabelText.bigText=$scope.config.centerLabelFn(),centerLabelText.smText=""):"none"===$scope.centerLabel?(centerLabelText.bigText="",centerLabelText.smText=""):"available"===$scope.centerLabel?(centerLabelText.bigText=$scope.data.available,centerLabelText.smText=$scope.config.units+" Available"):"percent"===$scope.centerLabel&&(centerLabelText.bigText=Math.round($scope.data.used/$scope.data.total*100)+"%",centerLabelText.smText="of "+$scope.data.total+" "+$scope.config.units),centerLabelText},$scope.updateAll=function(scope){$scope.updateAvailable(),$scope.config.data=pfUtils.merge($scope.getDonutData($scope),$scope.config.data),$scope.config.color=$scope.statusDonutColor($scope),$scope.config.tooltip=donutTooltip(scope),$scope.config.data.onclick=$scope.config.onClickFn},$scope.config=pfUtils.merge($().c3ChartDefaults().getDefaultDonutConfig(),$scope.config),$scope.updateAll($scope)}],link:function(scope,element){var setupDonutChartTitle=function(){$timeout(function(){var donutChartTitle,centerLabelText;donutChartTitle=d3.select(element[0]).select("text.c3-chart-arcs-title"),donutChartTitle&&(centerLabelText=scope.getCenterLabelText(),donutChartTitle.selectAll("*").remove(),centerLabelText.bigText&&!centerLabelText.smText?donutChartTitle.text(centerLabelText.bigText):(donutChartTitle.insert("tspan").text(centerLabelText.bigText).classed("donut-title-big-pf",!0).attr("dy",0).attr("x",0),donutChartTitle.insert("tspan").text(centerLabelText.smText).classed("donut-title-small-pf",!0).attr("dy",20).attr("x",0)))},300)};scope.$watch("config",function(){scope.updateAll(scope),setupDonutChartTitle()},!0),scope.$watch("data",function(){scope.updateAll(scope),setupDonutChartTitle()},!0),scope.$watch("centerLabel",function(){setupDonutChartTitle()})}}}]),angular.module("patternfly.charts").directive("pfEmptyChart",function(){"use strict";return{restrict:"A",scope:{chartHeight:"=?"},replace:!0,templateUrl:"charts/empty-chart.html",controller:["$scope",function($scope){$scope.setSizeStyles=function(){var height=$scope.chartHeight||40,topPadding=Math.min(Math.round((height-40)/2),20);$scope.sizeStyles={height:height+"px","padding-top":topPadding+"px"}},$scope.setSizeStyles()}],link:function(scope){scope.$watch("chartHeight",function(){scope.setSizeStyles()})}}}),angular.module("patternfly.charts").directive("pfHeatmapLegend",function(){"use strict";return{restrict:"A",scope:{legend:"=?",legendColors:"=?"},templateUrl:"charts/heatmap/heatmap-legend.html",controller:["$scope",function($scope){var heatmapColorPatternDefaults=["#d4f0fa","#F9D67A","#EC7A08","#CE0000"],legendLabelDefaults=["< 70%","70-80%","80-90%","> 90%"];$scope.legendColors||($scope.legendColors=heatmapColorPatternDefaults),$scope.legend||($scope.legend=legendLabelDefaults)}],link:function($scope){var index,items=[];for(index=$scope.legend.length-1;index>=0;index--)items.push({text:$scope.legend[index],color:$scope.legendColors[index]});$scope.legendItems=items}}}),angular.module("patternfly.charts").directive("pfHeatmap",["$compile",function($compile){"use strict";return{restrict:"A",scope:{data:"=",chartDataAvailable:"=?",height:"=?",chartTitle:"=?",showLegend:"=?",legendLabels:"=?",maxBlockSize:"@",blockPadding:"@",thresholds:"=?",heatmapColorPattern:"=?",clickAction:"=?"},templateUrl:"charts/heatmap/heatmap.html",controller:["$scope",function($scope){var thresholdDefaults=[.7,.8,.9],heatmapColorPatternDefaults=["#d4f0fa","#F9D67A","#EC7A08","#CE0000"],legendLabelDefaults=["< 70%","70-80%","80-90%","> 90%"],heightDefault=200;void 0===$scope.maxBlockSize||isNaN($scope.maxBlockSize)?$scope.maxSize=64:($scope.maxSize=parseInt($scope.maxBlockSize),$scope.maxSize<5?$scope.maxSize=5:$scope.maxSize>50&&($scope.maxSize=50)),void 0===$scope.blockPadding||isNaN($scope.blockPadding)?$scope.padding=2:$scope.padding=parseInt($scope.blockPadding),$scope.thresholds||($scope.thresholds=thresholdDefaults),$scope.heatmapColorPattern||($scope.heatmapColorPattern=heatmapColorPatternDefaults),$scope.legendLabels||($scope.legendLabels=legendLabelDefaults),$scope.height=$scope.height||heightDefault,$scope.showLegend=$scope.showLegend||void 0===$scope.showLegend,$scope.loadingDone=!1}],link:function(scope,element,attrs){var containerWidth,containerHeight,blockSize,numberOfRows,thisComponent=element[0].querySelector(".heatmap-pf-svg"),setStyles=function(){scope.containerStyles={height:scope.height+"px",display:scope.chartDataAvailable===!1?"none":"block"}},setSizes=function(){var parentContainer=element[0].querySelector(".heatmap-container");containerWidth=parentContainer.clientWidth,containerHeight=parentContainer.clientHeight,blockSize=determineBlockSize(),blockSize-scope.padding>scope.maxSize?(blockSize=scope.padding+scope.maxSize,numberOfRows=Math.ceil(Math.sqrt(scope.data.length)),(blockSize*numberOfRows>containerWidth||blockSize*numberOfRows>containerHeight)&&(numberOfRows=0===blockSize?0:Math.floor(containerHeight/blockSize))):numberOfRows=0===blockSize?0:Math.floor(containerHeight/blockSize)},determineBlockSize=function(){var sx,sy,x=containerWidth,y=containerHeight,n=scope.data?scope.data.length:0,px=Math.ceil(Math.sqrt(n*x/y)),py=Math.ceil(Math.sqrt(n*y/x));return sx=Math.floor(px*y/x)*px<n?y/Math.ceil(px*y/x):x/px,sy=Math.floor(py*x/y)*py<n?x/Math.ceil(x*py/y):y/py,Math.max(sx,sy)},redraw=function(){var blocks,data=scope.data,color=d3.scale.threshold().domain(scope.thresholds).range(scope.heatmapColorPattern),fillSize=blockSize-scope.padding,highlightBlock=function(block,active){block.style("fill-opacity",active?1:.4)},svg=window.d3.select(thisComponent);svg.selectAll("*").remove(),blocks=svg.selectAll("rect").data(data).enter().append("rect"),blocks.attr("x",function(d,i){return Math.floor(i/numberOfRows)*blockSize}).attr("y",function(d,i){return i%numberOfRows*blockSize}).attr("width",fillSize).attr("height",fillSize).style("fill",function(d){return color(d.value)}).attr("tooltip-html-unsafe",function(d,i){return d.tooltip}).attr("tooltip-append-to-body",function(d,i){return!0}).attr("tooltip-animation",function(d,i){return!1}),blocks.on("mouseover",function(){blocks.call(highlightBlock,!1),d3.select(this).call(highlightBlock,!0)}),blocks.on("click",function(d){scope.clickAction&&scope.clickAction(d)}),angular.forEach(angular.element(blocks),function(block){var el=angular.element(block);$compile(el)(scope)}),svg.on("mouseleave",function(){blocks.call(highlightBlock,!0)})};scope.$watch("data",function(newVal,oldVal){"undefined"!=typeof newVal&&(scope.loadingDone=!0,setStyles(),scope.chartDataAvailable!==!1&&(setSizes(),redraw()))}),scope.$watch("chartDataAvailable",function(){scope.chartDataAvailable===!1&&(scope.loadingDone=!0),setStyles()})}}}]),angular.module("patternfly.charts").directive("pfSparklineChart",["pfUtils",function(pfUtils){"use strict";return{restrict:"A",scope:{config:"=",chartData:"=",chartHeight:"=?",showXAxis:"=?",showYAxis:"=?"},replace:!0,templateUrl:"charts/sparkline/sparkline-chart.html",controller:["$scope",function($scope){$scope.sparklineChartId="sparklineChart",$scope.config.chartId&&($scope.sparklineChartId=$scope.config.chartId+$scope.sparklineChartId),$scope.getSparklineData=function(chartData){var sparklineData={type:"area"};return chartData&&chartData.dataAvailable!==!1&&chartData.xData&&chartData.yData&&(sparklineData.x=chartData.xData[0],sparklineData.columns=[chartData.xData,chartData.yData]),sparklineData},$scope.getTooltipTableHTML=function(tipRows){return'<div class="module-triangle-bottom">  <table class="c3-tooltip">    <tbody>'+tipRows+"    </tbody>  </table></div>"},$scope.sparklineTooltip=function(){return{contents:function(d){var tipRows,percentUsed=0;if($scope.config.tooltipFn)tipRows=$scope.config.tooltipFn(d);else switch($scope.config.tooltipType){case"usagePerDay":$scope.chartData.dataAvailable!==!1&&$scope.chartData.total>0&&(percentUsed=Math.round(d[0].value/$scope.chartData.total*100)),tipRows='<tr>  <th colspan="2">'+d[0].x.toLocaleDateString()+'</th></tr><tr>  <td class="name">'+percentUsed+'%:</td>  <td class="value text-nowrap">'+d[0].value+" "+($scope.config.units?$scope.config.units+" ":"")+d[0].name+"</td></tr>";break;case"valuePerDay":tipRows='<tr>  <td class="value">'+d[0].x.toLocaleDateString()+'</td>  <td class="value text-nowrap">'+d[0].value+" "+d[0].name+"</td></tr>";break;case"percentage":percentUsed=Math.round(d[0].value/$scope.chartData.total*100),tipRows='<tr>  <td class="name">'+percentUsed+"%</td></tr>";break;default:tipRows=$().c3ChartDefaults().getDefaultSparklineTooltip().contents(d)}return $scope.getTooltipTableHTML(tipRows)},position:function(data,width,height,element){var center,top,chartBox,graphOffsetX,x;try{return center=parseInt(element.getAttribute("x")),top=parseInt(element.getAttribute("y")),chartBox=document.querySelector("#"+$scope.sparklineChartId).getBoundingClientRect(),graphOffsetX=document.querySelector("#"+$scope.sparklineChartId+" g.c3-axis-y").getBoundingClientRect().right,x=Math.max(0,center+graphOffsetX-chartBox.left-Math.floor(width/2)),{top:top-height,left:Math.min(x,chartBox.width-width)}}catch(e){}}}},void 0===$scope.showXAxis&&($scope.showXAxis=void 0!==$scope.config.showAxis&&$scope.config.showAxis),void 0===$scope.showYAxis&&($scope.showYAxis=void 0!==$scope.config.showAxis&&$scope.config.showAxis),$scope.defaultConfig=$().c3ChartDefaults().getDefaultSparklineConfig(),$scope.defaultConfig.axis={x:{show:$scope.showXAxis===!0,type:"timeseries",tick:{format:function(){return""}}},y:{show:$scope.showYAxis===!0,tick:{format:function(){return""}}}},$scope.defaultConfig.tooltip=$scope.sparklineTooltip(),$scope.chartHeight&&($scope.defaultConfig.size.height=$scope.chartHeight),$scope.defaultConfig.units="",$scope.config.data=pfUtils.merge($scope.config.data,$scope.getSparklineData($scope.chartData)),$scope.chartConfig=pfUtils.merge($scope.config,$scope.defaultConfig)}],link:function(scope){scope.$watch("config",function(){scope.config.data=pfUtils.merge(scope.config.data,scope.getSparklineData(scope.chartData)),scope.chartConfig=pfUtils.merge(scope.config,scope.defaultConfig)},!0),scope.$watch("chartHeight",function(){scope.chartHeight&&(scope.chartConfig.size.height=scope.chartHeight)}),scope.$watch("showXAxis",function(){scope.chartConfig.axis.x.show=scope.showXAxis===!0}),scope.$watch("showYAxis",function(){scope.chartConfig.axis.y.show=scope.showYAxis===!0}),scope.$watch("chartData",function(){scope.chartConfig.data=pfUtils.merge(scope.chartConfig.data,scope.getSparklineData(scope.chartData))},!0)}}}]),angular.module("patternfly.charts").directive("pfTrendsChart",function(){"use strict";return{restrict:"A",scope:{config:"=",chartData:"=",chartHeight:"=?",showXAxis:"=?",showYAxis:"=?"},replace:!0,templateUrl:"charts/trends/trends-chart.html",controller:["$scope",function($scope){var SMALL=30,LARGE=60;$scope.getPercentageValue=function(){var pctValue=0;return $scope.chartData.dataAvailable!==!1&&$scope.chartData.total>0&&(pctValue=Math.round($scope.getLatestValue()/$scope.chartData.total*100)),pctValue},$scope.getLatestValue=function(){var latestValue=0;return $scope.chartData.yData&&$scope.chartData.yData.length>0&&(latestValue=$scope.chartData.yData[$scope.chartData.yData.length-1]),latestValue},$scope.getChartHeight=function(){var retValue=LARGE;return $scope.chartHeight?retValue=$scope.chartHeight:"small"===$scope.config.layout&&(retValue=SMALL),retValue}}],link:function(scope){scope.$watch("config",function(){scope.showLargeCardLayout=!scope.config.layout||"large"===scope.config.layout,scope.showSmallCardLayout="small"===scope.config.layout,scope.showActualValue=!scope.config.valueType||"actual"===scope.config.valueType,scope.showPercentageValue="percentage"===scope.config.valueType},!0)}}}),angular.module("patternfly.charts").directive("pfUtilizationBarChart",["$timeout",function($timeout){"use strict";return{restrict:"A",scope:{chartData:"=",chartTitle:"=",chartFooter:"=",units:"=",thresholdError:"=?",thresholdWarning:"=?",footerLabelFormat:"@?",layout:"=?"},templateUrl:"charts/utilization-bar/utilization-bar-chart.html",link:function(scope){scope.$watch("chartData",function(newVal,oldVal){"undefined"!=typeof newVal&&(scope.chartData.percentageUsed=Math.round(100*(scope.chartData.used/scope.chartData.total)),(scope.thresholdError||scope.thresholdWarning)&&(scope.isError=scope.chartData.percentageUsed>scope.thresholdError,scope.isWarn=scope.chartData.percentageUsed>scope.thresholdWarning&&scope.chartData.percentageUsed<scope.thresholdError,scope.isOk=scope.chartData.percentageUsed<scope.thresholdWarning),scope.animate=!0,$timeout(function(){scope.animate=!1},0))})}}}]),angular.module("patternfly.charts").directive("pfUtilizationTrendChart",function(){"use strict";return{restrict:"A",scope:{chartData:"=",config:"=",centerLabel:"=?",donutConfig:"=",sparklineConfig:"=",sparklineChartHeight:"=?",showSparklineXAxis:"=?",showSparklineYAxis:"=?"},replace:!0,templateUrl:"charts/utilization-trend/utilization-trend-chart.html",controller:["$scope",function($scope){void 0===$scope.centerLabel&&($scope.centerLabel="used"),void 0===$scope.donutConfig.units&&($scope.donutConfig.units=$scope.config.units),void 0===$scope.chartData.available&&($scope.chartData.available=$scope.chartData.total-$scope.chartData.used),$scope.config.units=$scope.config.units||$scope.units}],link:function(scope,element){var setupCurrentValues=function(){"available"===scope.centerLabel?(scope.currentValue=scope.chartData.used,scope.currentText="Used"):(scope.currentValue=scope.chartData.total-scope.chartData.used,scope.currentText="Available")};scope.$watchGroup(["centerLabel","chartData.used","chartData.available","chartData.total"],function(){setupCurrentValues()})}}}),angular.module("patternfly.filters").directive("pfFilter",function(){"use strict";return{restrict:"A",scope:{config:"="},templateUrl:"filters/filter.html",controller:["$scope",function($scope){$scope.filterExists=function(filter){var foundFilter=_.findWhere($scope.config.appliedFilters,{title:filter.title,value:filter.value});return void 0!==foundFilter},$scope.enforceSingleSelect=function(filter){_.remove($scope.config.appliedFilters,{title:filter.title})},$scope.addFilter=function(field,value){var newFilter={id:field.id,title:field.title,type:field.filterType,value:value};$scope.filterExists(newFilter)||("select"===newFilter.type&&$scope.enforceSingleSelect(newFilter),$scope.config.appliedFilters.push(newFilter),$scope.config.onFilterChange&&$scope.config.onFilterChange($scope.config.appliedFilters))}}]}}),angular.module("patternfly.filters").directive("pfFilterFields",function(){"use strict";return{restrict:"A",scope:{config:"=",addFilterFn:"="},templateUrl:"filters/filter-fields.html",controller:["$scope",function($scope){$scope.setupConfig=function(){void 0===$scope.fields&&($scope.fields=[]),$scope.currentField||($scope.currentField=$scope.config.fields[0],$scope.config.currentValue=null),void 0===$scope.config.currentValue&&($scope.config.currentValue=null)},$scope.$watch("config",function(){$scope.setupConfig()},!0)}],link:function(scope,element,attrs){scope.selectField=function(item){scope.currentField=item,scope.config.currentValue=null},scope.selectValue=function(filterValue){scope.addFilterFn(scope.currentField,filterValue),scope.config.currentValue=null},scope.onValueKeyPress=function(keyEvent){13===keyEvent.which&&(scope.addFilterFn(scope.currentField,scope.config.currentValue),scope.config.currentValue=void 0)}}}}),angular.module("patternfly.filters").directive("pfFilterResults",function(){"use strict";return{restrict:"A",scope:{config:"="},templateUrl:"filters/filter-results.html",controller:["$scope",function($scope){$scope.setupConfig=function(){$scope.config.appliedFilters||($scope.config.appliedFilters=[]),void 0===$scope.config.resultsCount&&($scope.config.resultsCount=0)},$scope.$watch("config",function(){$scope.setupConfig()},!0)}],link:function(scope,element,attrs){scope.clearFilter=function(item){var newFilters=[];scope.config.appliedFilters.forEach(function(filter){(item.title!==filter.title||item.value!==filter.value)&&newFilters.push(filter)}),scope.config.appliedFilters=newFilters,scope.config.onFilterChange&&scope.config.onFilterChange(scope.config.appliedFilters)},scope.clearAllFilters=function(){scope.config.appliedFilters=[],scope.config.onFilterChange&&scope.config.onFilterChange(scope.config.appliedFilters)}}}}),angular.module("patternfly.form").directive("pfDatepicker",function(){"use strict";return{replace:!0,restrict:"A",require:"^form",templateUrl:"form/datepicker/datepicker.html",scope:{options:"=",date:"="},link:function($scope,element){element.datepicker($scope.options),element.datepicker("update",$scope.date),element.datepicker($scope.date).on("changeDate",function(elem){$scope.$apply(function(){$scope.date=elem.date})}),$scope.$watch("date",function(newValue,oldValue){oldValue!==newValue&&element.datepicker("update",newValue)})}}}),angular.module("patternfly.form").directive("pfFormButtons",function(){"use strict";return{replace:!0,require:"^form",templateUrl:"form/form-buttons/form-buttons.html",scope:{pfHandleCancel:"&pfOnCancel",pfHandleSave:"&pfOnSave",pfWorking:"=",pfButtonContainerClass:"@"},link:function(scope,iElement,iAttrs,controller){void 0===scope.pfWorking&&(scope.pfWorking=!1),scope.isInvalid=function(){var invalid=controller.$invalid;return angular.forEach(controller,function(value){value&&value.$error&&value.$error.server&&(invalid=!1)}),invalid}}}}),angular.module("patternfly.form").directive("pfFormGroup",function(){"use strict";function getInput(element){var input=element.find("table");return 0===input.length&&(input=element.find("input"),0===input.length&&(input=element.find("select"),0===input.length&&(input=element.find("textarea")))),input}return{transclude:!0,replace:!0,require:"^form",templateUrl:"form/form-group/form-group.html",scope:{pfLabel:"@",pfField:"@",pfLabelClass:"@",pfInputClass:"@"},link:function(scope,iElement,iAttrs,controller){var field,input=getInput(iElement),type=input.attr("type");iAttrs.pfLabelClass||(iAttrs.pfLabelClass="col-sm-2"),iAttrs.pfInputClass||(iAttrs.pfInputClass="col-sm-5"),scope.pfField||(scope.pfField=input.attr("id")),field=scope.pfField,-1===["checkbox","radio","time"].indexOf(type)&&input.addClass("form-control"),input.attr("required")&&iElement.addClass("required"),controller[field]&&(scope.error=controller[field].$error),scope.hasErrors=function(){return controller[field]&&controller[field].$invalid&&controller[field].$dirty}}}}),angular.module("patternfly.form").directive("pfRemainingCharsCount",["$timeout",function($timeout){"use strict";return{restrict:"A",require:"ngModel",scope:{ngModel:"="},link:function($scope,$element,$attributes){var charsMaxLimit=$attributes.charsMaxLimit,charsWarnRemaining=$attributes.charsWarnRemaining,countRemainingFld=angular.element(document.getElementById($attributes.countFld)),blockInputAtMaxLimit="true"===$attributes.blockInputAtMaxLimit,checkCharactersRemaining=function(){var charsLength=$scope.ngModel.length,remainingChars=charsMaxLimit-charsLength;blockInputAtMaxLimit&&charsLength>charsMaxLimit&&($scope.ngModel=$scope.ngModel.substring(0,charsMaxLimit),charsLength=$scope.ngModel.length,remainingChars=charsMaxLimit-charsLength),$scope.remainingChars=remainingChars,$scope.remainingCharsWarning=charsWarnRemaining>=remainingChars?!0:!1,countRemainingFld.text(remainingChars),countRemainingFld.toggleClass("chars-warn-remaining-pf",charsWarnRemaining>=remainingChars),0>remainingChars?$scope.$emit("overCharsMaxLimit",$attributes.id):$scope.$emit("underCharsMaxLimit",$attributes.id)};$scope.$watch("ngModel",function(){checkCharactersRemaining()}),$element.bind("keypress",function(event){blockInputAtMaxLimit&&$element.val().length>=charsMaxLimit&&8!==event.keyCode&&event.preventDefault()})}}}]),angular.module("patternfly.notification").directive("pfInlineNotification",function(){"use strict";return{scope:{pfNotificationType:"=",pfNotificationMessage:"=",pfNotificationHeader:"=",pfNotificationPersistent:"=",pfNotificationIndex:"="},restrict:"E",templateUrl:"notification/inline-notification.html"}}),angular.module("patternfly.notification").provider("Notifications",function(){"use strict";this.delay=5e3,this.verbose=!0,this.notifications={},this.persist={error:!0,httpError:!0},this.setDelay=function(delay){return this.delay=delay,this},this.setVerbose=function(verbose){return this.verbose=verbose,this},this.setPersist=function(persist){this.persist=persist},this.$get=["$rootScope","$timeout","$log",function($rootScope,$timeout,$log){function createNotifyMethod(mode){return function(message){notifications.message(modes[mode].type,modes[mode].header,message,persist[mode]),verbose&&$log[modes[mode].log](message)}}var delay=this.delay,notifications=this.notifications,verbose=this.verbose,persist=this.persist,scheduleMessagePop=function(){$timeout(function(){var i;for(i=0;i<$rootScope.notifications.data.length;i++)$rootScope.notifications.data[i].isPersistent||$rootScope.notifications.data.splice(i,1)},delay)},modes={info:{type:"info",header:"Info!",log:"info"},success:{type:"success",header:"Success!",log:"info"},error:{type:"danger",header:"Error!",log:"error"},warn:{type:"warning",header:"Warning!",log:"warn"}};return $rootScope.notifications={},$rootScope.notifications.data=[],$rootScope.notifications.remove=function(index){$rootScope.notifications.data.splice(index,1)},$rootScope.notifications||($rootScope.notifications.data=[]),notifications.message=function(type,header,message,isPersistent){$rootScope.notifications.data.push({type:type,header:header,message:message,isPersistent:isPersistent}),scheduleMessagePop()},angular.forEach(modes,function(mode,index){notifications[index]=createNotifyMethod(index)}),notifications.httpError=function(message,httpResponse){message+=" ("+(httpResponse.data.message||httpResponse.data.cause||httpResponse.data.cause||httpResponse.data.errorMessage)+")",notifications.message("danger","Error!",message,persist.httpError),verbose&&$log.error(message)},notifications}]}),angular.module("patternfly.notification").directive("pfNotificationList",function(){"use strict";function NotificationListController($scope,$rootScope){$scope.notifications=$rootScope.notifications}return NotificationListController.$inject=["$scope","$rootScope"],{restrict:"E",controller:NotificationListController,templateUrl:"notification/notification-list.html"}}),angular.module("patternfly.select",[]).directive("pfSelect",["$timeout",function($timeout){"use strict";return{restrict:"A",require:"?ngModel",scope:{selectPickerOptions:"=pfSelect"},link:function(scope,element,attrs,ngModel){var optionCollectionList,optionCollection,$render=ngModel.$render,selectpickerRefresh=function(argument){scope.$applyAsync(function(){element.selectpicker("refresh")})};element.selectpicker(scope.selectPickerOptions),ngModel.$render=function(){$render.apply(this,arguments),selectpickerRefresh()},attrs.ngOptions&&(optionCollectionList=attrs.ngOptions.split("in "),optionCollection=optionCollectionList[optionCollectionList.length-1],scope.$parent.$watchCollection(optionCollection,selectpickerRefresh)),attrs.ngModel&&scope.$parent.$watch(attrs.ngModel,selectpickerRefresh),attrs.$observe("disabled",selectpickerRefresh)}}}]),angular.module("patternfly.sort").directive("pfSort",function(){"use strict";return{restrict:"A",scope:{config:"="},templateUrl:"sort/sort.html",controller:["$scope",function($scope){$scope.setupConfig=function(){var updated=!1;void 0===$scope.config.fields&&($scope.config.fields=[]),$scope.config.fields.length>0&&(void 0===$scope.config.currentField&&($scope.config.currentField=$scope.config.fields[0],updated=!0),void 0===$scope.config.isAscending&&($scope.config.isAscending=!0,updated=!0)),updated===!0&&$scope.config.onSortChange&&$scope.config.onSortChange($scope.config.currentField,$scope.config.isAscending)},$scope.selectField=function(field){$scope.config.currentField=field,$scope.config.onSortChange&&$scope.config.onSortChange($scope.config.currentField,$scope.config.isAscending)},$scope.changeDirection=function(){$scope.config.isAscending=!$scope.config.isAscending,$scope.config.onSortChange&&$scope.config.onSortChange($scope.config.currentField,$scope.config.isAscending)},$scope.getSortIconClass=function(){var iconClass;return iconClass="numeric"===$scope.config.currentField.sortType?$scope.config.isAscending?"fa fa-sort-numeric-asc":"fa fa-sort-numeric-desc":$scope.config.isAscending?"fa fa-sort-alpha-asc":"fa fa-sort-alpha-desc"},$scope.setupConfig()}],link:function(scope,element,attrs){scope.$watch("config",function(){scope.setupConfig()},!0)}}}),angular.module("patternfly.toolbars").directive("pfToolbar",function(){"use strict";return{restrict:"A",scope:{config:"="},replace:!0,transclude:!1,templateUrl:"toolbars/toolbar.html",controller:["$scope",function($scope){$scope.viewSelected=function(viewId){$scope.config.viewsConfig.currentView=viewId,$scope.config.viewsConfig.onViewSelect&&!$scope.checkViewDisabled(viewId)&&$scope.config.viewsConfig.onViewSelect(viewId)},$scope.isViewSelected=function(viewId){return $scope.config.viewsConfig&&$scope.config.viewsConfig.currentView===viewId},$scope.checkViewDisabled=function(view){return $scope.config.viewsConfig.checkViewDisabled&&$scope.config.viewsConfig.checkViewDisabled(view)},$scope.filterExists=function(filter){var foundFilter=_.findWhere($scope.config.filterConfig.appliedFilters,{title:filter.title,value:filter.value});return void 0!==foundFilter},$scope.addFilter=function(field,value){var newFilter={id:field.id,title:field.title,value:value};$scope.filterExists(newFilter)||($scope.config.filterConfig.appliedFilters.push(newFilter),
$scope.config.filterConfig.onFilterChange&&$scope.config.filterConfig.onFilterChange($scope.config.filterConfig.appliedFilters))},$scope.handleAction=function(action){action&&action.actionFn&&action.isDisabled!==!0&&action.actionFn(action)}}],link:function(scope,element,attrs){scope.$watch("config",function(){scope.config&&scope.config.viewsConfig&&scope.config.viewsConfig.views&&(scope.config.viewsConfig.viewsList=angular.copy(scope.config.viewsConfig.views),scope.config.viewsConfig.currentView||(scope.config.viewsConfig.currentView=scope.config.viewsConfig.viewsList[0]))},!0)}}}),angular.module("patternfly.utils").directive("pfTransclude",function(){"use strict";return{restrict:"A",link:function($scope,$element,$attrs,controller,$transclude){var iChildScope,iScopeType;if(!$transclude)throw new Error("pfTransclude - Illegal use of pfTransclude directive in the template! No parent directive that requires a transclusion found. Element: {0}");switch(iScopeType=$attrs.pfTransclude||"sibling"){case"sibling":$transclude(function(clone){$element.empty(),$element.append(clone)});break;case"parent":$transclude($scope,function(clone){$element.empty(),$element.append(clone)});break;case"child":iChildScope=$scope.$new(),$transclude(iChildScope,function(clone){$element.empty(),$element.append(clone),$element.on("$destroy",function(){iChildScope.$destroy()})})}}}}),function(){"use strict";angular.module("patternfly.utils").constant("pfUtils",{merge:function(source1,source2){var retValue;return retValue="function"==typeof angular.merge?this.angularMerge(source1,source2):"function"==typeof _.merge?this._merge(source1,source2):"function"==typeof $.extend?this.$extend(source1,source2):this.mergeDeep(source1,source2)},angularMerge:function(source1,source2){return angular.merge({},source1,source2)},_merge:function(source1,source2){return _.merge({},source1,source2)},$extend:function(source1,source2){return $.extend(!0,angular.copy(source1),source2)},mergeDeep:function(source1,source2){return mergeDeep({},angular.copy(source1),angular.copy(source2))}})}(),angular.module("patternfly.validation",[]).directive("pfValidation",["$timeout",function($timeout){"use strict";return{restrict:"A",require:"ngModel",scope:{pfValidation:"&",pfValidationDisabled:"="},link:function(scope,element,attrs,ctrl){function validate(){var valid,val=scope.inputCtrl.$modelValue,valFunc=scope.pfValidation({input:val});attrs.pfValidation||(valFunc=!0),valid=!val||valFunc||""===val,toggleErrorClass(scope.valEnabled&&!valid?!0:!1)}function toggleErrorClass(add){var messageElement=element.next(),parentElement=element.parent(),hasErrorM=parentElement.hasClass("has-error"),wasHidden=messageElement.hasClass("ng-hide");scope.inputCtrl.$setValidity("pf-validation",!add),add&&(hasErrorM||parentElement.addClass("has-error"),wasHidden&&messageElement.removeClass("ng-hide")),add||(hasErrorM&&parentElement.removeClass("has-error"),wasHidden||messageElement.addClass("ng-hide"))}scope.inputCtrl=ctrl,scope.valEnabled=!attrs.pfValidationDisabled,scope.$watch("pfValidationDisabled",function(newVal){scope.valEnabled=!newVal,newVal?(scope.inputCtrl.$setValidity("pfValidation",!0),toggleErrorClass(!1)):validate()}),attrs.pfValidation?$timeout(function(){validate()},0):!scope.inputCtrl.$valid&&scope.inputCtrl.$dirty&&toggleErrorClass(!0),scope.$watch("inputCtrl.$valid",function(isValid){toggleErrorClass(isValid?!1:!0)}),scope.$watch("inputCtrl.$modelValue",function(){validate()})}}}]),angular.module("patternfly.views").directive("pfCardView",["pfUtils",function(pfUtils){"use strict";return{restrict:"A",scope:{config:"=?",items:"=",eventId:"@id"},transclude:!0,templateUrl:"views/cardview/card-view.html",controller:["$scope",function($scope){if($scope.defaultConfig={selectItems:!1,multiSelect:!1,dblClick:!1,selectionMatchProp:"uuid",selectedItems:[],checkDisabled:!1,showSelectBox:!0,onSelect:null,onSelectionChange:null,onCheckBoxChange:null,onClick:null,onDblClick:null},$scope.config=pfUtils.merge($scope.defaultConfig,$scope.config),$scope.config.selectItems&&$scope.config.showSelectBox)throw new Error("pfCardView - Illegal use of pfCardView directive! Cannot allow both select box and click selection in the same card view.")}],link:function(scope,element,attrs){attrs.$observe("config",function(){scope.config=pfUtils.merge(scope.defaultConfig,scope.config),scope.config.selectItems||(scope.config.selectedItems=[]),!scope.config.multiSelect&&scope.config.selectedItems&&scope.config.selectedItems.length>0&&(scope.config.selectedItems=[scope.config.selectedItems[0]])}),scope.itemClick=function(e,item){var alreadySelected,selectionChanged=!1,continueEvent=!0;return scope.checkDisabled(item)?continueEvent:(scope.config&&scope.config.selectItems&&item&&(scope.config.multiSelect&&!scope.config.dblClick?(alreadySelected=_.find(scope.config.selectedItems,function(itemObj){return itemObj===item}),alreadySelected?scope.config.selectedItems=_.without(scope.config.selectedItems,item):(scope.config.selectedItems.push(item),selectionChanged=!0)):scope.config.selectedItems[0]===item?(scope.config.dblClick||(scope.config.selectedItems=[],selectionChanged=!0),continueEvent=!1):(scope.config.selectedItems=[item],selectionChanged=!0),selectionChanged&&scope.config.onSelect&&scope.config.onSelect(item,e),selectionChanged&&scope.config.onSelectionChange&&scope.config.onSelectionChange(scope.config.selectedItems,e)),scope.config.onClick&&scope.config.onClick(item,e),continueEvent)},scope.dblClick=function(e,item){scope.config.onDblClick&&scope.config.onDblClick(item,e)},scope.checkBoxChange=function(item){scope.config.onCheckBoxChange&&scope.config.onCheckBoxChange(item)},scope.isSelected=function(item){var matchProp=scope.config.selectionMatchProp,selected=!1;if(scope.config.showSelectBox)selected=item.selected;else if(scope.config.selectedItems.length)return _.find(scope.config.selectedItems,function(itemObj){return itemObj[matchProp]===item[matchProp]});return selected},scope.checkDisabled=function(item){return scope.config.checkDisabled&&scope.config.checkDisabled(item)}}}}]),angular.module("patternfly.views").directive("pfListView",["$timeout","$window","pfUtils",function($timeout,$window,pfUtils){"use strict";return{restrict:"A",scope:{config:"=?",items:"=",actionButtons:"=?",enableButtonForItemFn:"=?",menuActions:"=?",updateMenuActionForItemFn:"=?",actions:"=?",updateActionForItemFn:"=?"},transclude:!0,templateUrl:"views/listview/list-view.html",controller:["$scope","$element",function($scope,$element){var setDropMenuLocation=function(parentDiv){var dropButton=parentDiv.querySelector(".dropdown-toggle"),dropMenu=parentDiv.querySelector(".dropdown-menu"),parentRect=$element[0].getBoundingClientRect(),buttonRect=dropButton.getBoundingClientRect(),menuRect=dropMenu.getBoundingClientRect(),menuTop=buttonRect.top-menuRect.height,menuBottom=buttonRect.top+buttonRect.height+menuRect.height;menuBottom<=parentRect.top+parentRect.height||menuTop<parentRect.top?$scope.dropdownClass="dropdown":$scope.dropdownClass="dropup"};if($scope.defaultConfig={selectItems:!1,multiSelect:!1,dblClick:!1,selectionMatchProp:"uuid",selectedItems:[],checkDisabled:!1,showSelectBox:!0,onSelect:null,onSelectionChange:null,onCheckBoxChange:null,onClick:null,onDblClick:null},$scope.config=pfUtils.merge($scope.defaultConfig,$scope.config),$scope.config.selectItems&&$scope.config.showSelectBox)throw new Error("pfListView - Illegal use of pListView directive! Cannot allow both select box and click selection in the same list view.");$scope.dropdownClass="dropdown",$scope.handleButtonAction=function(action,item){!$scope.checkDisabled(item)&&action&&action.actionFn&&$scope.enableButtonForItem(action,item)&&action.actionFn(action,item)},$scope.handleMenuAction=function(action,item){!$scope.checkDisabled(item)&&action&&action.actionFn&&action.isDisabled!==!0&&action.actionFn(action,item)},$scope.enableButtonForItem=function(action,item){var enable=!0;return"function"==typeof $scope.enableButtonForItemFn?$scope.enableButtonForItemFn(action,item):enable},$scope.updateActions=function(item){"function"==typeof $scope.updateMenuActionForItemFn&&$scope.menuActions.forEach(function(action){$scope.updateMenuActionForItemFn(action,item)})},$scope.setupActions=function(item,event){$scope.checkDisabled(item)||($scope.updateActions(item),$timeout(function(){var nextElement,parentDiv=void 0;for(nextElement=event.target;nextElement&&!parentDiv;)-1!==nextElement.className.indexOf("dropdown-kebab-pf")&&(parentDiv=nextElement,-1!==nextElement.className.indexOf("open")&&setDropMenuLocation(parentDiv)),nextElement=nextElement.parentElement}))}}],link:function(scope,element,attrs){attrs.$observe("config",function(){scope.config=pfUtils.merge(scope.defaultConfig,scope.config),scope.config.selectItems||(scope.config.selectedItems=[]),!scope.config.multiSelect&&scope.config.selectedItems&&scope.config.selectedItems.length>0&&(scope.config.selectedItems=[scope.config.selectedItems[0]])}),scope.itemClick=function(e,item){var alreadySelected,selectionChanged=!1,continueEvent=!0;return scope.checkDisabled(item)?continueEvent:(scope.config&&scope.config.selectItems&&item&&(scope.config.multiSelect&&!scope.config.dblClick?(alreadySelected=_.find(scope.config.selectedItems,function(itemObj){return itemObj===item}),alreadySelected?scope.config.selectedItems=_.without(scope.config.selectedItems,item):(scope.config.selectedItems.push(item),selectionChanged=!0)):scope.config.selectedItems[0]===item?(scope.config.dblClick||(scope.config.selectedItems=[],selectionChanged=!0),continueEvent=!1):(scope.config.selectedItems=[item],selectionChanged=!0),selectionChanged&&scope.config.onSelect&&scope.config.onSelect(item,e),selectionChanged&&scope.config.onSelectionChange&&scope.config.onSelectionChange(scope.config.selectedItems,e)),scope.config.onClick&&scope.config.onClick(item,e),continueEvent)},scope.dblClick=function(e,item){return scope.checkDisabled(item)?continueEvent:void(scope.config.onDblClick&&scope.config.onDblClick(item,e))},scope.checkBoxChange=function(item){scope.config.onCheckBoxChange&&scope.config.onCheckBoxChange(item)},scope.isSelected=function(item){var matchProp=scope.config.selectionMatchProp,selected=!1;return scope.config.showSelectBox?selected=item.selected:scope.config.selectItems&&scope.config.selectedItems.length&&(selected=_.find(scope.config.selectedItems,function(itemObj){return itemObj[matchProp]===item[matchProp]})),selected},scope.checkDisabled=function(item){return scope.config.checkDisabled&&scope.config.checkDisabled(item)}}}}]),function(){"use strict";angular.module("patternfly.views").constant("pfViewUtils",{getDashboardView:function(title){return{id:"dashboardView",title:title||"Dashboard View",iconClass:"fa fa-dashboard"}},getCardView:function(title){return{id:"cardView",title:title||"Card View",iconClass:"fa fa-th"}},getListView:function(title){return{id:"listView",title:title||"List View",iconClass:"fa fa-th-list"}},getTableView:function(title){return{id:"tableView",title:title||"Table View",iconClass:"fa fa-table"}},getTopologyView:function(title){return{id:"topologyView",title:title||"Topology View",iconClass:"fa fa-sitemap"}}})}(),angular.module("patternfly.card").run(["$templateCache",function($templateCache){"use strict";$templateCache.put("card/aggregate-status/aggregate-status-card.html",'<div ng-if=!isMiniLayout class="card-pf card-pf-aggregate-status" ng-class="{\'card-pf-accented\': shouldShowTopBorder, \'card-pf-aggregate-status-alt\': isAltLayout}"><h2 class=card-pf-title><a href={{status.href}} ng-if=status.href><span class={{status.iconClass}}></span> <span class=card-pf-aggregate-status-count>{{status.count}}</span> <span class=card-pf-aggregate-status-title>{{status.title}}</span></a> <span ng-if=!status.href><span class={{status.iconClass}}></span> <span class=card-pf-aggregate-status-count>{{status.count}}</span> <span class=card-pf-aggregate-status-title>{{status.title}}</span></span></h2><div class=card-pf-body><p class=card-pf-aggregate-status-notifications><span class=card-pf-aggregate-status-notification ng-repeat="notification in status.notifications"><a href={{notification.href}} ng-if=notification.href><span class={{notification.iconClass}}></span>{{ notification.count }}</a> <span ng-if=!notification.href><span class={{notification.iconClass}}></span>{{ notification.count }}</span></span></p></div></div><div ng-if=isMiniLayout class="card-pf card-pf-aggregate-status card-pf-aggregate-status-mini" ng-class="{\'card-pf-accented\': shouldShowTopBorder}"><h2 class=card-pf-title><span ng-if=status.iconClass class={{status.iconClass}}></span> <a ng-if=status.href href={{status.href}}><span class=card-pf-aggregate-status-count>{{status.count}}</span> {{status.title}}</a> <span ng-if=!status.href><span class=card-pf-aggregate-status-count>{{status.count}}</span> {{status.title}}</span></h2><div class=card-pf-body><p ng-if="status.notification.iconClass || status.notification.count" class=card-pf-aggregate-status-notifications><span class=card-pf-aggregate-status-notification><a ng-if=status.notification.href href={{status.notification.href}}><span ng-if=status.notification.iconClass class={{status.notification.iconClass}}></span><span ng-if=status.notification.count>{{status.notification.count}}</span></a> <span ng-if=!status.notification.href><span ng-if=status.notification.iconClass class={{status.notification.iconClass}}></span><span ng-if=status.notification.count>{{status.notification.count}}</span></span></span></p></div></div>'),$templateCache.put("card/basic/card-filter.html",'<button type=button class="btn btn-default dropdown-toggle" data-toggle=dropdown aria-haspopup=true aria-expanded=false>{{currentFilter.label}} <span class=caret></span></button><ul class="dropdown-menu dropdown-menu-right" role=menu><li ng-repeat="item in filter.filters" ng-class="{\'selected\': item === currentFilter}"><a role=menuitem tabindex=-1 ng-click=filterCallBackFn(item)>{{item.label}}</a></li></ul>'),$templateCache.put("card/basic/card.html",'<div ng-class="showTopBorder === \'true\' ? \'card-pf card-pf-accented\' : \'card-pf\'"><div ng-if=showHeader() ng-class="shouldShowTitlesSeparator ? \'card-pf-heading\' : \'card-pf-heading-no-bottom\'"><div ng-if=showFilterInHeader() class="dropdown card-pf-time-frame-filter"><div ng-include="\'card/basic/card-filter.html\'"></div></div><h2 class=card-pf-title>{{headTitle}}</h2></div><span ng-if=subTitle class=card-pf-subtitle>{{subTitle}}</span><div class=card-pf-body><div ng-transclude></div></div><div ng-if=footer class=card-pf-footer><div ng-if=showFilterInFooter() class="dropdown card-pf-time-frame-filter"><div ng-include="\'card/basic/card-filter.html\'"></div></div><p><a ng-if=footer.href href={{footer.href}} ng-class="{\'card-pf-link-with-icon\':footer.iconClass,\'card-pf-link\':!footer.iconClass}"><span ng-if=footer.iconClass class="{{footer.iconClass}} card-pf-footer-text"></span> <span ng-if=footer.text class=card-pf-footer-text>{{footer.text}}</span></a> <a ng-if="footer.callBackFn && !footer.href" ng-click=footerCallBackFn() ng-class="{\'card-pf-link-with-icon\':footer.iconClass,\'card-pf-link\':!footer.iconClass}"><span class="{{footer.iconClass}} card-pf-footer-text" ng-if=footer.iconClass></span> <span class=card-pf-footer-text ng-if=footer.text>{{footer.text}}</span></a> <span ng-if="!footer.href && !footer.callBackFn"><span ng-if=footer.iconClass class="{{footer.iconClass}} card-pf-footer-text" ng-class="{\'card-pf-link-with-icon\':footer.iconClass,\'card-pf-link\':!footer.iconClass}"></span> <span ng-if=footer.text class=card-pf-footer-text>{{footer.text}}</span></span></p></div></div>')}]),angular.module("patternfly.charts").run(["$templateCache",function($templateCache){"use strict";$templateCache.put("charts/donut/donut-pct-chart.html","<span><div pf-c3-chart id={{donutChartId}} config=config></div></span>"),$templateCache.put("charts/empty-chart.html",'<div class=empty-chart-content ng-style=sizeStyles><span class="pficon pficon-info"></span> <span>No data available</span></div>'),$templateCache.put("charts/heatmap/heatmap-legend.html",'<ul class=heatmap-pf-legend-container><li ng-repeat="item in legendItems" class=heatmap-pf-legend-items><span class=legend-pf-color-box ng-style="{background: item.color}"></span> <span class=legend-pf-text>{{item.text}}</span></li></ul>'),$templateCache.put("charts/heatmap/heatmap.html",'<div class=heatmap-pf-container><h3>{{chartTitle}}</h3><div class=heatmap-container ng-style=containerStyles><svg class=heatmap-pf-svg></svg></div><div pf-empty-chart ng-if="chartDataAvailable === false" chart-height=height></div><div ng-if=!loadingDone class="spinner spinner-lg loading"></div><div ng-if=showLegend pf-heatmap-legend legend=legendLabels legend-colors=heatmapColorPattern></div></div>'),$templateCache.put("charts/sparkline/sparkline-chart.html","<span><div pf-c3-chart id={{sparklineChartId}} config=chartConfig></div></span>"),$templateCache.put("charts/trends/trends-chart.html",'<span ng-switch on=config.layout ng-class="{\'data-unavailable-pf\': chartData.dataAvailable === false}"><div ng-switch-default ng-class="{\'trend-card-large-pf\': showLargeCardLayout,\'trend-card-small-pf\': showSmallCardLayout}"><span class=trend-header-pf ng-if=config.title>{{config.title}}</span> <span ng-if=showActualValue><span class=trend-title-big-pf>{{getLatestValue()}}</span> <span class=trend-title-small-pf>{{config.units}}</span></span> <span ng-if=showPercentageValue><span class=trend-title-big-pf>{{getPercentageValue() + \'%\'}}</span> <span class=trend-title-small-pf>of {{chartData.total + \' \' + config.units}}</span></span><div pf-sparkline-chart ng-if="chartData.dataAvailable !== false" config=config chart-data=chartData chart-height=getChartHeight() show-x-axis=showXAxis show-y-axis=showYAxis></div><div pf-empty-chart ng-if="chartData.dataAvailable === false" chart-height=getChartHeight()></div><span class=trend-footer-pf ng-if=config.timeFrame>{{config.timeFrame}}</span></div><div ng-switch-when=compact class=trend-card-compact-pf><div class="row trend-row"><div class="col-sm-4 col-md-4"><div class=trend-compact-details><span ng-if=showActualValue><span class=trend-title-compact-big-pf>{{getLatestValue()}}</span> <span class=trend-title-compact-small-pf>{{config.units}}</span></span> <span ng-if=showPercentageValue><span class=trend-title-compact-big-pf>{{getPercentageValue() + \'%\'}}</span> <span class=trend-title-compact-small-pf>of {{chartData.total + \' \' + config.units}}</span></span> <span class=trend-header-compact-pf ng-if=config.title>{{config.title}}</span></div></div><div class="col-sm-8 col-md-8"><div pf-sparkline-chart ng-if="chartData.dataAvailable !== false" config=config chart-data=chartData chart-height=getChartHeight() show-x-axis=showXAxis show-y-axis=showYAxis></div><div pf-empty-chart ng-if="chartData.dataAvailable === false" chart-height=getChartHeight()></div></div></div></div><div ng-switch-when=inline class=trend-card-inline-pf><div class="row trend-row"><div class="col-sm-8 col-md-8 trend-flat-col"><div pf-sparkline-chart ng-if="chartData.dataAvailable !== false" config=config chart-data=chartData chart-height=getChartHeight() show-x-axis=showXAxis show-y-axis=showYAxis></div><div pf-empty-chart ng-if="chartData.dataAvailable === false" chart-height=getChartHeight()></div></div><div class="col-sm-4 col-md-4 trend-flat-col"><div class=trend-flat-details><div class=trend-flat-details-cell><span class=trend-title-flat-big-pf>{{getPercentageValue() + \'%\'}}</span></div><div class=trend-flat-details-cell><span class=trend-label-flat-strong-pf>{{config.trendLabel}}</span> <span class=trend-label-flat-pf>{{getLatestValue()}} of {{chartData.total + \' \' + config.units}}</span></div></div></div></div></div></span>'),$templateCache.put("charts/utilization-bar/utilization-bar-chart.html",'<div class=utilization-bar-chart-pf><span ng-if="!layout || layout.type === \'regular\'"><div ng-if=chartTitle class=progress-description>{{chartTitle}}</div><div class="progress progress-label-top-right"><div class=progress-bar role=progressbar ng-class="{\'animate\': animate,\n           \'progress-bar-success\': isOk, \'progress-bar-danger\': isError, \'progress-bar-warning\': isWarn}" ng-style="{width:chartData.percentageUsed + \'%\'}" tooltip="{{chartData.percentageUsed}}% Used"><span ng-if=chartFooter ng-bind-html=chartFooter></span> <span ng-if="!chartFooter && (!footerLabelFormat || footerLabelFormat === \'actual\')"><strong>{{chartData.used}} of {{chartData.total}} {{units}}</strong> Used</span> <span ng-if="!chartFooter && footerLabelFormat === \'percent\'"><strong>{{chartData.percentageUsed}}%</strong> Used</span></div><div class="progress-bar progress-bar-remaining" role=progressbar aria-valuenow=5 aria-valuemin=0 aria-valuemax=100 ng-style="{width:(100 - chartData.percentageUsed) + \'%\'}" tooltip="{{100 - chartData.percentageUsed}}% Available"></div></div></span> <span ng-if="layout && layout.type === \'inline\'"><div class="progress-container progress-description-left progress-label-right" ng-style="{\'padding-left\':layout.titleLabelWidth, \'padding-right\':layout.footerLabelWidth}"><div ng-if=chartTitle class=progress-description ng-style="{\'max-width\':layout.titleLabelWidth}">{{chartTitle}}</div><div class=progress><div class=progress-bar role=progressbar aria-valuenow=25 aria-valuemin=0 aria-valuemax=100 ng-class="{\'animate\': animate, \'progress-bar-success\': isOk, \'progress-bar-danger\': isError, \'progress-bar-warning\': isWarn}" ng-style="{width:chartData.percentageUsed + \'%\'}" tooltip="{{chartData.percentageUsed}}% Used"><span ng-if=chartFooter ng-bind-html=chartFooter></span> <span ng-if="(!chartFooter) && (!footerLabelFormat || footerLabelFormat === \'actual\')" ng-style="{\'max-width\':layout.footerLabelWidth}"><strong>{{chartData.used}} {{units}}</strong> Used</span> <span ng-if="(!chartFooter) && footerLabelFormat === \'percent\'" ng-style="{\'max-width\':layout.footerLabelWidth}"><strong>{{chartData.percentageUsed}}%</strong> Used</span></div><div class="progress-bar progress-bar-remaining" role=progressbar aria-valuenow=75 aria-valuemin=0 aria-valuemax=100 ng-style="{width:(100 - chartData.percentageUsed) + \'%\'}" tooltip="{{100 - chartData.percentageUsed}}% Available"></div></div></div></span></div>'),$templateCache.put("charts/utilization-trend/utilization-trend-chart.html",'<div class=utilization-trend-chart-pf ng-class="{\'data-unavailable-pf\': chartData.dataAvailable === false}"><h3>{{config.title}}</h3><div class=current-values><h1 class="available-count pull-left">{{currentValue}}</h1><div class="available-text pull-left"><div><span>{{currentText}}</span></div><div><span>of {{chartData.total}} {{config.units}}</span></div></div></div><div class=donut-chart-pf><div pf-donut-pct-chart ng-if="chartData.dataAvailable !== false" config=donutConfig data=chartData center-label=centerLabel></div><div pf-empty-chart ng-if="chartData.dataAvailable === false" chart-height=231></div></div><div ng-if="chartData.dataAvailable !== false" class=sparkline-chart><div pf-sparkline-chart config=sparklineConfig chart-data=chartData chart-height=sparklineChartHeight show-x-axis=showSparklineXAxis show-y-axis=showSparklineYAxis></div></div><span class="pull-left legend-text">{{legendLeftText}}</span> <span class="pull-right legend-text">{{legendRightText}}</span></div>')}]),angular.module("patternfly.filters").run(["$templateCache",function($templateCache){"use strict";$templateCache.put("filters/filter-fields.html",'<div class="filter-pf filter-fields"><form><div class="form-group toolbar-pf-filter"><div class=input-group><div dropdown class=input-group-btn><button dropdown-toggle type=button class="btn btn-default dropdown-toggle filter-fields" aria-haspopup=true aria-expanded=false tooltip="Filter by" tooltip-placement=top>{{currentField.title}} <span class=caret></span></button><ul class=dropdown-menu><li ng-repeat="item in config.fields"><a class=filter-field role=menuitem tabindex=-1 ng-click=selectField(item)>{{item.title}}</a></li></ul></div><div ng-if="currentField.filterType !== \'select\'"><input class=form-control type={{currentField.filterType}} ng-model=config.currentValue placeholder={{currentField.placeholder}} ng-keypress="onValueKeyPress($event)"></div><div ng-if="currentField.filterType === \'select\'"><select pf-select class="form-control filter-select" id=currentValue ng-model=config.currentValue ng-options="filterValue for filterValue in currentField.filterValues" ng-change=selectValue(config.currentValue)><option value="">{{currentField.placeholder}}</option></select></div></div></div></form></div>'),$templateCache.put("filters/filter-results.html",'<div class=filter-pf><div class="row toolbar-pf-results"><div class=col-sm-12><h5>{{config.resultsCount}} Results</h5><p ng-if="config.appliedFilters.length > 0">Active filters:</p><ul class=list-inline><li ng-repeat="filter in config.appliedFilters"><span class="active-filter label label-info">{{filter.title}}: {{filter.value}} <a><span class="pficon pficon-close" ng-click=clearFilter(filter)></span></a></span></li></ul><p><a class=clear-filters ng-click=clearAllFilters() ng-if="config.appliedFilters.length > 0">Clear All Filters</a></p></div><!-- /col --></div><!-- /row --></div>'),$templateCache.put("filters/filter.html","<div class=filter-pf><div pf-filter-fields config=config add-filter-fn=addFilter></div><div pf-filter-results config=config></div></div>")}]),angular.module("patternfly.form").run(["$templateCache",function($templateCache){"use strict";$templateCache.put("form/datepicker/datepicker.html",'<div class="input-group date"><input class="form-control"> <span class=input-group-addon><span class="fa fa-calendar"></span></span></div>'),$templateCache.put("form/form-buttons/form-buttons.html",'<div class=form-group><div class="{{ pfButtonContainerClass }}"><div class="control-group buttons"><button class="btn btn-default" type=button ng-click=pfHandleCancel() ng-disabled=pfWorking translate>Cancel</button> <button class="btn btn-primary" ng-click="pfHandleSave(); pfWorking = true" ng-disabled="isInvalid() || pfWorking"><i class="icon-spinner icon-spin" ng-show=pfWorking></i> <span ng-show=pfWorking translate>Saving...</span> <span ng-hide=pfWorking translate>Save</span></button></div></div></div>'),$templateCache.put("form/form-group/form-group.html",'<div class=form-group ng-class="{ \'has-error\' : hasErrors() }"><label for="{{ pfField }}" class="control-label {{ pfLabelClass }}">{{ pfLabel }}</label><div class="{{ pfInputClass }}"><span ng-transclude></span> <span class=help-block ng-show=error.messages><ul><li ng-repeat="message in error.messages">{{ message }}</li></ul></span></div></div>')}]),angular.module("patternfly.notification").run(["$templateCache",function($templateCache){"use strict";$templateCache.put("notification/inline-notification.html",'<div class="alert alert-{{pfNotificationType}}" ng-class="{\'alert-dismissable\': pfNotificationPersistent === true}"><button ng-show=pfNotificationPersistent ng-click=$parent.notifications.remove($index) type=button class=close data-dismiss=alert aria-hidden=true><span class="pficon pficon-close"></span></button> <span class="pficon pficon-ok" ng-show="pfNotificationType === \'success\'"></span> <span class="pficon pficon-info" ng-show="pfNotificationType === \'info\'"></span> <span class="pficon pficon-error-circle-o" ng-show="pfNotificationType === \'danger\'"></span> <span class="pficon pficon-warning-triangle-o" ng-show="pfNotificationType === \'warning\'"></span> <strong>{{pfNotificationHeader}}</strong> {{pfNotificationMessage}}</div>'),$templateCache.put("notification/notification-list.html",'<div data-ng-show="notifications.data.length > 0"><div ng-repeat="notification in notifications.data"><pf-inline-notification pf-notification-type=notification.type pf-notification-header=notification.header pf-notification-message=notification.message pf-notification-persistent=notification.isPersistent pf-notification-index=$index></pf-inline-notification></div></div>'),$templateCache.put("notification/notification.html",'<div class="alert alert-{{pfNotificationType}}"><button ng-show=pfNotificationPersistent type=button class=close ng-click=$parent.notifications.remove($index)><span aria-hidden=true>&times;</span><span class=sr-only>Close</span></button> <span class="pficon pficon-ok" ng-show="pfNotificationType === \'success\'"></span> <span class="pficon pficon-info" ng-show="pfNotificationType === \'info\'"></span> <span class="pficon pficon-error-circle-o" ng-show="pfNotificationType === \'danger\'"></span> <span class="pficon pficon-warning-triangle-o" ng-show="pfNotificationType === \'warning\'"></span> <strong>{{pfNotificationHeader}}</strong> {{pfNotificationMessage}}</div>')}]),angular.module("patternfly.sort").run(["$templateCache",function($templateCache){"use strict";$templateCache.put("sort/sort.html",'<div class=sort-pf><form><div class=form-group><div class="dropdown btn-group"><button type=button class="btn btn-default dropdown-toggle" data-toggle=dropdown aria-haspopup=true aria-expanded=false tooltip="Sort by" tooltip-placement=bottom>{{config.currentField.title}} <span class=caret></span></button><ul class=dropdown-menu><li ng-repeat="item in config.fields" ng-class="{\'selected\': item === config.currentField}"><a class=sort-field role=menuitem tabindex=-1 ng-click=selectField(item)>{{item.title}}</a></li></ul></div><button class="btn btn-link" type=button ng-click=changeDirection()><span class=sort-direction ng-class=getSortIconClass()></span></button></div></form></div>')}]),angular.module("patternfly.toolbars").run(["$templateCache",function($templateCache){"use strict";$templateCache.put("toolbars/toolbar.html",'<div class=container-fluid><div class="row toolbar-pf"><div class=col-sm-12><form class=toolbar-pf-actions ng-class="{\'no-filter-results\': !config.filterConfig}"><div pf-filter-fields id={{filterDomId}}_fields config=config.filterConfig ng-if=config.filterConfig add-filter-fn=addFilter></div><div pf-sort id={{sortDomId}} config=config.sortConfig ng-if=config.sortConfig></div><div class="form-group toolbar-actions" ng-if="config.actionsConfig &&\n                   ((config.actionsConfig.primaryActions && config.actionsConfig.primaryActions.length > 0) ||\n                    (config.actionsConfig.moreActions && config.actionsConfig.moreActions.length > 0))"><button class="btn btn-default primary-action" type=button ng-repeat="action in config.actionsConfig.primaryActions" title={{action.title}} ng-click=handleAction(action) ng-disabled="action.isDisabled === true">{{action.name}}</button><div class="dropdown dropdown-kebab-pf" ng-if="config.actionsConfig.moreActions && config.actionsConfig.moreActions.length > 0"><button class="btn btn-link dropdown-toggle" type=button id={{filterDomId}}_kebab data-toggle=dropdown aria-haspopup=true aria-expanded=true><span class="fa fa-ellipsis-v"></span></button><ul class=dropdown-menu aria-labelledby=dropdownKebab><li ng-repeat="action in config.actionsConfig.moreActions" role="{{action.isSeparator === true ? \'separator\' : \'menuitem\'}}" ng-class="{\'divider\': action.isSeparator === true, \'disabled\': action.isDisabled === true}"><a ng-if="action.isSeparator !== true" class=secondary-action title={{action.title}} ng-click=handleAction(action)>{{action.name}}</a></li></ul></div></div><div class="toolbar-pf-view-selector pull-right" ng-if="config.viewsConfig && config.viewsConfig.views"><ul class=list-inline><li ng-repeat="view in config.viewsConfig.viewsList" ng-class="{\'active\': isViewSelected(view.id), \'disabled\': checkViewDisabled(view)}" title={{view.title}}><a><i class="view-selector {{view.iconClass}}" ng-click=viewSelected(view.id)></i></a></li></ul></div></form><div pf-filter-results id={{filterDomId}_results} config=config.filterConfig ng-if=config.filterConfig></div></div><!-- /col --></div><!-- /row --></div><!-- /container -->');
}]),angular.module("patternfly.views").run(["$templateCache",function($templateCache){"use strict";$templateCache.put("views/cardview/card-view.html",'<div class=card-view-pf><div class=card ng-repeat="item in items" ng-class="{\'pf-selectable\': selectItems, \'active\': isSelected(item), \'disabled\': checkDisabled(item)}"><div class=card-content ng-click="itemClick($event, item)" ng-dblclick="dblClick($event, item)"><div pf-transclude=parent></div></div><div class=card-check-box ng-if=config.showSelectBox><input type=checkbox value=item.selected ng-model=item.selected ng-disabled=checkDisabled(item) ng-change="checkBoxChange(item)"></div></div></div>'),$templateCache.put("views/listview/list-view.html",'<div class=list-view-pf><div class=list-group-item ng-repeat="item in items track by $index" ng-class="{\'pf-selectable\': selectItems, \'active\': isSelected(item), \'disabled\': checkDisabled(item)}"><div class=list-view-pf-checkbox ng-if=config.showSelectBox><input type=checkbox value=item.selected ng-model=item.selected ng-disabled=checkDisabled(item) ng-change="checkBoxChange(item)"></div><div class=list-view-pf-actions ng-if="(actionButtons && actionButtons.length > 0) || (menuActions && menuActions.length > 0)"><button class="btn btn-default" ng-repeat="actionButton in actionButtons" title=actionButton.title ng-class="{\'disabled\' : checkDisabled(item) || !enableButtonForItem(actionButton, item)}" ng-click="handleButtonAction(actionButton, item)">{{actionButton.name}}</button><div class="{{dropdownClass}} pull-right dropdown-kebab-pf" id=kebab_{{$index}} ng-if="menuActions && menuActions.length > 0"><button class="btn btn-link dropdown-toggle" type=button id=dropdownKebabRight_{{$index}} ng-class="{\'disabled\': checkDisabled(item)}" ng-click="setupActions(item, $event)" data-toggle=dropdown aria-haspopup=true aria-expanded=true><span class="fa fa-ellipsis-v"></span></button><ul class="dropdown-menu dropdown-menu-right {{$index}}" aria-labelledby=dropdownKebabRight_{{$index}}><li ng-repeat="menuAction in menuActions" ng-if="menuAction.isVisible !== false" role="{{menuAction.isSeparator === true ? \'separator\' : \'menuitem\'}}" ng-class="{\'divider\': (menuAction.isSeparator === true), \'disabled\': (menuAction.isDisabled === true)}"><a ng-if="menuAction.isSeparator !== true" title={{menuAction.title}} ng-click="handleMenuAction(menuAction, item)">{{menuAction.name}}</a></li></ul></div></div><div pf-transclude=parent class=list-view-pf-main-info ng-click="itemClick($event, item)" ng-dblclick="dblClick($event, item)"></div></div></div>')}]);