/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.tests.dockerized;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InterfaceIpV4Address {
    private static Map<String, List<InetAddress>> interfaceIpAddressMap;

    private InterfaceIpV4Address() {
    }

    public static List<InetAddress> getIpAddresses(String intfc) {
        if (interfaceIpAddressMap == null) {
            interfaceIpAddressMap = InterfaceIpV4Address.init();
        }
        return interfaceIpAddressMap.get(intfc);
    }

    private static Map<String, List<InetAddress>> init() {
        HashMap interfacesIpAddressesMap = new HashMap();
        Enumeration<NetworkInterface> networkInterfaces = null;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException ex) {
            throw new RuntimeException("Failed to get network interfaces", ex);
        }
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            networkInterface.getDisplayName();
            ArrayList<InetAddress> ipAddresses = new ArrayList<InetAddress>();
            Enumeration<InetAddress> ee = networkInterface.getInetAddresses();
            while (ee.hasMoreElements()) {
                InetAddress inetAddress = ee.nextElement();
                if (!inetAddress.isSiteLocalAddress()) continue;
                ipAddresses.add(inetAddress);
            }
            interfacesIpAddressesMap.put(networkInterface.getDisplayName(), Collections.unmodifiableList(ipAddresses));
        }
        return Collections.unmodifiableMap(interfacesIpAddressesMap);
    }
}

