/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.tests.dockerized;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import org.hawkular.apm.tests.dockerized.model.JsonPathVerify;

public class JsonPathVerifier {
    JsonPathVerifier() {
    }

    public static boolean verify(String json, JsonPathVerify jsonPathVerify) {
        boolean result;
        Object leftObject = jsonPathVerify.getLeft();
        Object rightObject = jsonPathVerify.getRight();
        if (jsonPathVerify.getLeft().matches("\\$.*")) {
            leftObject = JsonPath.read((String)json, (String)jsonPathVerify.getLeft(), (Predicate[])new Predicate[0]);
        }
        if (jsonPathVerify.getRight().matches("\\$.*")) {
            rightObject = JsonPath.read((String)json, (String)jsonPathVerify.getRight(), (Predicate[])new Predicate[0]);
        }
        switch (jsonPathVerify.getOperator()) {
            case EQ: {
                result = leftObject.toString().equals(rightObject.toString());
                break;
            }
            case NE: {
                result = !leftObject.toString().equals(rightObject.toString());
                break;
            }
            case LT: {
                result = JsonPathVerifier.compareTo(leftObject.toString(), rightObject.toString()) < 0;
                break;
            }
            case GT: {
                result = JsonPathVerifier.compareTo(leftObject.toString(), rightObject.toString()) > 0;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported operator: " + (Object)((Object)jsonPathVerify.getOperator()));
            }
        }
        return result;
    }

    private static int compareTo(String n1, String n2) {
        BigDecimal b1 = BigDecimal.valueOf(JsonPathVerifier.parseNumber(n1).doubleValue());
        BigDecimal b2 = BigDecimal.valueOf(JsonPathVerifier.parseNumber(n2).doubleValue());
        return b1.compareTo(b2);
    }

    private static Number parseNumber(String str) {
        Number number;
        try {
            number = NumberFormat.getInstance().parse(str);
        }
        catch (ParseException e) {
            throw new IllegalStateException("Could not parse number: " + str, e);
        }
        return number;
    }
}

