/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.tests.dockerized;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import org.hawkular.apm.tests.common.ApmMockServer;
import org.hawkular.apm.tests.dockerized.JsonPathVerifier;
import org.hawkular.apm.tests.dockerized.environment.AbstractDockerBasedEnvironment;
import org.hawkular.apm.tests.dockerized.environment.DockerComposeExecutor;
import org.hawkular.apm.tests.dockerized.environment.DockerImageExecutor;
import org.hawkular.apm.tests.dockerized.environment.TestEnvironmentExecutor;
import org.hawkular.apm.tests.dockerized.exception.TestFailException;
import org.hawkular.apm.tests.dockerized.model.JsonPathVerify;
import org.hawkular.apm.tests.dockerized.model.TestCase;
import org.hawkular.apm.tests.dockerized.model.TestScenario;
import org.hawkular.apm.tests.dockerized.model.Type;

public class TestScenarioRunner {
    private static final Logger log = Logger.getLogger(TestScenarioRunner.class.getName());
    private final ObjectMapper objectMapper;
    private int apmServerPort;

    public TestScenarioRunner(int apmServerPort) {
        this.apmServerPort = apmServerPort;
        this.objectMapper = new ObjectMapper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(TestScenario testScenario) {
        if (testScenario.getEnvironment().getDockerCompose() != null && testScenario.getEnvironment().getImage() != null) {
            throw new IllegalArgumentException("Ambiguous environment: defined docker image and docker-compose, but we expect only one of them to be defined!");
        }
        log.info(String.format("========================= Starting test scenario: %s", testScenario));
        int successfulTestCases = 0;
        for (TestCase test : testScenario.getTests()) {
            if (test.isSkip()) continue;
            try (TestEnvironmentExecutor testEnvironmentExecutor = this.createTestEnvironmentExecutor(testScenario);){
                this.runTestCase(testScenario, test, testEnvironmentExecutor);
                ++successfulTestCases;
            }
        }
        log.info(String.format("========================= Closing test scenario : %s", testScenario));
        return successfulTestCases;
    }

    private void runTestCase(TestScenario testScenario, TestCase testCase, TestEnvironmentExecutor testEnvironmentExecutor) throws TestFailException {
        log.info(String.format("Executing test case: %s", testCase));
        List<String> environmentId = null;
        ApmMockServer apmServer = new ApmMockServer();
        apmServer.setHost("0.0.0.0");
        apmServer.setPort(this.apmServerPort);
        apmServer.setShutdownTimer(3600000);
        try {
            if (testScenario.getEnvironment().getApmAddress() != null) {
                testEnvironmentExecutor.createNetwork();
            }
            apmServer.run();
            environmentId = testEnvironmentExecutor.run(testScenario.getEnvironment());
            Thread.sleep(testScenario.getEnvironment().getInitWaitSeconds() * 1000L);
            testEnvironmentExecutor.execScript(environmentId, testCase.getScriptServiceName(), testCase.getAction());
            Thread.sleep(testCase.getAfterActionWaitSeconds() * 1000L);
            List<JsonPathVerify> jsonPathVerifies = this.verifyResults(testScenario, testCase, apmServer);
            if (!jsonPathVerifies.isEmpty()) {
                throw new TestFailException(testCase, jsonPathVerifies);
            }
        }
        catch (InterruptedException ex) {
            log.severe("Interruption exception");
            log.severe(ex.toString());
            throw new TestFailException(testCase, (Throwable)ex);
        }
        finally {
            if (environmentId != null) {
                testEnvironmentExecutor.stopAndRemove(environmentId);
            }
            if (apmServer != null) {
                apmServer.shutdown();
            }
        }
    }

    private List<JsonPathVerify> verifyResults(TestScenario testScenario, TestCase testCase, ApmMockServer apmServer) {
        String json;
        Collection<?> objects = this.getCapturedData(testScenario.getEnvironment().getType(), apmServer);
        try {
            json = this.serialize(objects);
        }
        catch (IOException ex) {
            log.severe(String.format("Failed to serialize traces: %s", objects));
            throw new RuntimeException("Failed to serialize traces = " + objects, ex);
        }
        log.info(String.format("Captured objects:\n%s", json));
        ArrayList<JsonPathVerify> failedJsonPathVerify = new ArrayList<JsonPathVerify>();
        for (JsonPathVerify jsonPathVerify : testCase.getVerify().getJsonPath()) {
            if (JsonPathVerifier.verify(json, jsonPathVerify)) continue;
            failedJsonPathVerify.add(jsonPathVerify);
        }
        return failedJsonPathVerify;
    }

    private Collection<?> getCapturedData(Type type, ApmMockServer apmMockServer) {
        List objects = null;
        switch (type) {
            case APM: 
            case APMAGENT: 
            case APMOTAGENT: {
                objects = apmMockServer.getTraces();
                break;
            }
            case ZIPKIN: {
                objects = apmMockServer.getSpans();
            }
        }
        return objects;
    }

    private TestEnvironmentExecutor createTestEnvironmentExecutor(TestScenario testScenario) {
        AbstractDockerBasedEnvironment testEnvironmentExecutor = testScenario.getEnvironment().getImage() != null ? DockerImageExecutor.getInstance(testScenario.getScenarioDirectory(), testScenario.getEnvironment().getApmAddress()) : DockerComposeExecutor.getInstance(testScenario.getScenarioDirectory(), testScenario.getEnvironment().getApmAddress());
        return testEnvironmentExecutor;
    }

    private String serialize(Object object) throws IOException {
        StringWriter out = new StringWriter();
        JsonGenerator gen = this.objectMapper.getFactory().createGenerator((Writer)out);
        gen.writeObject(object);
        gen.close();
        out.close();
        return out.toString();
    }
}

