/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.tests.dockerized;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.hawkular.apm.tests.dockerized.model.TestScenario;

public class TestScenariosFinder {
    private static final String SCENARIO_DIRECTORY_NAME_PREFIX = "test";
    private static final String SCENARIO_NAME = "test.json";
    private final String directory;
    private ObjectMapper objectMapper;

    public TestScenariosFinder(String directoryWithScenarios) {
        this.directory = directoryWithScenarios;
        this.objectMapper = new ObjectMapper();
    }

    public List<TestScenario> getScenarios() throws IOException {
        File folder = new File(this.directory);
        File[] scenarioDirectories = folder.listFiles((dir, name) -> name.startsWith(SCENARIO_DIRECTORY_NAME_PREFIX));
        ArrayList<TestScenario> testScenarios = new ArrayList<TestScenario>();
        for (File directory : scenarioDirectories) {
            if (!directory.isDirectory()) continue;
            File scenarioFile = directory.listFiles((dir, name) -> name.equals(SCENARIO_NAME))[0];
            String scenarioJson = this.readFile(scenarioFile);
            TestScenario testScenario = this.deserialize(scenarioJson, TestScenario.class);
            testScenario.setScenarioDirectory(directory.getAbsolutePath());
            testScenarios.add(testScenario);
        }
        return testScenarios;
    }

    public <T> T deserialize(String json, Class<T> type) throws IOException {
        JsonParser parser = this.objectMapper.getFactory().createParser(json);
        return (T)parser.readValueAs(type);
    }

    public String readFile(File file) throws IOException {
        byte[] bytes = Files.readAllBytes(Paths.get(file.toURI()));
        return new String(bytes);
    }
}

