/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.tests.dockerized.environment;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.CreateNetworkResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.Network;
import com.github.dockerjava.core.DockerClientBuilder;
import java.io.IOException;
import java.util.logging.Logger;
import org.hawkular.apm.tests.dockerized.environment.TestEnvironmentExecutor;
import org.hawkular.apm.tests.dockerized.exception.EnvironmentException;

public abstract class AbstractDockerBasedEnvironment
implements TestEnvironmentExecutor {
    private static final Logger log = Logger.getLogger(AbstractDockerBasedEnvironment.class.getName());
    protected String scenarioDirectory;
    protected String apmBindAddress;
    protected Network network;
    protected final DockerClient dockerClient;

    public AbstractDockerBasedEnvironment(String scenarioDirectory, String apmBindAddress) {
        this.scenarioDirectory = scenarioDirectory;
        this.apmBindAddress = apmBindAddress;
        this.dockerClient = DockerClientBuilder.getInstance().build();
    }

    @Override
    public void close() {
        this.removeNetwork();
        try {
            this.dockerClient.close();
        }
        catch (IOException ex) {
            log.severe("Could not close docker client");
            throw new EnvironmentException("Could not close docker client", ex);
        }
    }

    @Override
    public void createNetwork() {
        this.removeNetwork();
        String apmNetwork = this.apmBindAddress.substring(0, this.apmBindAddress.lastIndexOf(".")) + ".0/24";
        log.info(String.format("Creating network %s:", apmNetwork));
        Network.Ipam ipam = new Network.Ipam().withConfig(new Network.Ipam.Config[]{new Network.Ipam.Config().withSubnet(apmNetwork).withGateway(this.apmBindAddress)});
        CreateNetworkResponse createNetworkResponse = (CreateNetworkResponse)this.dockerClient.createNetworkCmd().withName("hawkular-apm").withIpam(ipam).exec();
        try {
            this.network = this.dockerClient.inspectNetworkCmd().withNetworkId(createNetworkResponse.getId()).exec();
        }
        catch (DockerException ex) {
            log.severe(String.format("Could not create network: %s", createNetworkResponse));
            throw new EnvironmentException("Could not create network: " + createNetworkResponse, ex);
        }
    }

    private void removeNetwork() {
        String networkToRemove = this.network != null ? this.network.getName() : "hawkular-apm";
        try {
            log.info(String.format("Removing network: %s", networkToRemove));
            this.dockerClient.removeNetworkCmd(networkToRemove).exec();
        }
        catch (DockerException ex) {
            log.severe(String.format("Could not remove network: %s", networkToRemove));
        }
    }
}

