/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.tests.dockerized.environment;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.hawkular.apm.tests.dockerized.environment.AbstractDockerBasedEnvironment;
import org.hawkular.apm.tests.dockerized.exception.EnvironmentException;
import org.hawkular.apm.tests.dockerized.model.TestEnvironment;

public class DockerComposeExecutor
extends AbstractDockerBasedEnvironment {
    private static final Logger log = Logger.getLogger(DockerComposeExecutor.class.getName());

    private DockerComposeExecutor(String scenarioDirectory, String apmBindAddress) {
        super(scenarioDirectory, apmBindAddress);
        if (apmBindAddress == null) {
            throw new NullPointerException("Bind address for APM should be specified.");
        }
    }

    public static DockerComposeExecutor getInstance(String scenarioDirectory, String apmBindAddress) {
        return new DockerComposeExecutor(scenarioDirectory, apmBindAddress);
    }

    @Override
    public List<String> run(TestEnvironment testEnvironment) {
        List<String> cmd;
        if (testEnvironment.isPull()) {
            cmd = this.composeCommandWithFiles(testEnvironment.getDockerCompose());
            cmd.add("pull");
            this.runShellCommand(cmd);
        }
        cmd = this.composeCommandWithFiles(testEnvironment.getDockerCompose());
        cmd.addAll(Arrays.asList("up", "-d"));
        this.runShellCommand(cmd);
        return testEnvironment.getDockerCompose();
    }

    @Override
    public void stopAndRemove(List<String> ids) {
        List<String> cmd = this.composeCommandWithFiles(ids);
        cmd.addAll(Arrays.asList("down", "--rmi", "all"));
        try {
            this.runShellCommand(cmd);
        }
        catch (EnvironmentException ex) {
            log.severe(String.format("docker-compose down failed %s", ex.getMessage()));
            ex.printStackTrace();
        }
    }

    @Override
    public void execScript(List<String> id, String serviceName, String script) {
        List<String> cmd = this.composeCommandWithFiles(id);
        cmd.addAll(Arrays.asList("exec", serviceName, "bash", "-c", this.scriptExecCommand(script)));
        this.runShellCommand(cmd);
    }

    private void runShellCommand(List<String> commands) {
        log.info(String.format("Executing command on host OS: `%s`", commands));
        try {
            Process process = Runtime.getRuntime().exec(commands.toArray(new String[0]));
            InputStream stdin = process.getInputStream();
            InputStreamReader isr = new InputStreamReader(stdin);
            BufferedReader br = new BufferedReader(isr);
            String line = null;
            log.info("<OUTPUT>");
            while ((line = br.readLine()) != null) {
                System.out.println(line);
            }
            log.info("</OUTPUT>");
            int exitVal = process.waitFor();
            log.info(String.format("Process exit value: %d", exitVal));
            if (process == null || exitVal != 0) {
                log.severe(String.format("`%s` did not return 0", commands));
                log.severe("-------- stderr ");
                log.severe(new BufferedReader(new InputStreamReader(process.getErrorStream())).lines().collect(Collectors.joining("\n")));
                log.severe("-------- /stderr ");
                throw new EnvironmentException(commands + " did not return 0, actual = " + (process != null ? Integer.valueOf(process.exitValue()) : ""));
            }
        }
        catch (IOException | InterruptedException ex) {
            log.severe(String.format("Could not run: %s", commands));
            throw new EnvironmentException("Could not run: " + commands, ex);
        }
        log.info(String.format("Command `%s`, successfully executed", commands));
    }

    private List<String> composeCommandWithFiles(List<String> composeFiles) {
        ArrayList<String> composeCmdWithArgs = new ArrayList<String>(composeFiles.size() * 2 + 1);
        composeCmdWithArgs.add("docker-compose");
        for (String composeFile : composeFiles) {
            composeCmdWithArgs.add("-f");
            composeCmdWithArgs.add(this.scenarioDirectory + File.separator + composeFile);
        }
        return composeCmdWithArgs;
    }
}

