/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.tests.dockerized.environment;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.AccessMode;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.SELContext;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.core.command.ExecStartResultCallback;
import com.github.dockerjava.core.command.PullImageResultCallback;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.hawkular.apm.tests.dockerized.InterfaceIpV4Address;
import org.hawkular.apm.tests.dockerized.environment.AbstractDockerBasedEnvironment;
import org.hawkular.apm.tests.dockerized.environment.TestEnvironmentExecutor;
import org.hawkular.apm.tests.dockerized.exception.EnvironmentException;
import org.hawkular.apm.tests.dockerized.model.TestEnvironment;
import org.hawkular.apm.tests.dockerized.model.Type;

public class DockerImageExecutor
extends AbstractDockerBasedEnvironment {
    private static final Logger log = Logger.getLogger(DockerImageExecutor.class.getName());
    private boolean userDefinedNetwork;

    private DockerImageExecutor(String scenarioDirectory, String apmBindAddress, Boolean userDefinedNetwork) {
        super(scenarioDirectory, apmBindAddress);
        this.userDefinedNetwork = userDefinedNetwork;
    }

    public static DockerImageExecutor getInstance(String scenarioDirectory, String apmBindAddress) {
        boolean userDefinedAddress;
        boolean bl = userDefinedAddress = apmBindAddress != null;
        if (apmBindAddress == null) {
            List<InetAddress> dockerInterfaceIpAddresses = InterfaceIpV4Address.getIpAddresses("docker0");
            if (dockerInterfaceIpAddresses == null || dockerInterfaceIpAddresses.isEmpty()) {
                throw new EnvironmentException("Could not find any ip address of network interface docker0");
            }
            apmBindAddress = dockerInterfaceIpAddresses.iterator().next().getHostAddress();
        }
        return new DockerImageExecutor(scenarioDirectory, apmBindAddress, userDefinedAddress);
    }

    @Override
    public List<String> run(TestEnvironment testEnvironment) {
        String hostOsMountDir = System.getProperties().getProperty("buildDirectory");
        CreateContainerCmd containerBuilder = this.dockerClient.createContainerCmd(testEnvironment.getImage()).withBinds(new Bind[]{new Bind(hostOsMountDir, new Volume(TestEnvironmentExecutor.Constants.HAWKULAR_APM_AGENT_DIRECTORY), AccessMode.ro, SELContext.shared), new Bind(this.scenarioDirectory, new Volume(TestEnvironmentExecutor.Constants.HAWKULAR_APM_TEST_DIRECTORY), AccessMode.ro, SELContext.shared)}).withExtraHosts(new String[]{"hawkular-apm:" + this.apmBindAddress});
        if (this.userDefinedNetwork) {
            if (this.network == null) {
                throw new IllegalStateException("Create network before running environment");
            }
            containerBuilder.withNetworkMode(this.network.getName());
        }
        containerBuilder.withEnv(this.apmEnvVariables(testEnvironment.getType()));
        if (testEnvironment.isPull()) {
            log.info("Pulling image...");
            ((PullImageResultCallback)this.dockerClient.pullImageCmd(testEnvironment.getImage()).exec((ResultCallback)new PullImageResultCallback())).awaitSuccess();
        }
        CreateContainerResponse containerResponse = containerBuilder.exec();
        log.info(String.format("Starting docker container: %s", containerResponse));
        try {
            this.dockerClient.startContainerCmd(containerResponse.getId()).exec();
        }
        catch (DockerException ex) {
            log.severe(String.format("Could not create or start docker container: %s", containerResponse));
            throw new EnvironmentException("Could not create or start docker container.", ex);
        }
        return Arrays.asList(containerResponse.getId());
    }

    @Override
    public void execScript(List<String> id, String serviceName, String script) {
        log.info(String.format("Executing script: %s, in container: %s", script, id));
        Object[] commands = null;
        try {
            commands = new String[]{"bash", "-c", this.scriptExecCommand(script)};
            ExecCreateCmdResponse exec = (ExecCreateCmdResponse)this.dockerClient.execCreateCmd(id.get(0)).withCmd((String[])commands).withAttachStdout(Boolean.valueOf(true)).withAttachStderr(Boolean.valueOf(true)).exec();
            ((ExecStartResultCallback)this.dockerClient.execStartCmd(exec.getId()).exec((ResultCallback)new ExecStartResultCallback((OutputStream)System.out, (OutputStream)System.err))).awaitCompletion();
        }
        catch (DockerException | InterruptedException ex) {
            log.severe(String.format("Could not execute command: %s", Arrays.toString(commands)));
            throw new EnvironmentException("Could not execute command " + Arrays.toString(commands), ex);
        }
    }

    @Override
    public void stopAndRemove(List<String> ids) {
        for (String container : ids) {
            log.info(String.format("Cleaning environment %s", container));
            try {
                this.dockerClient.removeContainerCmd(container).withForce(Boolean.valueOf(true)).exec();
            }
            catch (DockerException ex) {
                log.severe(String.format("Could not remove container: %s", container));
                throw new EnvironmentException("Could not remove container: " + container, ex);
            }
        }
    }

    private List<String> apmEnvVariables(Type type) {
        Properties properties = new Properties();
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(type.getPropertyFile());
        if (is == null) {
            throw new EnvironmentException("Could not load env variables property file: " + type.getPropertyFile());
        }
        try {
            properties.load(is);
        }
        catch (IOException ex) {
            log.severe(String.format("Could not open properties file: %s", type.getPropertyFile()));
            throw new EnvironmentException("Could not load env variables property file: " + type.getPropertyFile(), ex);
        }
        ArrayList<String> envVariables = new ArrayList<String>();
        for (String key : properties.stringPropertyNames()) {
            String value = properties.getProperty(key);
            envVariables.add(key + "=" + value);
        }
        return envVariables;
    }
}

