/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.tests.dockerized.environment;

import java.util.List;
import java.util.UUID;
import org.hawkular.apm.tests.dockerized.model.TestEnvironment;

public interface TestEnvironmentExecutor {
    public List<String> run(TestEnvironment var1);

    public void stopAndRemove(List<String> var1);

    public void close();

    public void execScript(List<String> var1, String var2, String var3);

    public void createNetwork();

    default public String scriptExecCommand(String script) {
        String sNewAbsolutePath = "/opt/hawkular-apm-test-local" + UUID.randomUUID();
        return "mkdir " + sNewAbsolutePath + " && cp " + Constants.HAWKULAR_APM_TEST_DIRECTORY + "/" + script + " " + sNewAbsolutePath + " && chmod +x " + sNewAbsolutePath + "/" + script + " && " + sNewAbsolutePath + "/" + script;
    }

    public static final class Constants {
        protected static final String HOST_ADDED_TO_ETC_HOSTS = "hawkular-apm";
        public static final String HAWKULAR_APM_AGENT_DIRECTORY;
        public static final String HAWKULAR_APM_TEST_DIRECTORY;

        static {
            String property = System.getProperties().getProperty("hawkular-apm.test.environment.agent.dir");
            HAWKULAR_APM_AGENT_DIRECTORY = property != null ? property : "/opt/hawkular-apm-agent";
            property = System.getProperties().getProperty("hawkular-apm.test.environment.test.dir");
            HAWKULAR_APM_TEST_DIRECTORY = property != null ? property : "/opt/hawkular-apm-test";
        }
    }
}

