/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.bus.broker.extension;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hawkular.bus.broker.extension.BrokerService;
import org.hawkular.bus.broker.extension.BrokerSubsystemDefinition;
import org.hawkular.bus.broker.extension.log.MsgLogger;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;

class BrokerSubsystemAdd
extends AbstractAddStepHandler {
    static final BrokerSubsystemAdd INSTANCE = new BrokerSubsystemAdd();
    private final MsgLogger msglog = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(BrokerSubsystemAdd.class);

    private BrokerSubsystemAdd() {
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        try {
            if (this.requiresRuntime(context)) {
                PathAddress deploymentAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"deployment", (String)"rest.war")});
                ModelNode op = Util.getEmptyOperation((String)"add", (ModelNode)deploymentAddress.toModelNode());
                op.get("enabled").set(true);
                op.get("persistent").set(false);
                Module module = Module.forClass(BrokerService.class);
                URL url = module.getExportedResource("rest.war");
                if (url == null) {
                    throw new FileNotFoundException("Could not find the REST WAR");
                }
                ModelNode contentItem = new ModelNode();
                String urlString = new File(url.toURI()).getAbsolutePath();
                if (!new File(urlString).exists()) {
                    throw new FileNotFoundException("Missing the WAR at [" + urlString + "]");
                }
                contentItem.get("path").set(urlString);
                contentItem.get("archive").set(false);
                op.get("content").add(contentItem);
                ImmutableManagementResourceRegistration rootResourceRegistration = context.getRootResourceRegistration();
                OperationStepHandler handler = rootResourceRegistration.getOperationHandler(deploymentAddress, "add");
                context.addStep(op, handler, OperationContext.Stage.MODEL);
            }
        }
        catch (Exception e) {
            this.msglog.errorRestWarCouldNotBeDeployed(e.toString());
            this.log.debug((Object)"The REST WAR deployment exception stack is logged with this message", (Throwable)e);
        }
        this.populateModel(operation, resource.getModel());
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        BrokerSubsystemDefinition.BROKER_ENABLED_ATTRIBDEF.validateAndSet(operation, model);
        BrokerSubsystemDefinition.BROKER_CONFIG_FILE_ATTRIBDEF.validateAndSet(operation, model);
        BrokerSubsystemDefinition.BROKER_NAME_ATTRIBDEF.validateAndSet(operation, model);
        BrokerSubsystemDefinition.BROKER_PERSISTENT_ATTRIBDEF.validateAndSet(operation, model);
        BrokerSubsystemDefinition.BROKER_USE_JMX_ATTRIBDEF.validateAndSet(operation, model);
        BrokerSubsystemDefinition.CUSTOM_CONFIG_ATTRIBDEF.validateAndSet(operation, model);
        BrokerSubsystemDefinition.CONNECTOR_NAME_ATTRIBDEF.validateAndSet(operation, model);
        BrokerSubsystemDefinition.CONNECTOR_PROTOCOL_ATTRIBDEF.validateAndSet(operation, model);
        BrokerSubsystemDefinition.SOCKET_BINDING_ATTRIBDEF.validateAndSet(operation, model);
        BrokerSubsystemDefinition.DISCOVERY_SOCKET_BINDING_ATTRIBDEF.validateAndSet(operation, model);
        this.log.debugf("Populating the Broker subsystem model: [%s=%s]", (Object)operation, (Object)model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        boolean enabled = BrokerSubsystemDefinition.BROKER_ENABLED_ATTRIBDEF.resolveModelAttribute(context, model).asBoolean(false);
        if (!enabled) {
            this.msglog.infoBrokerNotEnabled();
            return;
        }
        String configFile = BrokerSubsystemDefinition.BROKER_CONFIG_FILE_ATTRIBDEF.resolveModelAttribute(context, model).asString();
        if (configFile == null || configFile.trim().isEmpty()) {
            configFile = "default-broker.xml";
        }
        this.msglog.infoBrokerEnabledWithConfigFile(configFile);
        HashMap<String, String> customConfigProps = new HashMap<String, String>();
        this.addCustomConfigProperty(context, model, customConfigProps, (AttributeDefinition)BrokerSubsystemDefinition.BROKER_NAME_ATTRIBDEF);
        this.addCustomConfigProperty(context, model, customConfigProps, (AttributeDefinition)BrokerSubsystemDefinition.BROKER_PERSISTENT_ATTRIBDEF);
        this.addCustomConfigProperty(context, model, customConfigProps, (AttributeDefinition)BrokerSubsystemDefinition.BROKER_USE_JMX_ATTRIBDEF);
        this.addCustomConfigProperty(context, model, customConfigProps, (AttributeDefinition)BrokerSubsystemDefinition.CONNECTOR_NAME_ATTRIBDEF);
        this.addCustomConfigProperty(context, model, customConfigProps, (AttributeDefinition)BrokerSubsystemDefinition.CONNECTOR_PROTOCOL_ATTRIBDEF);
        ModelNode customConfigNode = BrokerSubsystemDefinition.CUSTOM_CONFIG_ATTRIBDEF.resolveModelAttribute(context, model);
        if (customConfigNode != null && customConfigNode.isDefined()) {
            HashMap<String, String> customConfig = new HashMap<String, String>();
            List propList = customConfigNode.asPropertyList();
            for (Property prop : propList) {
                String name = prop.getName();
                String val = prop.getValue().asString();
                customConfig.put(name, val);
            }
            customConfigProps.putAll(customConfig);
        }
        BrokerService service = new BrokerService();
        service.setConfigurationFile(configFile);
        service.setCustomConfigurationProperties(customConfigProps);
        String binding = BrokerSubsystemDefinition.SOCKET_BINDING_ATTRIBDEF.resolveModelAttribute(context, model).asString();
        String discoveryBinding = BrokerSubsystemDefinition.DISCOVERY_SOCKET_BINDING_ATTRIBDEF.resolveModelAttribute(context, model).asString();
        ServiceName name = BrokerService.SERVICE_NAME;
        ServiceController controller = context.getServiceTarget().addService(name, (Service)service).addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, service.envServiceValue).addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{binding}), SocketBinding.class, service.connectorSocketBinding).addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{discoveryBinding}), SocketBinding.class, service.discoverySocketBinding).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install();
        newControllers.add(controller);
    }

    private void addCustomConfigProperty(OperationContext context, ModelNode model, Map<String, String> customConfigProps, AttributeDefinition attribDef) throws OperationFailedException {
        this.addCustomConfigProperty(context, model, customConfigProps, attribDef, null);
    }

    private void addCustomConfigProperty(OperationContext context, ModelNode model, Map<String, String> customConfigProps, AttributeDefinition attribDef, String customConfigPropName) throws OperationFailedException {
        ModelNode node = attribDef.resolveModelAttribute(context, model);
        if (node.isDefined()) {
            customConfigProps.put(customConfigPropName == null ? attribDef.getName() : customConfigPropName, node.asString());
        }
    }
}

