/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.bus.broker;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.net.URI;
import java.util.Arrays;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.hawkular.bus.broker.log.MsgLogger;
import org.jboss.logging.Logger;

public class EmbeddedBroker {
    private final MsgLogger msglog = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(EmbeddedBroker.class);
    private InitializationParameters initialParameters;
    private BrokerService brokerService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            throw new IllegalArgumentException("Missing arguments. Please specify configuration properties file.");
        }
        EmbeddedBroker embeddedBroker = new EmbeddedBroker(args);
        embeddedBroker.startBroker();
        String[] stringArray = args;
        synchronized (args) {
            args.wait();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public EmbeddedBroker(String[] cmdlineArgs) throws Exception {
        InitializationParameters initParams = this.processArguments(cmdlineArgs);
        this.setInitializationParameters(initParams);
        this.initializeBrokerService();
    }

    public EmbeddedBroker(InitializationParameters initParams) throws Exception {
        this.setInitializationParameters(initParams);
        this.initializeBrokerService();
    }

    public boolean isBrokerStarted() {
        BrokerService broker = this.getBrokerService();
        if (broker == null) {
            return false;
        }
        return broker.isStarted();
    }

    public void startBroker() throws Exception {
        BrokerService broker = this.getBrokerService();
        if (broker == null) {
            throw new IllegalStateException("Broker was not initialized");
        }
        this.msglog.infoStartingBroker();
        broker.start();
        this.msglog.infoStartedBroker();
    }

    public void stopBroker() throws Exception {
        BrokerService broker = this.getBrokerService();
        if (broker == null) {
            return;
        }
        try {
            this.msglog.infoStoppingBroker();
            broker.stop();
            this.msglog.infoStoppedBroker();
        }
        finally {
            this.setBrokerService(null);
        }
    }

    protected InitializationParameters getInitializationParameters() {
        return this.initialParameters;
    }

    protected void setInitializationParameters(InitializationParameters ip) {
        this.initialParameters = ip;
    }

    protected void initializeBrokerService() throws Exception {
        if (this.getBrokerService() != null) {
            throw new IllegalStateException("Broker is already initialized");
        }
        InitializationParameters initParams = this.getInitializationParameters();
        if (initParams == null) {
            throw new IllegalStateException("Missing initialization parameters");
        }
        BrokerService broker = BrokerFactory.createBroker((URI)initParams.configFile, (boolean)false);
        this.setBrokerService(broker);
        this.msglog.infoInitializedBroker();
    }

    protected void setBrokerService(BrokerService broker) {
        this.brokerService = broker;
    }

    protected BrokerService getBrokerService() {
        return this.brokerService;
    }

    protected InitializationParameters processArguments(String[] cmdlineArgs) throws Exception {
        int code;
        this.log.debugf("Processing arguments: %s", Arrays.asList(cmdlineArgs));
        String configFileArg = null;
        String sopts = "-:hD:c:";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("help", 0, null, 104), new LongOpt("config", 1, null, 99)};
        Getopt getopt = new Getopt("hawkular-bus-broker", cmdlineArgs, sopts, lopts);
        while ((code = getopt.getopt()) != -1) {
            switch (code) {
                case 58: 
                case 63: {
                    this.displayUsage();
                    throw new IllegalArgumentException("Invalid argument(s)");
                }
                case 1: {
                    System.err.println("Unused argument: " + getopt.getOptarg());
                    break;
                }
                case 104: {
                    this.displayUsage();
                    throw new HelpException("Help displayed");
                }
                case 68: {
                    String value;
                    String name;
                    String sysprop = getopt.getOptarg();
                    int i = sysprop.indexOf("=");
                    if (i == -1) {
                        name = sysprop;
                        value = "true";
                    } else {
                        name = sysprop.substring(0, i);
                        value = sysprop.substring(i + 1, sysprop.length());
                    }
                    System.setProperty(name, value);
                    this.log.debugf("System property set: %s=%s", (Object)name, (Object)value);
                    break;
                }
                case 99: {
                    configFileArg = getopt.getOptarg();
                }
            }
        }
        if (configFileArg == null) {
            throw new IllegalArgumentException("Missing configuration file (-c)");
        }
        configFileArg = configFileArg.replace("\\", "/");
        InitializationParameters initParamsFromArguments = new InitializationParameters();
        if (configFileArg.endsWith(".properties") && !configFileArg.startsWith("properties:")) {
            configFileArg = "properties:" + configFileArg;
        } else if (configFileArg.endsWith(".xml") && !configFileArg.startsWith("xbean:")) {
            configFileArg = "xbean:" + configFileArg;
        }
        initParamsFromArguments.configFile = new URI(configFileArg);
        return initParamsFromArguments;
    }

    private void displayUsage() {
        StringBuilder str = new StringBuilder();
        str.append("Options:").append("\n");
        str.append("\t--help, -h: Displays this help text.").append("\n");
        str.append("\t-Dname=value: Sets a system property.").append("\n");
        str.append("\t--config=<file>, -c: Specifies the file used to configure the broker.").append("\n");
        this.msglog.infoUsage(str.toString());
    }

    public static class InitializationParameters {
        public URI configFile;
    }

    private class HelpException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public HelpException(String msg) {
            super(msg);
        }
    }
}

