
package org.hawkular.bus.sample.msg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.hawkular.bus.common.BasicMessage;


/**
 * A person.
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "firstName",
    "lastName",
    "age",
    "favoriteColors",
    "books",
    "address",
    "phoneNumbers"
})
public class Person
    extends BasicMessage
{

    @JsonProperty("firstName")
    private String firstName;
    @JsonProperty("lastName")
    private String lastName;
    /**
     * Age in years.
     * 
     */
    @JsonProperty("age")
    private Integer age;
    /**
     * A set of colors that this person likes.
     * 
     */
    @JsonProperty("favoriteColors")
    @JsonDeserialize(as = java.util.LinkedHashSet.class)
    private Set<String> favoriteColors = new LinkedHashSet<String>();
    /**
     * A list of books owned by this person.
     * 
     */
    @JsonProperty("books")
    private List<String> books = new ArrayList<String>();
    /**
     * The home address of this person.
     * 
     */
    @JsonProperty("address")
    private Address address;
    /**
     * Phone numbers associated with this person.
     * 
     */
    @JsonProperty("phoneNumbers")
    @JsonDeserialize(as = java.util.LinkedHashSet.class)
    private Set<PhoneNumber> phoneNumbers = new LinkedHashSet<PhoneNumber>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * 
     * @return
     *     The firstName
     */
    @JsonProperty("firstName")
    public String getFirstName() {
        return firstName;
    }

    /**
     * 
     * @param firstName
     *     The firstName
     */
    @JsonProperty("firstName")
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    /**
     * 
     * @return
     *     The lastName
     */
    @JsonProperty("lastName")
    public String getLastName() {
        return lastName;
    }

    /**
     * 
     * @param lastName
     *     The lastName
     */
    @JsonProperty("lastName")
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    /**
     * Age in years.
     * 
     * @return
     *     The age
     */
    @JsonProperty("age")
    public Integer getAge() {
        return age;
    }

    /**
     * Age in years.
     * 
     * @param age
     *     The age
     */
    @JsonProperty("age")
    public void setAge(Integer age) {
        this.age = age;
    }

    /**
     * A set of colors that this person likes.
     * 
     * @return
     *     The favoriteColors
     */
    @JsonProperty("favoriteColors")
    public Set<String> getFavoriteColors() {
        return favoriteColors;
    }

    /**
     * A set of colors that this person likes.
     * 
     * @param favoriteColors
     *     The favoriteColors
     */
    @JsonProperty("favoriteColors")
    public void setFavoriteColors(Set<String> favoriteColors) {
        this.favoriteColors = favoriteColors;
    }

    /**
     * A list of books owned by this person.
     * 
     * @return
     *     The books
     */
    @JsonProperty("books")
    public List<String> getBooks() {
        return books;
    }

    /**
     * A list of books owned by this person.
     * 
     * @param books
     *     The books
     */
    @JsonProperty("books")
    public void setBooks(List<String> books) {
        this.books = books;
    }

    /**
     * The home address of this person.
     * 
     * @return
     *     The address
     */
    @JsonProperty("address")
    public Address getAddress() {
        return address;
    }

    /**
     * The home address of this person.
     * 
     * @param address
     *     The address
     */
    @JsonProperty("address")
    public void setAddress(Address address) {
        this.address = address;
    }

    /**
     * Phone numbers associated with this person.
     * 
     * @return
     *     The phoneNumbers
     */
    @JsonProperty("phoneNumbers")
    public Set<PhoneNumber> getPhoneNumbers() {
        return phoneNumbers;
    }

    /**
     * Phone numbers associated with this person.
     * 
     * @param phoneNumbers
     *     The phoneNumbers
     */
    @JsonProperty("phoneNumbers")
    public void setPhoneNumbers(Set<PhoneNumber> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
