/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.bus.sample.client;

import java.util.HashMap;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.bus.common.BasicMessageWithExtraData;
import org.hawkular.bus.common.ConnectionContextFactory;
import org.hawkular.bus.common.Endpoint;
import org.hawkular.bus.common.MessageProcessor;
import org.hawkular.bus.common.consumer.AbstractBasicMessageListener;
import org.hawkular.bus.common.consumer.BasicMessageListener;
import org.hawkular.bus.common.consumer.ConsumerConnectionContext;
import org.hawkular.bus.common.producer.ProducerConnectionContext;
import org.hawkular.bus.sample.msg.Address;
import org.hawkular.bus.sample.msg.Person;
import org.hawkular.bus.sample.msg.PhoneNumber;

public class Main {
    private static final String BROKER_URL = "vm://mybroker?broker.persistent=false";
    private static final Endpoint ENDPOINT = new Endpoint(Endpoint.Type.QUEUE, "myqueue");

    public static void main(String[] args) throws Exception {
        try (Consumer consumer = new Consumer();
             Producer producer = new Producer();){
            consumer.consume();
            producer.produce();
            Thread.sleep(1000L);
        }
    }

    private static class Producer
    implements AutoCloseable {
        ConnectionContextFactory cachedFactory;

        private Producer() {
        }

        public void produce() throws Exception {
            ConnectionContextFactory factory = new ConnectionContextFactory(Main.BROKER_URL);
            ProducerConnectionContext pc = factory.createProducerConnectionContext(ENDPOINT);
            Person person = new Person();
            person.setAge(18);
            person.setFirstName("John");
            person.setLastName("Doe");
            person.setTitle(Person.Title.DR);
            person.getFavoriteColors().add("blue");
            person.getFavoriteColors().add("yellow");
            Address address = new Address();
            address.setStreet("Main Street");
            address.setCity("Anyplace, Kansas");
            person.setAddress(address);
            PhoneNumber phone1 = new PhoneNumber();
            phone1.setKind("home");
            phone1.setDigits("555-1212");
            PhoneNumber phone2 = new PhoneNumber();
            phone2.setKind("cell");
            phone2.setDigits("800-WOT-GORILLA");
            person.getPhoneNumbers().add(phone1);
            person.getPhoneNumbers().add(phone2);
            person.setHobbies(new HashMap<String, Number>(3));
            person.getHobbies().put("golf", 6);
            person.getHobbies().put("cooking", 3);
            person.getHobbies().put("tennis", 4);
            MessageProcessor processor = new MessageProcessor();
            processor.send(pc, (BasicMessage)person);
            this.cachedFactory = factory;
        }

        @Override
        public void close() throws Exception {
            this.cachedFactory.close();
        }
    }

    private static class Consumer
    implements AutoCloseable {
        ConnectionContextFactory cachedFactory;

        private Consumer() {
        }

        public void consume() throws Exception {
            ConnectionContextFactory factory = new ConnectionContextFactory(Main.BROKER_URL);
            ConsumerConnectionContext context = factory.createConsumerConnectionContext(ENDPOINT);
            BasicMessageListener<Person> listener = new BasicMessageListener<Person>(){

                protected void onBasicMessage(BasicMessageWithExtraData<Person> personWithExtraData) {
                    Person person = (Person)personWithExtraData.getBasicMessage();
                    System.out.println("\n========== RECEIVED MESSAGE START ==========");
                    System.out.println("Consumed Person:");
                    System.out.printf("title=[%s], firstN=[%s], lastN=[%s], age=[%d], address.street=[%s], hobbies=[%s]\n", new Object[]{person.getTitle(), person.getFirstName(), person.getLastName(), person.getAge(), person.getAddress().getStreet(), person.getHobbies()});
                    System.out.println("Consumed Person.toString: " + person.toString());
                    System.out.println("Consumed Person.toJSON: " + person.toJSON());
                    System.out.println("Consumed Person.hashCode: " + ((Object)((Object)person)).hashCode());
                    System.out.println("========== RECEIVED MESSAGE END ==========\n");
                }
            };
            MessageProcessor processor = new MessageProcessor();
            processor.listen(context, (AbstractBasicMessageListener)listener);
            this.cachedFactory = factory;
        }

        @Override
        public void close() throws Exception {
            this.cachedFactory.close();
        }
    }
}

