/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.bus.common.test;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.bus.common.BasicMessageWithExtraData;
import org.hawkular.bus.common.consumer.BasicMessageListener;

public class MessageWithExtraDataTestListener<T extends BasicMessage>
extends BasicMessageListener<T> {
    private CountDownLatch latch = new CountDownLatch(1);
    public BasicMessageWithExtraData<T> message;

    public MessageWithExtraDataTestListener(Class<T> clazz) {
        super(clazz);
    }

    public boolean waitForMessage(long secs) throws InterruptedException {
        return this.latch.await(secs, TimeUnit.SECONDS);
    }

    public BasicMessageWithExtraData<T> getReceivedMessageWithExtraData() {
        BasicMessageWithExtraData<T> result = null;
        if (this.message != null) {
            result = this.message;
            this.latch = new CountDownLatch(1);
            this.message = null;
        }
        return result;
    }

    protected void onBasicMessage(BasicMessageWithExtraData<T> message) {
        this.message = message;
        this.latch.countDown();
    }
}

