/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.feedcomm.ws;

import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;

@MessageLogger(projectCode="HAWKFEEDCOMM")
@ValidIdRange(min=1, max=5000)
public interface MsgLogger
extends BasicLogger {
    public static final MsgLogger LOG = (MsgLogger)Logger.getMessageLogger(MsgLogger.class, (String)"org.hawkular.feedcomm.ws");

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1, value="Feed [%s] provided an invalid command request: [%s]")
    public void errorInvalidCommandRequestFeed(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=2, value="Failed to execute command [%s] for feed [%s]")
    public void errorCommandExecutionFailureFeed(String var1, String var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3, value="A feed [%s] opened multiple sessions. This is a violation; closing the extra session")
    public void errorClosingExtraFeedSession(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=4, value="Cannot close the extra session created by feed [%s]")
    public void errorCannotCloseExtraFeedSession(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5, value="UI client session [%s] provided an invalid command request: [%s]")
    public void errorInvalidCommandRequestUIClient(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=6, value="Failed to execute command [%s] for UI client session [%s]")
    public void errorCommandExecutionFailureUIClient(String var1, String var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=7, value="Cannot process an execute-operation message")
    public void errorCannotProcessExecuteOperationMessage(@Cause Exception var1);
}

