/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.feedcomm.ws.server;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import javax.websocket.CloseReason;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.feedcomm.api.ApiDeserializer;
import org.hawkular.feedcomm.api.GenericErrorResponse;
import org.hawkular.feedcomm.api.GenericErrorResponseBuilder;
import org.hawkular.feedcomm.ws.MsgLogger;
import org.hawkular.feedcomm.ws.command.Command;
import org.hawkular.feedcomm.ws.command.CommandContext;
import org.hawkular.feedcomm.ws.command.EchoCommand;
import org.hawkular.feedcomm.ws.server.ConnectedFeeds;
import org.hawkular.feedcomm.ws.server.ConnectedUIClients;
import org.hawkular.feedcomm.ws.server.FeedListenerGenerator;

@ServerEndpoint(value="/feed/{feedId}")
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class FeedCommWebSocket {
    private static final Map<String, Class<? extends Command<?, ?>>> VALID_COMMANDS = new HashMap();
    @Inject
    private ConnectedFeeds connectedFeeds;
    @Inject
    private ConnectedUIClients connectedUIClients;
    @Inject
    private FeedListenerGenerator feedListenerGenerator;

    @OnOpen
    public void feedSessionOpen(Session session, @PathParam(value="feedId") String feedId) {
        MsgLogger.LOG.infof("Feed [%s] session opened", (Object)feedId);
        boolean successfullyAddedSession = this.connectedFeeds.addSession(feedId, session);
        if (successfullyAddedSession) {
            try {
                this.feedListenerGenerator.addListeners(feedId);
            }
            catch (Exception e) {
                MsgLogger.LOG.errorf((Throwable)e, "Failed to add message listeners for feed [%s]. Closing session [%s]", (Object)feedId, (Object)session.getId());
                try {
                    session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.UNEXPECTED_CONDITION, "Internal server error"));
                }
                catch (IOException ioe) {
                    MsgLogger.LOG.errorf((Throwable)ioe, "Failed to close feed [%s] session [%s] after internal server error", (Object)feedId, (Object)session.getId());
                }
            }
        }
    }

    @OnMessage
    public String feedMessage(String nameAndJsonStr, Session session, @PathParam(value="feedId") String feedId) {
        GenericErrorResponse response;
        MsgLogger.LOG.infof("Received message from feed [%s]", (Object)feedId);
        String requestClassName = "?";
        try {
            BasicMessage request = new ApiDeserializer().deserialize(nameAndJsonStr);
            requestClassName = request.getClass().getName();
            Class commandClass = (Class)VALID_COMMANDS.get(requestClassName);
            if (commandClass == null) {
                MsgLogger.LOG.errorInvalidCommandRequestFeed(feedId, requestClassName);
                String errorMessage = "Invalid command request: " + requestClassName;
                response = new GenericErrorResponseBuilder().setErrorMessage(errorMessage).build();
            } else {
                CommandContext context = new CommandContext(this.connectedFeeds, this.connectedUIClients, this.feedListenerGenerator.getConnectionFactory());
                Command command = (Command)commandClass.newInstance();
                response = command.execute(request, context);
            }
        }
        catch (Throwable t) {
            MsgLogger.LOG.errorCommandExecutionFailureFeed(requestClassName, feedId, t);
            String errorMessage = "Command failed[" + requestClassName + "]";
            response = new GenericErrorResponseBuilder().setThrowable(t).setErrorMessage(errorMessage).build();
        }
        String responseText = response == null ? null : ApiDeserializer.toHawkularFormat((BasicMessage)response);
        return responseText;
    }

    @OnClose
    public void feedSessionClose(Session session, CloseReason reason, @PathParam(value="feedId") String feedId) {
        boolean removed;
        MsgLogger.LOG.infof("Feed [%s] session closed. Reason=[%s]", (Object)feedId, (Object)reason);
        boolean bl = removed = this.connectedFeeds.removeSession(feedId, session) != null;
        if (removed) {
            this.feedListenerGenerator.removeListeners(feedId);
        }
    }

    static {
        VALID_COMMANDS.put(EchoCommand.REQUEST_CLASS.getName(), EchoCommand.class);
    }
}

