/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.feedcomm.ws;

import javax.websocket.CloseReason;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;

@MessageLogger(projectCode="HAWKFEEDCOMM")
@ValidIdRange(min=1, max=5000)
public interface MsgLogger
extends BasicLogger {
    public static final MsgLogger LOG = (MsgLogger)Logger.getMessageLogger(MsgLogger.class, (String)"org.hawkular.feedcomm.ws");

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1, value="Feed [%s] provided an invalid command request: [%s]")
    public void errorInvalidCommandRequestFeed(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=2, value="Failed to execute command [%s] for feed [%s]")
    public void errorCommandExecutionFailureFeed(String var1, String var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3, value="A feed [%s] opened multiple sessions. This is a violation; closing the extra session")
    public void errorClosingExtraFeedSession(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=4, value="Cannot close the extra session created by feed [%s]")
    public void errorCannotCloseExtraFeedSession(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5, value="UI client [%s] (session [%s]) provided an invalid command request: [%s]")
    public void errorInvalidCommandRequestUIClient(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=6, value="Failed to execute command [%s] for UI client [%s] (session [%s])")
    public void errorCommandExecutionFailureUIClient(String var1, String var2, String var3, @Cause Throwable var4);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=7, value="Cannot process an execute-operation message")
    public void errorCannotProcessExecuteOperationMessage(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=8, value="Received the following error message and stack trace from remote endpoint: %s\n%s")
    public void warnReceivedGenericErrorResponse(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=9, value="Feed [%s] session opened [%s]")
    public void infoFeedSessionOpened(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=10, value="Failed to add message listeners for feed [%s]. Closing session [%s]")
    public void errorFailedToAddMessageListenersForFeed(String var1, String var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=11, value="Received message from feed [%s]")
    public void infoReceivedMessageFromFeed(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=12, value="Feed [%s] session closed. Reason=[%s]")
    public void infoFeedSessionClosed(String var1, CloseReason var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=13, value="UI client session [%s] opened")
    public void infoUIClientSessionOpened(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=14, value="Received message from UI client [%s] (session [%s])")
    public void infoReceivedMessageFromUIClient(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=15, value="UI client [%s] (session [%s]) closed. Reason=[%s]")
    public void infoUISessionClosed(String var1, String var2, CloseReason var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=16, value="Adding listeners for feed [%s]")
    public void infoAddingListenersForFeed(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=17, value="Failed to close consumer context; will keep trying to close the rest")
    public void errorFailedClosingConsumerContext(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=18, value="Removing listeners for feed [%s]")
    public void infoRemovingListenersForFeed(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=19, value="Failed to removing listeners for feed [%s]")
    public void errorFailedRemovingListenersForFeed(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=20, value="Received binary data from feed [%s]")
    public void infoReceivedBinaryDataFromFeed(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=21, value="Received binary data from UI client [%s]")
    public void infoReceivedBinaryDataFromUIClient(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=22, value="Adding listeners for UI client [%s]")
    public void infoAddingListenersForUIClient(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=23, value="Removing listeners for UI client [%s]")
    public void infoRemovingListenersForUIClient(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=24, value="Failed to removing listeners for UI client [%s]")
    public void errorFailedRemovingListenersForUIClient(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=25, value="Failed to add message listeners for UI client [%s]. Closing session [%s]")
    public void errorFailedToAddMessageListenersForUIClient(String var1, String var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=26, value="Cannot process an execute-operation-response message")
    public void errorCannotProcessExecuteOperationResponseMessage(@Cause Throwable var1);
}

